/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.nodemodel.impl.SerializableNodeModel;
import org.eclipse.xtext.nodemodel.serialization.SerializationConversionContext;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@FinalFieldsConstructor
public class ResourceStorageWritable {
    private final OutputStream out;
    private final boolean storeNodeModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResource(StorageAwareResource resource) throws IOException {
        boolean _isLoadedFromStorage = resource.isLoadedFromStorage();
        if (_isLoadedFromStorage) {
            URI _uRI = resource.getURI();
            String _plus = "cannot write resources loaded from storage. URI was " + _uRI;
            throw new IllegalStateException(_plus);
        }
        try (ZipOutputStream zipOut = new ZipOutputStream(this.out);){
            this.writeEntries(resource, zipOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeEntries(StorageAwareResource resource, ZipOutputStream zipOut) throws IOException {
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(zipOut);
        ZipEntry _zipEntry = new ZipEntry("emf-contents");
        zipOut.putNextEntry(_zipEntry);
        try {
            this.writeContents(resource, bufferedOutput);
        }
        finally {
            bufferedOutput.flush();
            zipOut.closeEntry();
        }
        ZipEntry _zipEntry_1 = new ZipEntry("resource-description");
        zipOut.putNextEntry(_zipEntry_1);
        try {
            this.writeResourceDescription(resource, bufferedOutput);
        }
        finally {
            bufferedOutput.flush();
            zipOut.closeEntry();
        }
        if (this.storeNodeModel) {
            ZipEntry _zipEntry_2 = new ZipEntry("node-model");
            zipOut.putNextEntry(_zipEntry_2);
            try {
                this.writeNodeModel(resource, bufferedOutput);
            }
            finally {
                bufferedOutput.flush();
                zipOut.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContents(final StorageAwareResource storageAwareResource, OutputStream outputStream) throws IOException {
        Map _emptyMap = CollectionLiterals.emptyMap();
        BinaryResourceImpl.EObjectOutputStream out = new BinaryResourceImpl.EObjectOutputStream(outputStream, _emptyMap){

            @Override
            public void writeURI(URI uri, String fragment) throws IOException {
                URI fullURI = uri.appendFragment(fragment);
                URI _elvis = null;
                URI _portableURI = storageAwareResource.getPortableURIs().toPortableURI(storageAwareResource, fullURI);
                _elvis = _portableURI != null ? _portableURI : fullURI;
                URI uriToWrite = _elvis;
                super.writeURI(uriToWrite.trimFragment(), uriToWrite.fragment());
            }

            @Override
            public void saveEObject(InternalEObject internalEObject, BinaryResourceImpl.EObjectOutputStream.Check check) throws IOException {
                ResourceStorageWritable.this.beforeSaveEObject(internalEObject, this);
                super.saveEObject(internalEObject, check);
                ResourceStorageWritable.this.handleSaveEObject(internalEObject, this);
            }
        };
        try {
            out.saveResource(storageAwareResource);
        }
        finally {
            out.flush();
        }
    }

    protected Object beforeSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream writable) throws IOException {
        return null;
    }

    protected void handleSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream out) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResourceDescription(StorageAwareResource resource, OutputStream outputStream) throws IOException {
        IResourceDescription description = resource.getResourceServiceProvider().getResourceDescriptionManager().getResourceDescription(resource);
        SerializableResourceDescription serializableDescription = SerializableResourceDescription.createCopy(description);
        this.convertExternalURIsToPortableURIs(serializableDescription, resource);
        ObjectOutputStream out = new ObjectOutputStream(outputStream);
        try {
            out.writeObject(serializableDescription);
        }
        finally {
            out.flush();
        }
    }

    protected void convertExternalURIsToPortableURIs(SerializableResourceDescription description, StorageAwareResource resource) {
        Iterable<IReferenceDescription> _referenceDescriptions = description.getReferenceDescriptions();
        for (IReferenceDescription ref : _referenceDescriptions) {
            URI _targetEObjectUri;
            URI _uRI;
            URI _trimFragment = ref.getTargetEObjectUri().trimFragment();
            boolean _notEquals = !Objects.equal(_trimFragment, _uRI = resource.getURI());
            if (!_notEquals) continue;
            URI _elvis = null;
            URI _portableURI = resource.getPortableURIs().toPortableURI(resource, ref.getTargetEObjectUri());
            _elvis = _portableURI != null ? _portableURI : (_targetEObjectUri = ref.getTargetEObjectUri());
            ((SerializableReferenceDescription)ref).setTargetEObjectUri(_elvis);
        }
    }

    protected void writeNodeModel(StorageAwareResource resource, OutputStream outputStream) throws IOException {
        DataOutputStream out = new DataOutputStream(outputStream);
        SerializableNodeModel serializableNodeModel = new SerializableNodeModel(resource);
        SerializationConversionContext conversionContext = new SerializationConversionContext(resource);
        serializableNodeModel.writeObjectData(out, conversionContext);
        out.flush();
    }

    public ResourceStorageWritable(OutputStream out, boolean storeNodeModel) {
        this.out = out;
        this.storeNodeModel = storeNodeModel;
    }
}

