/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.primitives.Booleans;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtCompatible
public class BooleanExtensions {
    @Pure
    @Inline(value="($1 && $2)", constantExpression=true)
    public static boolean operator_and(boolean a, boolean b) {
        return a && b;
    }

    @Pure
    @Inline(value="($1 || $2)", constantExpression=true)
    public static boolean operator_or(boolean a, boolean b) {
        return a || b;
    }

    @Pure
    @Inline(value="(!$1)", constantExpression=true)
    public static boolean operator_not(boolean b) {
        return !b;
    }

    @Pure
    @Inline(value="($1 == $2)", constantExpression=true)
    public static boolean operator_equals(boolean a, boolean b) {
        return a == b;
    }

    @Pure
    @Inline(value="($1 != $2)", constantExpression=true)
    public static boolean operator_notEquals(boolean a, boolean b) {
        return a != b;
    }

    @Pure
    @Inline(value="($1 ^ $2)")
    public static boolean xor(boolean a, boolean b) {
        return a ^ b;
    }

    @Pure
    @Inline(value="($3.compare($1, $2) < 0)", imported={Booleans.class})
    public static boolean operator_lessThan(boolean a, boolean b) {
        return Booleans.compare(a, b) < 0;
    }

    @Pure
    @Inline(value="($3.compare($1, $2) <= 0)", imported={Booleans.class})
    public static boolean operator_lessEqualsThan(boolean a, boolean b) {
        return Booleans.compare(a, b) <= 0;
    }

    @Pure
    @Inline(value="($3.compare($1, $2) > 0)", imported={Booleans.class})
    public static boolean operator_greaterThan(boolean a, boolean b) {
        return Booleans.compare(a, b) > 0;
    }

    @Pure
    @Inline(value="($3.compare($1, $2) >= 0)", imported={Booleans.class})
    public static boolean operator_greaterEqualsThan(boolean a, boolean b) {
        return Booleans.compare(a, b) >= 0;
    }
}

