/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;

public class BatchLinkingService {
    @Inject
    private IBatchScopeProvider batchScopeProvider;
    @Inject
    private IBatchTypeResolver batchTypeResolver;

    public boolean isBatchLinkable(EReference reference) {
        return this.batchScopeProvider.isBatchScopeable(reference);
    }

    public EObject resolveBatched(EObject context, EReference reference, String uriFragment) {
        return this.resolveBatched(context, reference, uriFragment, CancelIndicator.NullImpl);
    }

    public void resolveBatched(EObject root) {
        this.resolveBatched(root, CancelIndicator.NullImpl);
    }

    public EObject resolveBatched(EObject context, EReference reference, String uriFragment, CancelIndicator monitor) {
        if (reference.isMany()) {
            throw new IllegalArgumentException("Not yet implemented for #many references");
        }
        this.batchTypeResolver.resolveTypes(context, monitor);
        EObject result = (EObject)context.eGet(reference, false);
        if (result.eIsProxy()) {
            return null;
        }
        return result;
    }

    public void resolveBatched(EObject root, CancelIndicator monitor) {
        this.batchTypeResolver.resolveTypes(root, monitor);
    }
}

