/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ITypeLiteralLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.TypeLiteralHelper;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.TypeLiteralLinkingCandidateResolver;

public class TypeLiteralLinkingCandidate
extends AbstractPendingLinkingCandidate<XAbstractFeatureCall>
implements ITypeLiteralLinkingCandidate {
    private TypeLiteralHelper helper;

    public TypeLiteralLinkingCandidate(XAbstractFeatureCall featureCall, IIdentifiableElementDescription description, ITypeExpectation expectation, final ExpressionTypeComputationState state) {
        super(featureCall, description, expectation, state, new TypeLiteralLinkingCandidateResolver(featureCall){

            @Override
            protected IFeatureLinkingCandidate getLinkingCandidate(XExpression target) {
                return state.getResolvedTypes().getLinkingCandidate((XAbstractFeatureCall)target);
            }
        });
        if (featureCall.isExplicitOperationCallOrBuilderSyntax()) {
            throw new IllegalArgumentException("Cannot be a type literal: " + String.valueOf(featureCall));
        }
        this.helper = new TypeLiteralHelper(state);
    }

    @Override
    public void computeArgumentTypes() {
    }

    @Override
    protected ILinkingCandidate createAmbiguousLinkingCandidate(AbstractPendingLinkingCandidate<?> second) {
        return this;
    }

    @Override
    protected List<XExpression> getArguments() {
        return Collections.emptyList();
    }

    @Override
    protected String getFeatureTypeName() {
        return "type";
    }

    @Override
    public int getArityMismatch() {
        return 0;
    }

    @Override
    protected List<XExpression> getSyntacticArguments() {
        return Collections.emptyList();
    }

    @Override
    public boolean isExtension() {
        return false;
    }

    @Override
    protected boolean hasReceiver() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isTypeLiteral() {
        return true;
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<JvmTypeReference> getPlainSyntacticTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    protected int getConformanceFlags(int idx, boolean recompute) {
        if (idx == -1) {
            return 0x100200;
        }
        return super.getConformanceFlags(idx, recompute);
    }

    @Override
    protected LightweightTypeReference getSubstitutedExpectedType(int argumentIndex) {
        return null;
    }

    @Override
    protected boolean validateTypeArity(IAcceptor<? super AbstractDiagnostic> result) {
        int numberOfTypeArgs = this.getFeatureCall().getTypeArguments().size();
        if (numberOfTypeArgs != 0) {
            String message = String.format("Invalid type %1$s. Type arguments cannot be applied to the type literal %2$s", numberOfTypeArgs == 1 ? "argument" : "arguments", this.getFeature().getSimpleName());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_arguments_on_type_literal", message, (EObject)this.getExpression(), XbasePackage.Literals.XABSTRACT_FEATURE_CALL__TYPE_ARGUMENTS, -1, null){
                ICompositeNode node;
                {
                    this.node = NodeModelUtils.getNode(TypeLiteralLinkingCandidate.this.getFeatureCall());
                }

                @Override
                public int getLength() {
                    for (INode child : this.node.getChildren()) {
                        EObject grammarElement = child.getGrammarElement();
                        if (!(grammarElement instanceof Keyword) || !">".equals(((Keyword)grammarElement).getValue())) continue;
                        return child.getEndOffset() - this.getOffset();
                    }
                    return 0;
                }

                @Override
                public int getOffset() {
                    for (INode child : this.node.getChildren()) {
                        EObject grammarElement = child.getGrammarElement();
                        if (!(grammarElement instanceof Keyword) || !"<".equals(((Keyword)grammarElement).getValue())) continue;
                        return child.getOffset();
                    }
                    return 0;
                }

                @Override
                public int getLine() {
                    for (INode child : this.node.getChildren()) {
                        EObject grammarElement = child.getGrammarElement();
                        if (!(grammarElement instanceof Keyword) || !"<".equals(((Keyword)grammarElement).getValue())) continue;
                        return child.getStartLine();
                    }
                    return 0;
                }
            };
            result.accept(diagnostic);
            return false;
        }
        return true;
    }

    @Override
    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        return this.helper.getAsClassLiteral(feature);
    }

    @Override
    protected List<JvmTypeParameter> getDeclaredTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public int getTypeArityMismatch() {
        return 0;
    }

    @Override
    protected int getTypeArgumentConformanceFailures(IAcceptor<? super AbstractDiagnostic> acceptor) {
        return 0;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    protected void preApply() {
        XAbstractFeatureCall expression = (XAbstractFeatureCall)this.getExpression();
        JvmType type = this.getType();
        if (expression instanceof XMemberFeatureCall && type instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)type;
            if (declaredType.getDeclaringType() == null) {
                this.helper.applyPackageFragment((XMemberFeatureCall)expression, declaredType);
            } else {
                String queriedName = this.description.getName().toString();
                String qualifiedName = declaredType.getIdentifier();
                String packageName = Strings.emptyIfNull(declaredType.getPackageName());
                if (packageName.length() + 1 + queriedName.length() == qualifiedName.length()) {
                    this.helper.applyPackageFragment((XMemberFeatureCall)expression, declaredType);
                }
            }
        }
    }

    @Override
    public JvmType getType() {
        return (JvmType)this.getFeature();
    }

    @Override
    public void applyToModel(IResolvedTypes resolvedTypes) {
        this.resolveLinkingProxy(XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
    }
}

