/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.IMirrorExtension;
import org.eclipse.xtext.common.types.access.JvmTypeChangeDispatcher;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.override.ParameterizedResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class RawResolvedFeatures
extends AbstractResolvedFeatures
implements Adapter,
IResolvedFeatures {
    private final Map<String, List<JvmFeature>> featureIndex = Maps.newHashMapWithExpectedSize(4);
    private boolean allFeaturesComputed = false;

    static RawResolvedFeatures getResolvedFeatures(JvmDeclaredType type, CommonTypeComputationServices services) {
        final EList<Adapter> adapterList = type.eAdapters();
        RawResolvedFeatures adapter = (RawResolvedFeatures)EcoreUtil.getAdapter(adapterList, RawResolvedFeatures.class);
        if (adapter != null) {
            return adapter;
        }
        final RawResolvedFeatures newAdapter = new RawResolvedFeatures(type, services);
        RawResolvedFeatures.requestNotificationOnChange(type, new Runnable(){

            @Override
            public void run() {
                newAdapter.clear();
                adapterList.remove(newAdapter);
            }
        });
        adapterList.add(newAdapter);
        return newAdapter;
    }

    protected static void requestNotificationOnChange(JvmType type, Runnable listener) {
        IMirror mirror;
        Resource resource = type.eResource();
        if (resource instanceof TypeResource && (mirror = ((TypeResource)resource).getMirror()) instanceof IMirrorExtension && ((IMirrorExtension)((Object)mirror)).isSealed()) {
            return;
        }
        Notifier notifier = type;
        if (resource != null) {
            notifier = resource.getResourceSet() != null ? resource.getResourceSet() : resource;
        }
        JvmTypeChangeDispatcher dispatcher = JvmTypeChangeDispatcher.findResourceChangeDispatcher(notifier);
        dispatcher.requestNotificationOnChange(type, listener);
    }

    private static LightweightTypeReference createTypeReference(JvmDeclaredType type, CommonTypeComputationServices services) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(services, type);
        return owner.newParameterizedTypeReference(type);
    }

    protected RawResolvedFeatures(JvmDeclaredType type, CommonTypeComputationServices services) {
        this(RawResolvedFeatures.createTypeReference(type, services), new OverrideTester());
    }

    protected RawResolvedFeatures(LightweightTypeReference type, OverrideTester overrideTester) {
        super(type, overrideTester);
    }

    @Override
    public IResolvedFeatures getParameterizedView(LightweightTypeReference concrete) {
        return new ParameterizedResolvedFeatures(concrete, this);
    }

    @Override
    public List<JvmFeature> getAllFeatures(String simpleName) {
        List<JvmFeature> result = this.featureIndex.get(simpleName);
        if (result == null) {
            result = this.computeAllFeatures(simpleName);
            this.featureIndex.put(simpleName, result);
        }
        return result;
    }

    @Override
    public List<JvmFeature> getAllFeatures() {
        if (!this.allFeaturesComputed) {
            ListMultimap<String, JvmFeature> featureIndex = this.computeAllFeatures();
            for (String string : featureIndex.keySet()) {
                this.featureIndex.put(string, Lists.newArrayList(featureIndex.get(string)));
            }
            this.allFeaturesComputed = true;
        }
        ArrayList<JvmFeature> result = Lists.newArrayList();
        for (List list : this.featureIndex.values()) {
            result.addAll(list);
        }
        return result;
    }

    protected List<JvmFeature> computeAllFeatures(String simpleName) {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        ArrayList<JvmFeature> result = Lists.newArrayList();
        HashMultimap<String, AbstractResolvedOperation> processed = HashMultimap.create();
        HashSet<String> processedFields = Sets.newHashSetWithExpectedSize(5);
        this.computeAllFeatures((JvmDeclaredType)rawType, simpleName, processed, processedFields, result);
        return Collections.unmodifiableList(result);
    }

    protected ListMultimap<String, JvmFeature> computeAllFeatures() {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmDeclaredType)) {
            return ArrayListMultimap.create();
        }
        ArrayListMultimap<String, JvmFeature> result = ArrayListMultimap.create();
        HashMultimap<String, AbstractResolvedOperation> processed = HashMultimap.create();
        HashSet<String> processedFields = Sets.newHashSetWithExpectedSize(5);
        this.computeAllFeatures((JvmDeclaredType)rawType, processed, processedFields, result, this.featureIndex.keySet());
        return Multimaps.unmodifiableListMultimap(result);
    }

    protected void computeAllFeatures(JvmDeclaredType type, Multimap<String, AbstractResolvedOperation> processedOperations, Set<String> processedFields, ListMultimap<String, JvmFeature> result, Set<String> seenNames) {
        Iterable<JvmFeature> features = type.getAllFeatures();
        for (JvmFeature feature : features) {
            if (seenNames.contains(feature.getSimpleName())) continue;
            if (feature instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)feature;
                String simpleName = operation.getSimpleName();
                if (processedOperations.containsKey(simpleName) && this.isOverridden(operation, processedOperations.get(simpleName))) continue;
                BottomResolvedOperation resolvedOperation = this.createResolvedOperation(operation);
                processedOperations.put(simpleName, resolvedOperation);
                result.put(simpleName, operation);
                continue;
            }
            if (!(feature instanceof JvmField) || !processedFields.add(feature.getSimpleName())) continue;
            result.put(feature.getSimpleName(), feature);
        }
    }

    protected void computeAllFeatures(JvmDeclaredType type, String name, Multimap<String, AbstractResolvedOperation> processedOperations, Set<String> processedFields, List<JvmFeature> result) {
        Iterable<JvmFeature> features = type.findAllFeaturesByName(name);
        for (JvmFeature feature : features) {
            if (feature instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)feature;
                String simpleName = operation.getSimpleName();
                if (processedOperations.containsKey(simpleName) && this.isOverridden(operation, processedOperations.get(simpleName))) continue;
                BottomResolvedOperation resolvedOperation = this.createResolvedOperation(operation);
                processedOperations.put(simpleName, resolvedOperation);
                result.add(operation);
                continue;
            }
            if (!(feature instanceof JvmField) || !processedFields.add(feature.getSimpleName())) continue;
            result.add(feature);
        }
    }

    @Override
    public void notifyChanged(Notification notification) {
    }

    @Override
    public Notifier getTarget() {
        return null;
    }

    @Override
    public void setTarget(Notifier newTarget) {
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return RawResolvedFeatures.class.equals(type);
    }

    private void clear() {
        this.featureIndex.clear();
        this.allFeaturesComputed = false;
    }
}

