/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen;

import com.db.plexus.interop.dsl.Application;
import com.db.plexus.interop.dsl.ConsumedMethod;
import com.db.plexus.interop.dsl.ConsumedService;
import com.db.plexus.interop.dsl.InteropOption;
import com.db.plexus.interop.dsl.ProvidedMethod;
import com.db.plexus.interop.dsl.ProvidedService;
import com.db.plexus.interop.dsl.RestrictionList;
import com.db.plexus.interop.dsl.WildcardRestriction;
import com.db.plexus.interop.dsl.protobuf.BoolConstant;
import com.db.plexus.interop.dsl.protobuf.ComplexFieldType;
import com.db.plexus.interop.dsl.protobuf.ComplexType;
import com.db.plexus.interop.dsl.protobuf.Constant;
import com.db.plexus.interop.dsl.protobuf.DecimalConstant;
import com.db.plexus.interop.dsl.protobuf.Enum;
import com.db.plexus.interop.dsl.protobuf.EnumConstant;
import com.db.plexus.interop.dsl.protobuf.Field;
import com.db.plexus.interop.dsl.protobuf.FieldTypeReference;
import com.db.plexus.interop.dsl.protobuf.IntConstant;
import com.db.plexus.interop.dsl.protobuf.Message;
import com.db.plexus.interop.dsl.protobuf.MessageElement;
import com.db.plexus.interop.dsl.protobuf.Method;
import com.db.plexus.interop.dsl.protobuf.Option;
import com.db.plexus.interop.dsl.protobuf.PrimitiveFieldType;
import com.db.plexus.interop.dsl.protobuf.Service;
import com.db.plexus.interop.dsl.protobuf.StringConstant;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class GenUtils {
    public static final String INTEROP_OPTIONS_RESOURCE_PATH = "interop/options.proto";
    public static final String INTEROP_DESCRIPTOR_RESOURCE_PATH = "interop/descriptor.proto";
    public static final String PROTOBUF_DESCRIPTOR_RESOURCE_PATH = "google/protobuf/descriptor.proto";
    public static final QualifiedName ROOT_PACKAGE_NAME = QualifiedName.create("");
    public static final QualifiedName INTEROP_PACKAGE_NAME = ROOT_PACKAGE_NAME.append("interop");
    public static final QualifiedName INTEROP_SERVICE_ID_OPTION_NAME = INTEROP_PACKAGE_NAME.append("service_id");
    public static final QualifiedName INTEROP_MESSAGE_ID_OPTION_NAME = INTEROP_PACKAGE_NAME.append("message_id");
    public static final QualifiedName INTEROP_PROVIDED_SERVICE_TITLE_OPTION_NAME = INTEROP_PACKAGE_NAME.append(QualifiedName.create("ProvidedServiceOptions", "title"));
    public static final QualifiedName INTEROP_PROVIDED_METHOD_TITLE_OPTION_NAME = INTEROP_PACKAGE_NAME.append(QualifiedName.create("ProvidedMethodOptions", "title"));
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public static List<Option> getOptionList(EObject obj) {
        return IterableExtensions.toList(Iterables.filter(obj.eContents(), Option.class));
    }

    public static String getValueAsString(Option option) {
        Constant constant = option.getValue();
        Object _switchResult = null;
        boolean _matched = false;
        if (constant instanceof IntConstant) {
            _matched = true;
            return ((IntConstant)constant).getValue().toString();
        }
        if (!_matched && constant instanceof EnumConstant) {
            _matched = true;
            return ((EnumConstant)constant).getValue().getName();
        }
        if (!_matched && constant instanceof StringConstant) {
            _matched = true;
            return ((StringConstant)constant).getValue();
        }
        if (!_matched && constant instanceof BoolConstant) {
            _matched = true;
            return ((BoolConstant)constant).getValue().toString();
        }
        if (!_matched && constant instanceof DecimalConstant) {
            _matched = true;
            return ((DecimalConstant)constant).getValue().toString();
        }
        return _switchResult;
    }

    public static List<Service> getServices(Resource ... resources) {
        Function<Resource, Stream> _function = resource -> GenUtils.getServices(resource).stream();
        return Arrays.stream(resources).flatMap(_function).collect(Collectors.toList());
    }

    public Map<String, Service> getServicesMap(Resource ... resources) {
        Function<Service, String> _function = it -> this.getFullName((EObject)it);
        Function<Service, Service> _function_1 = it -> it;
        BinaryOperator _function_2 = (value, duplicate) -> value;
        return GenUtils.getServices(resources).stream().collect(Collectors.toMap(_function, _function_1, _function_2));
    }

    public Map<String, Method> getServiceMethodsMap(Resource ... resources) {
        Function<Service, Stream> _function = s -> {
            Function<Method, Pair> _function_1 = m -> {
                String _fullName = this.getFullName((EObject)s);
                String _plus = _fullName + ".";
                String _name = m.getName();
                String methodId = _plus + _name;
                return Pair.of(methodId, m);
            };
            return GenUtils.getMethods(s).stream().map(_function_1);
        };
        Function<Pair, String> _function_1 = it -> (String)it.getKey();
        Function<Pair, Method> _function_2 = it -> (Method)it.getValue();
        BinaryOperator _function_3 = (value, duplicate) -> value;
        return GenUtils.getServices(resources).stream().flatMap(_function).collect(Collectors.toMap(_function_1, _function_2, _function_3));
    }

    public static List<Message> getMessages(Resource ... resources) {
        Function<Resource, Stream> _function = resource -> GenUtils.getMessages(resource).stream();
        return Arrays.stream(resources).flatMap(_function).collect(Collectors.toList());
    }

    public Map<String, Message> getMessagesMap(Resource ... resources) {
        Function<Message, String> _function = it -> this.getFullName((EObject)it);
        Function<Message, Message> _function_1 = it -> it;
        BinaryOperator _function_2 = (f, s) -> f;
        return GenUtils.getMessages(resources).stream().collect(Collectors.toMap(_function, _function_1, _function_2));
    }

    public Map<String, Field> getFieldsMap(Resource ... resources) {
        Function<Message, Stream> _function = m -> {
            Function<Field, Pair> _function_1 = f -> Pair.of(f, m);
            return GenUtils.getFields(m).stream().map(_function_1);
        };
        Function<Pair, String> _function_1 = pair -> {
            String _fullName = this.getFullName((EObject)pair.getValue());
            String _plus = _fullName + ".";
            String _name = ((Field)pair.getKey()).getName();
            return _plus + _name;
        };
        Function<Pair, Field> _function_2 = it -> (Field)it.getKey();
        BinaryOperator _function_3 = (value, duplicate) -> value;
        return GenUtils.getMessages(resources).stream().flatMap(_function).collect(Collectors.toMap(_function_1, _function_2, _function_3));
    }

    public String getType(Field field) {
        String _xblockexpression = null;
        FieldTypeReference typeRef = field.getTypeReference();
        String _switchResult = null;
        boolean _matched = false;
        if (typeRef instanceof PrimitiveFieldType) {
            _matched = true;
            _switchResult = ((PrimitiveFieldType)typeRef).getValue().getLiteral().toLowerCase();
        }
        if (!_matched && typeRef instanceof ComplexFieldType) {
            _matched = true;
            _switchResult = this.getType((ComplexFieldType)typeRef);
        }
        if (!_matched) {
            _switchResult = "Unsupported";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public static String getAliasOrName(ProvidedService providedService) {
        String _xifexpression = null;
        String _alias = providedService.getAlias();
        boolean _tripleNotEquals = _alias != null;
        _xifexpression = _tripleNotEquals ? providedService.getAlias() : providedService.getService().getName();
        return _xifexpression;
    }

    public static String getAliasOrName(ConsumedService service) {
        String _xifexpression = null;
        String _alias = service.getAlias();
        boolean _tripleNotEquals = _alias != null;
        _xifexpression = _tripleNotEquals ? service.getAlias() : service.getService().getName();
        return _xifexpression;
    }

    public static boolean isPrimitive(Field field) {
        boolean _xblockexpression = false;
        FieldTypeReference typeRef = field.getTypeReference();
        boolean _switchResult = false;
        boolean _matched = false;
        if (typeRef instanceof PrimitiveFieldType) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public QualifiedName getQualifiedName(EObject obj) {
        return this.qualifiedNameProvider.getFullyQualifiedName(obj);
    }

    public String getFullName(EObject obj) {
        return this.getQualifiedName(obj).skipFirst(1).toString();
    }

    public String getType(ComplexFieldType complexFieldType) {
        String _xblockexpression = null;
        ComplexType complexType = complexFieldType.getValue();
        String _switchResult = null;
        boolean _matched = false;
        if (complexType instanceof Message) {
            _matched = true;
            _switchResult = this.getFullName(complexType);
        }
        if (!_matched && complexType instanceof Enum) {
            _matched = true;
            _switchResult = this.getFullName(complexType);
        }
        if (!_matched) {
            _switchResult = "Unsupported";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public static List<Field> getFields(Message message) {
        Predicate<MessageElement> _function = el -> el instanceof Field;
        Function<MessageElement, Field> _function_1 = el -> (Field)el;
        return message.getElements().stream().filter(_function).map(_function_1).collect(Collectors.toList());
    }

    public static List<Message> getMessages(Resource resource) {
        return IteratorExtensions.toList(Iterators.filter(resource.getAllContents(), Message.class));
    }

    public static List<Service> getServices(Resource resource) {
        return IteratorExtensions.toList(Iterators.filter(resource.getAllContents(), Service.class));
    }

    public static List<Method> getMethods(Service service) {
        return IterableExtensions.toList(Iterables.filter(service.getElements(), Method.class));
    }

    public static Service getService(Method method) {
        for (EObject obj = method; obj != null; obj = obj.eContainer()) {
            EObject parent = obj.eContainer();
            Service service = GenUtils.tryGetService(parent);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    private static Service tryGetService(EObject object) {
        Service _switchResult = null;
        boolean _matched = false;
        if (object instanceof ConsumedService) {
            _matched = true;
            _switchResult = ((ConsumedService)object).getService();
        }
        if (!_matched && object instanceof ProvidedService) {
            _matched = true;
            _switchResult = ((ProvidedService)object).getService();
        }
        if (!_matched && object instanceof Service) {
            _matched = true;
            _switchResult = (Service)object;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public static List<Application> getApplications(Resource ... resources) {
        Function<Resource, Stream> _function = resource -> GenUtils.getApplications(resource).stream();
        return Arrays.stream(resources).flatMap(_function).collect(Collectors.toList());
    }

    public Map<String, Application> getApplicationsMap(Resource ... resources) {
        Function<Application, String> _function = it -> this.getFullName((EObject)it);
        Function<Application, Application> _function_1 = it -> it;
        BinaryOperator _function_2 = (value, duplicate) -> value;
        return GenUtils.getApplications(resources).stream().collect(Collectors.toMap(_function, _function_1, _function_2));
    }

    public static List<Application> getApplications(Resource resource) {
        return IteratorExtensions.toList(Iterators.filter(resource.getAllContents(), Application.class));
    }

    public static boolean isPointToPoint(Method rpc) {
        return rpc.getRequest().getIsStream() == false && rpc.getResponse().getIsStream() == false;
    }

    public static boolean isBidiStreaming(Method rpc) {
        return rpc.getRequest().getIsStream() != false && rpc.getResponse().getIsStream() != false;
    }

    public static boolean isClientStreaming(Method rpc) {
        return rpc.getRequest().getIsStream() != false && rpc.getResponse().getIsStream() == false;
    }

    public static boolean isServerStreaming(Method rpc) {
        return rpc.getRequest().getIsStream() == false && rpc.getResponse().getIsStream() != false;
    }

    public static List<ConsumedService> getConsumedServices(Application application) {
        return IterableExtensions.toList(Iterables.filter(application.getElements(), ConsumedService.class));
    }

    public static List<ProvidedService> getProvidedServices(Application application) {
        return IterableExtensions.toList(Iterables.filter(application.getElements(), ProvidedService.class));
    }

    public static List<ConsumedMethod> getMethods(ConsumedService service) {
        return IterableExtensions.toList(Iterables.filter(service.getElements(), ConsumedMethod.class));
    }

    public static List<ProvidedMethod> getMethods(ProvidedService service) {
        return IterableExtensions.toList(Iterables.filter(service.getElements(), ProvidedMethod.class));
    }

    public static List<String> getWildcards(ConsumedService service) {
        boolean _tripleEquals;
        RestrictionList _restrictions = service.getRestrictions();
        boolean bl = _tripleEquals = _restrictions == null;
        if (_tripleEquals) {
            return new LinkedList<String>();
        }
        Functions.Function1<WildcardRestriction, String> _function = x -> x.getWildcard();
        return ListExtensions.map(service.getRestrictions().getElements(), _function);
    }

    public static List<String> getWildcards(ProvidedService service) {
        boolean _tripleEquals;
        RestrictionList _restrictions = service.getRestrictions();
        boolean bl = _tripleEquals = _restrictions == null;
        if (_tripleEquals) {
            return new LinkedList<String>();
        }
        Functions.Function1<WildcardRestriction, String> _function = x -> x.getWildcard();
        return ListExtensions.map(service.getRestrictions().getElements(), _function);
    }

    public String getTitle(ProvidedService providedService) {
        Functions.Function1<Option, Boolean> _function = o -> this.getQualifiedName(o.getDescriptor()).equals(INTEROP_PROVIDED_SERVICE_TITLE_OPTION_NAME);
        Option titleOption = IterableExtensions.findFirst(Iterables.filter(providedService.getElements(), Option.class), _function);
        if (titleOption == null) {
            return providedService.getService().getName();
        }
        return GenUtils.getAsString(titleOption.getValue());
    }

    public String getTitle(ProvidedMethod providedMethod) {
        boolean _tripleEquals;
        EList<InteropOption> _options = providedMethod.getOptions();
        boolean bl = _tripleEquals = _options == null;
        if (_tripleEquals) {
            return providedMethod.getMethod().getName();
        }
        Functions.Function1<InteropOption, Boolean> _function = o -> this.getQualifiedName(o.getDescriptor()).equals(INTEROP_PROVIDED_METHOD_TITLE_OPTION_NAME);
        InteropOption titleOption = IterableExtensions.findFirst(providedMethod.getOptions(), _function);
        if (titleOption == null) {
            return providedMethod.getMethod().getName();
        }
        return GenUtils.getAsString(titleOption.getValue());
    }

    public static String getType(Method method) {
        boolean _isBidiStreaming = GenUtils.isBidiStreaming(method);
        if (_isBidiStreaming) {
            return "DuplexStreaming";
        }
        boolean _isServerStreaming = GenUtils.isServerStreaming(method);
        if (_isServerStreaming) {
            return "ServerStreaming";
        }
        boolean _isClientStreaming = GenUtils.isClientStreaming(method);
        if (_isClientStreaming) {
            return "ClientStreaming";
        }
        return "Unary";
    }

    public static String getAsString(Constant constant) {
        if (constant instanceof StringConstant) {
            return ((StringConstant)constant).getValue();
        }
        return null;
    }
}

