/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.validation.rules;

import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.protobuf.ComplexFieldType;
import com.db.plexus.interop.dsl.protobuf.Field;
import com.db.plexus.interop.dsl.protobuf.FieldTypeReference;
import com.db.plexus.interop.dsl.protobuf.PrimitiveFieldType;
import com.db.plexus.interop.dsl.validation.Issues;
import com.db.plexus.interop.dsl.validation.rules.UpdateRule;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class NoFieldsChangedRule
implements UpdateRule {
    private final GenUtils genUtils;

    @Inject
    public NoFieldsChangedRule(GenUtils genUtils) {
        this.genUtils = genUtils;
    }

    @Override
    public String getCode() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("message-field-updated");
        return _builder.toString();
    }

    @Override
    public List<Issue> validate(XtextResourceSet baseResourceSet, XtextResourceSet updatedResourceSet) {
        Map<String, Field> baseFields = this.genUtils.getFieldsMap((Resource[])Conversions.unwrapArray(baseResourceSet.getResources(), Resource.class));
        Map<String, Field> updatedFields = this.genUtils.getFieldsMap((Resource[])Conversions.unwrapArray(updatedResourceSet.getResources(), Resource.class));
        Set<String> updatedFieldIds = updatedFields.keySet();
        Functions.Function1<Map.Entry, Boolean> _function = fieldEntry -> updatedFieldIds.contains(fieldEntry.getKey());
        Functions.Function1<Map.Entry, Boolean> _function_1 = fieldEntry -> {
            boolean _fieldsEqual = this.fieldsEqual((Field)fieldEntry.getValue(), (Field)updatedFields.get(fieldEntry.getKey()));
            return !_fieldsEqual;
        };
        Functions.Function1<Map.Entry, Issue> _function_2 = fieldEntry -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Message field ");
            String _key = (String)fieldEntry.getKey();
            _builder.append(_key);
            _builder.append(" updated");
            return Issues.createError(_builder.toString(), this.getCode());
        };
        return IterableExtensions.toList(IterableExtensions.map(IterableExtensions.filter(IterableExtensions.filter(baseFields.entrySet(), _function), _function_1), _function_2));
    }

    public boolean fieldsEqual(Field first, Field second) {
        boolean _not_1;
        boolean labelsEqual;
        boolean _not;
        boolean _equals = first.getNumber().equals(second.getNumber());
        boolean bl = _not = !_equals;
        if (_not) {
            return false;
        }
        boolean bl2 = labelsEqual = first.getLabel() == null && second.getLabel() == null || first.getLabel().equals(second.getLabel());
        if (!labelsEqual) {
            return false;
        }
        FieldTypeReference firstType = first.getTypeReference();
        FieldTypeReference secondType = second.getTypeReference();
        boolean _equals_1 = firstType.getClass().equals(secondType.getClass());
        boolean bl3 = _not_1 = !_equals_1;
        if (_not_1) {
            return false;
        }
        boolean _matched = false;
        if (firstType instanceof PrimitiveFieldType) {
            _matched = true;
            return ((PrimitiveFieldType)firstType).getValue().equals(((PrimitiveFieldType)secondType).getValue());
        }
        if (!_matched) {
            _matched = true;
            if (!_matched && firstType instanceof ComplexFieldType) {
                _matched = true;
            }
            if (_matched) {
                return this.complexTypesEqual((ComplexFieldType)firstType, (ComplexFieldType)secondType);
            }
        }
        return false;
    }

    public boolean complexTypesEqual(ComplexFieldType first, ComplexFieldType second) {
        boolean _not;
        boolean _equals = first.getClass().equals(second.getClass());
        boolean bl = _not = !_equals;
        if (_not) {
            return false;
        }
        return this.genUtils.getFullName(first.getValue()).equals(this.genUtils.getFullName(second.getValue()));
    }
}

