/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclarator;
import org.eclipse.xtend.lib.macro.declaration.ResolvedConstructor;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
public class FinalFieldsConstructorProcessor
implements TransformationParticipant<MutableTypeParameterDeclarator> {
    @Override
    public void doTransform(List<? extends MutableTypeParameterDeclarator> elements, final @Extension TransformationContext context) {
        Consumer<MutableTypeParameterDeclarator> _function = new Consumer<MutableTypeParameterDeclarator>(){

            @Override
            public void accept(MutableTypeParameterDeclarator it) {
                FinalFieldsConstructorProcessor.this.transform(it, context);
            }
        };
        elements.forEach(_function);
    }

    protected void _transform(MutableClassDeclaration it, @Extension TransformationContext context) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        AnnotationReference _findAnnotation = it.findAnnotation(context.findTypeGlobally(Data.class));
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        AnnotationReference _findAnnotation_1 = it.findAnnotation(context.findTypeGlobally(Accessors.class));
        boolean bl2 = _tripleNotEquals_1 = _findAnnotation_1 != null;
        if (_tripleNotEquals_1) {
            return;
        }
        Util util = new Util(context);
        util.addFinalFieldsConstructor(it);
    }

    protected void _transform(MutableConstructorDeclaration it, @Extension TransformationContext context) {
        Util util = new Util(context);
        util.makeFinalFieldsConstructor(it);
    }

    public void transform(MutableTypeParameterDeclarator it, TransformationContext context) {
        if (it instanceof MutableConstructorDeclaration) {
            this._transform((MutableConstructorDeclaration)it, context);
            return;
        }
        if (it instanceof MutableClassDeclaration) {
            this._transform((MutableClassDeclaration)it, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, context).toString());
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;
        private static final Pattern EMPTY_BODY = Pattern.compile("(\\{(\\s*\\})?)?");

        public Util(TransformationContext context) {
            this.context = context;
        }

        public Iterable<? extends MutableFieldDeclaration> getFinalFields(MutableTypeDeclaration it) {
            Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

                @Override
                public Boolean apply(MutableFieldDeclaration it) {
                    return !it.isStatic() && it.isFinal() && it.getInitializer() == null && Util.this.context.isThePrimaryGeneratedJavaElement(it);
                }
            };
            return IterableExtensions.filter(it.getDeclaredFields(), _function);
        }

        public boolean needsFinalFieldConstructor(MutableClassDeclaration it) {
            return !this.hasFinalFieldsConstructor(it) && IterableExtensions.isEmpty(((ClassDeclaration)this.context.getPrimarySourceElement(it)).getDeclaredConstructors());
        }

        public boolean hasFinalFieldsConstructor(MutableTypeDeclaration cls) {
            boolean _xblockexpression = false;
            final ArrayList<TypeReference> expectedTypes = this.getFinalFieldsConstructorArgumentTypes(cls);
            Functions.Function1<MutableConstructorDeclaration, Boolean> _function = new Functions.Function1<MutableConstructorDeclaration, Boolean>(){

                @Override
                public Boolean apply(MutableConstructorDeclaration it) {
                    Functions.Function1<MutableParameterDeclaration, TypeReference> _function = new Functions.Function1<MutableParameterDeclaration, TypeReference>(){

                        @Override
                        public TypeReference apply(MutableParameterDeclaration it) {
                            return it.getType();
                        }
                    };
                    List<TypeReference> _list = IterableExtensions.toList(IterableExtensions.map(it.getParameters(), _function));
                    return Objects.equal(_list, expectedTypes);
                }
            };
            _xblockexpression = IterableExtensions.exists(cls.getDeclaredConstructors(), _function);
            return _xblockexpression;
        }

        public ArrayList<TypeReference> getFinalFieldsConstructorArgumentTypes(MutableTypeDeclaration cls) {
            boolean _tripleNotEquals;
            ArrayList<TypeReference> _xblockexpression = null;
            ArrayList<TypeReference> types = CollectionLiterals.newArrayList();
            ResolvedConstructor _superConstructor = this.getSuperConstructor(cls);
            boolean bl = _tripleNotEquals = _superConstructor != null;
            if (_tripleNotEquals) {
                Functions.Function1<ResolvedParameter, TypeReference> _function = new Functions.Function1<ResolvedParameter, TypeReference>(){

                    @Override
                    public TypeReference apply(ResolvedParameter it) {
                        return it.getResolvedType();
                    }
                };
                Iterable<TypeReference> _map = IterableExtensions.map(this.getSuperConstructor(cls).getResolvedParameters(), _function);
                Iterables.addAll(types, _map);
            }
            Functions.Function1<MutableFieldDeclaration, TypeReference> _function_1 = new Functions.Function1<MutableFieldDeclaration, TypeReference>(){

                @Override
                public TypeReference apply(MutableFieldDeclaration it) {
                    return it.getType();
                }
            };
            Iterable<TypeReference> _map_1 = IterableExtensions.map(this.getFinalFields(cls), _function_1);
            Iterables.addAll(types, _map_1);
            _xblockexpression = types;
            return _xblockexpression;
        }

        public String getConstructorAlreadyExistsMessage(MutableTypeDeclaration it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Cannot create FinalFieldsConstructor as a constructor with the signature \"new(");
            String _join = IterableExtensions.join(this.getFinalFieldsConstructorArgumentTypes(it), ",");
            _builder.append(_join);
            _builder.append(")\" already exists.");
            return _builder.toString();
        }

        public void addFinalFieldsConstructor(MutableClassDeclaration it) {
            boolean _isEmpty = this.getFinalFieldsConstructorArgumentTypes(it).isEmpty();
            if (_isEmpty) {
                AnnotationReference anno = it.findAnnotation(this.context.findTypeGlobally(FinalFieldsConstructor.class));
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("There are no final fields, this annotation has no effect");
                this.context.addWarning(anno, _builder.toString());
                return;
            }
            boolean _hasFinalFieldsConstructor = this.hasFinalFieldsConstructor(it);
            if (_hasFinalFieldsConstructor) {
                this.context.addError(it, this.getConstructorAlreadyExistsMessage(it));
                return;
            }
            Procedures.Procedure1<MutableConstructorDeclaration> _function = new Procedures.Procedure1<MutableConstructorDeclaration>(){

                @Override
                public void apply(MutableConstructorDeclaration it) {
                    Util.this.context.setPrimarySourceElement(it, Util.this.context.getPrimarySourceElement(it.getDeclaringType()));
                    Util.this.makeFinalFieldsConstructor(it);
                }
            };
            it.addConstructor(_function);
        }

        public void makeFinalFieldsConstructor(final MutableConstructorDeclaration it) {
            boolean _not;
            boolean _isEmpty = this.getFinalFieldsConstructorArgumentTypes(it.getDeclaringType()).isEmpty();
            if (_isEmpty) {
                AnnotationReference anno = it.findAnnotation(this.context.findTypeGlobally(FinalFieldsConstructor.class));
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("There are no final fields, this annotation has no effect");
                this.context.addWarning(anno, _builder.toString());
                return;
            }
            boolean _hasFinalFieldsConstructor = this.hasFinalFieldsConstructor(it.getDeclaringType());
            if (_hasFinalFieldsConstructor) {
                this.context.addError(it, this.getConstructorAlreadyExistsMessage(it.getDeclaringType()));
                return;
            }
            boolean _isEmpty_1 = IterableExtensions.isEmpty(it.getParameters());
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                this.context.addError(it, "Parameter list must be empty");
            }
            if (it.getBody() != null && !EMPTY_BODY.matcher(it.getBody().toString()).matches()) {
                this.context.addError(it, "Body must be empty");
            }
            Iterable<? extends ResolvedParameter> _elvis = null;
            ResolvedConstructor _superConstructor = this.getSuperConstructor(it.getDeclaringType());
            Iterable<? extends ResolvedParameter> _resolvedParameters = null;
            if (_superConstructor != null) {
                _resolvedParameters = _superConstructor.getResolvedParameters();
            }
            _elvis = _resolvedParameters != null ? _resolvedParameters : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            final Iterable<? extends ResolvedParameter> superParameters = _elvis;
            Consumer<ResolvedParameter> _function = new Consumer<ResolvedParameter>(){

                @Override
                public void accept(ResolvedParameter p) {
                    it.addParameter(p.getDeclaration().getSimpleName(), p.getResolvedType());
                }
            };
            superParameters.forEach((Consumer<? extends ResolvedParameter>)_function);
            final HashMap fieldToParameter = CollectionLiterals.newHashMap();
            Consumer<MutableFieldDeclaration> _function_1 = new Consumer<MutableFieldDeclaration>(){

                @Override
                public void accept(MutableFieldDeclaration p) {
                    p.markAsInitializedBy(it);
                    MutableParameterDeclaration param = it.addParameter(p.getSimpleName(), Util.this.orObject(p.getType()));
                    fieldToParameter.put(p, param);
                }
            };
            this.getFinalFields(it.getDeclaringType()).forEach((Consumer<? extends MutableFieldDeclaration>)_function_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append("super(");
                    Functions.Function1<ResolvedParameter, CharSequence> _function = new Functions.Function1<ResolvedParameter, CharSequence>(){

                        @Override
                        public CharSequence apply(ResolvedParameter it) {
                            return it.getDeclaration().getSimpleName();
                        }
                    };
                    String _join = IterableExtensions.join(superParameters, ", ", _function);
                    _builder.append(_join);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    Iterable<? extends MutableFieldDeclaration> _finalFields = Util.this.getFinalFields(it.getDeclaringType());
                    for (MutableFieldDeclaration mutableFieldDeclaration : _finalFields) {
                        _builder.append("this.");
                        String _simpleName = mutableFieldDeclaration.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(" = ");
                        String _simpleName_1 = ((MutableParameterDeclaration)fieldToParameter.get(mutableFieldDeclaration)).getSimpleName();
                        _builder.append(_simpleName_1);
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                }
            };
            it.setBody(_client);
        }

        public ResolvedConstructor getSuperConstructor(TypeDeclaration it) {
            if (it instanceof ClassDeclaration) {
                if (Objects.equal(((ClassDeclaration)it).getExtendedClass(), this.context.getObject()) || ((ClassDeclaration)it).getExtendedClass() == null) {
                    return null;
                }
                return IterableExtensions.head(((ClassDeclaration)it).getExtendedClass().getDeclaredResolvedConstructors());
            }
            return null;
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _xifexpression = null;
            _xifexpression = ref == null ? this.context.getObject() : ref;
            return _xifexpression;
        }
    }
}

