/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractTextSegment
implements ITextSegment {
    @Override
    public int compareTo(ITextSegment o) {
        int cmp1 = this.getOffset() - o.getOffset();
        if (cmp1 != 0) {
            return cmp1;
        }
        int cmp2 = this.getLength() - o.getLength();
        if (cmp2 != 0) {
            return cmp2;
        }
        return 0;
    }

    @Override
    public boolean contains(int offset) {
        int thisOffset = this.getOffset();
        return offset >= thisOffset && offset < thisOffset + this.getLength();
    }

    @Override
    public boolean contains(ITextRegion other) {
        int offset = this.getOffset();
        int length = this.getLength();
        return other.getOffset() + other.getLength() <= offset + length && other.getOffset() >= offset;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractTextSegment other = (AbstractTextSegment)obj;
        return this.getOffset() == other.getOffset() && this.getLength() == other.getLength();
    }

    @Override
    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    @Override
    public int getLineCount() {
        return Strings.countLineBreaks(this.getText()) + 1;
    }

    @Override
    public List<ILineRegion> getLineRegions() {
        ILineRegion current = this.getTextRegionAccess().regionForLineAtOffset(this.getOffset());
        ArrayList<ILineRegion> result = Lists.newArrayList();
        int endOffset = this.getEndOffset();
        while (current != null) {
            result.add(current);
            if (current.getEndOffset() >= endOffset) {
                return result;
            }
            if ((current = current.getNextLine()) != null && current.getOffset() < endOffset) continue;
            return result;
        }
        return result;
    }

    @Override
    public String getText() {
        ITextRegionAccess access = this.getTextRegionAccess();
        if (access != null) {
            return ((AbstractRegionAccess)access).textForOffset(this.getOffset(), this.getLength());
        }
        return null;
    }

    public int hashCode() {
        return this.getOffset() + 31 * this.getLength();
    }

    @Override
    public boolean isMultiline() {
        return this.getText().contains("\n");
    }

    @Override
    public ITextSegment merge(ITextRegion other) {
        if (this.contains(other)) {
            return this;
        }
        if (other instanceof ITextSegment && other.contains(this)) {
            return (ITextSegment)other;
        }
        int offset = this.getOffset();
        int length = this.getLength();
        int newOffset = Math.min(offset, other.getOffset());
        int newLength = Math.max(offset + length, other.getOffset() + other.getLength()) - newOffset;
        return new TextSegment(this.getTextRegionAccess(), newOffset, newLength);
    }

    @Override
    public ITextReplacement replaceWith(String text) {
        return this.getTextRegionAccess().getRewriter().createReplacement(this.getOffset(), this.getLength(), text);
    }
}

