/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescriptionProvider;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializationExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class SerializableResourceDescription
extends AbstractResourceDescription
implements Externalizable {
    private List<SerializableEObjectDescription> descriptions = CollectionLiterals.emptyList();
    private List<SerializableReferenceDescription> references = CollectionLiterals.emptyList();
    private List<QualifiedName> importedNames = CollectionLiterals.emptyList();
    private URI uRI;

    public static SerializableResourceDescription createCopy(IResourceDescription desc) {
        SerializableResourceDescription _serializableResourceDescription = new SerializableResourceDescription();
        Procedures.Procedure1<SerializableResourceDescription> _function = it -> {
            it.setURI(desc.getURI());
            Functions.Function1<IEObjectDescription, SerializableEObjectDescription> _function_1 = it_1 -> SerializableResourceDescription.createCopy(it_1);
            it.descriptions = IterableExtensions.toList(IterableExtensions.map(desc.getExportedObjects(), _function_1));
            Functions.Function1<IReferenceDescription, SerializableReferenceDescription> _function_2 = it_1 -> SerializableResourceDescription.createCopy(it_1);
            it.references = IterableExtensions.toList(IterableExtensions.map(desc.getReferenceDescriptions(), _function_2));
            it.importedNames = CollectionLiterals.newArrayList((QualifiedName[])Conversions.unwrapArray(desc.getImportedNames(), QualifiedName.class));
        };
        return ObjectExtensions.operator_doubleArrow(_serializableResourceDescription, _function);
    }

    private static SerializableEObjectDescription createCopy(IEObjectDescription desc) {
        if (desc instanceof SerializableEObjectDescriptionProvider) {
            return ((SerializableEObjectDescriptionProvider)((Object)desc)).toSerializableEObjectDescription();
        }
        SerializableEObjectDescription _serializableEObjectDescription = new SerializableEObjectDescription();
        Procedures.Procedure1<SerializableEObjectDescription> _function = it -> {
            String[] _userDataKeys;
            it.setEClass(desc.getEClass());
            it.setEObjectURI(desc.getEObjectURI());
            it.qualifiedName = desc.getQualifiedName();
            int _size = ((List)Conversions.doWrapArray(desc.getUserDataKeys())).size();
            HashMap _hashMap = new HashMap(_size);
            it.userData = _hashMap;
            for (String key : _userDataKeys = desc.getUserDataKeys()) {
                it.userData.put(key, desc.getUserData(key));
            }
        };
        return ObjectExtensions.operator_doubleArrow(_serializableEObjectDescription, _function);
    }

    private static SerializableReferenceDescription createCopy(IReferenceDescription desc) {
        SerializableReferenceDescription _serializableReferenceDescription = new SerializableReferenceDescription();
        Procedures.Procedure1<SerializableReferenceDescription> _function = it -> {
            it.setSourceEObjectUri(desc.getSourceEObjectUri());
            it.setTargetEObjectUri(desc.getTargetEObjectUri());
            it.setEReference(desc.getEReference());
            it.setIndexInList(desc.getIndexInList());
            it.setContainerEObjectURI(desc.getContainerEObjectURI());
        };
        return ObjectExtensions.operator_doubleArrow(_serializableReferenceDescription, _function);
    }

    public void updateResourceURI(URI uri) {
        for (SerializableReferenceDescription ref : this.references) {
            ref.updateResourceURI(uri, this.uRI);
        }
        for (SerializableEObjectDescription desc : this.descriptions) {
            desc.updateResourceURI(uri);
        }
        this.uRI = uri;
    }

    @Override
    protected List<IEObjectDescription> computeExportedObjects() {
        return this.descriptions;
    }

    @Override
    public Iterable<QualifiedName> getImportedNames() {
        return this.importedNames;
    }

    @Override
    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return this.references;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setURI(SerializationExtensions.readURI(in));
        int descriptionsSize = in.readInt();
        ArrayList<SerializableEObjectDescription> _arrayList = new ArrayList<SerializableEObjectDescription>(descriptionsSize);
        this.descriptions = _arrayList;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, descriptionsSize, true);
        for (Integer i : _doubleDotLessThan) {
            this.descriptions.add((SerializableEObjectDescription)SerializationExtensions.readCastedObject(in));
        }
        int referencesSize = in.readInt();
        ArrayList<SerializableReferenceDescription> _arrayList_1 = new ArrayList<SerializableReferenceDescription>(referencesSize);
        this.references = _arrayList_1;
        ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, referencesSize, true);
        for (Integer i_1 : _doubleDotLessThan_1) {
            this.references.add((SerializableReferenceDescription)SerializationExtensions.readCastedObject(in));
        }
        int importedNamesSize = in.readInt();
        ArrayList<QualifiedName> _arrayList_2 = new ArrayList<QualifiedName>(importedNamesSize);
        this.importedNames = _arrayList_2;
        ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, importedNamesSize, true);
        for (Integer i_2 : _doubleDotLessThan_2) {
            this.importedNames.add(SerializationExtensions.readQualifiedName(in));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationExtensions.writeURI(out, this.uRI);
        out.writeInt(this.descriptions.size());
        for (SerializableEObjectDescription desc : this.descriptions) {
            out.writeObject(desc);
        }
        out.writeInt(this.references.size());
        for (SerializableReferenceDescription ref : this.references) {
            out.writeObject(ref);
        }
        out.writeInt(this.importedNames.size());
        for (QualifiedName name : this.importedNames) {
            SerializationExtensions.writeQualifiedName(out, name);
        }
    }

    @Pure
    public List<SerializableEObjectDescription> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<SerializableEObjectDescription> descriptions) {
        this.descriptions = descriptions;
    }

    @Pure
    public List<SerializableReferenceDescription> getReferences() {
        return this.references;
    }

    public void setReferences(List<SerializableReferenceDescription> references) {
        this.references = references;
    }

    public void setImportedNames(List<QualifiedName> importedNames) {
        this.importedNames = importedNames;
    }

    @Override
    @Pure
    public URI getURI() {
        return this.uRI;
    }

    public void setURI(URI uRI) {
        this.uRI = uRI;
    }
}

