/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XNumberLiteral;

public class NumberLiterals {
    public int getBase(XNumberLiteral literal) {
        if (this.isHex(literal)) {
            return 16;
        }
        return 10;
    }

    protected String getTypeQualifier(XNumberLiteral literal) {
        String valueAsLowerCase = literal.getValue().toLowerCase();
        switch (this.getBase(literal)) {
            case 16: {
                int index = valueAsLowerCase.indexOf(35);
                if (index != -1) {
                    return valueAsLowerCase.substring(index + 1);
                }
                return "";
            }
            case 10: {
                if (valueAsLowerCase.endsWith("bi") || valueAsLowerCase.endsWith("bd")) {
                    return valueAsLowerCase.substring(valueAsLowerCase.length() - 2);
                }
                char lastChar = valueAsLowerCase.charAt(literal.getValue().length() - 1);
                switch (lastChar) {
                    case 'd': 
                    case 'f': 
                    case 'l': {
                        return Character.toString(lastChar);
                    }
                }
                return "";
            }
        }
        throw new IllegalArgumentException("Invalid number literal base " + this.getBase(literal));
    }

    public String toJavaLiteral(XNumberLiteral literal) {
        return this.toJavaLiteral(literal, true);
    }

    public String toJavaLiteral(XNumberLiteral literal, boolean removeUnderscores) {
        if (this.getJavaType(literal).isPrimitive()) {
            boolean floatingPoint = this.isFloatingPoint(literal);
            String value = literal.getValue();
            if (!floatingPoint && !value.startsWith("0x")) {
                value = value.replaceAll("^[0_]+(\\d)", "$1");
            }
            if (removeUnderscores) {
                return value.replace("_", "").replace("#", "");
            }
            return value.replace("#", "");
        }
        return null;
    }

    public String getDigits(XNumberLiteral literal) {
        return this.getXbaseDigits(literal).replace("_", "");
    }

    protected String getXbaseDigits(XNumberLiteral literal) {
        String value = literal.getValue();
        int length = value.length();
        String typeQualifier = this.getTypeQualifier(literal);
        switch (this.getBase(literal)) {
            case 10: {
                return value.substring(0, length - typeQualifier.length());
            }
            case 16: {
                if (Strings.equal("", typeQualifier)) {
                    return value.substring(2, length - typeQualifier.length());
                }
                return value.substring(2, length - typeQualifier.length() - 1);
            }
        }
        throw new IllegalArgumentException("Invalid number literal base " + this.getBase(literal));
    }

    protected boolean isFloatingPoint(XNumberLiteral literal) {
        if (literal.getValue().indexOf(46) != -1) {
            return true;
        }
        String lowerCaseValue = literal.getValue().toLowerCase();
        switch (this.getBase(literal)) {
            case 16: {
                return false;
            }
            case 10: {
                if (lowerCaseValue.indexOf(101) != -1) {
                    return true;
                }
                char lastChar = lowerCaseValue.charAt(literal.getValue().length() - 1);
                return lastChar == 'd' || lastChar == 'f';
            }
        }
        throw new IllegalArgumentException("Invalid number literal base " + this.getBase(literal));
    }

    protected Class<? extends Number> getExplicitJavaType(XNumberLiteral literal) {
        String typeQualifier = this.getTypeQualifier(literal);
        if (Strings.equal("", typeQualifier)) {
            return null;
        }
        if (Strings.equal("f", typeQualifier)) {
            return Float.TYPE;
        }
        if (Strings.equal("l", typeQualifier)) {
            return Long.TYPE;
        }
        if (Strings.equal("d", typeQualifier)) {
            return Double.TYPE;
        }
        if (Strings.equal("bi", typeQualifier)) {
            return BigInteger.class;
        }
        if (Strings.equal("bd", typeQualifier)) {
            return BigDecimal.class;
        }
        throw new IllegalArgumentException("Invalid type qualifier " + typeQualifier);
    }

    public Class<? extends Number> getJavaType(XNumberLiteral literal) {
        Class<? extends Number> explicitType = this.getExplicitJavaType(literal);
        return explicitType == null ? (this.isFloatingPoint(literal) ? Double.TYPE : Integer.TYPE) : explicitType;
    }

    public Number numberValue(XNumberLiteral literal, Class<?> numberType) {
        if (numberType == Integer.TYPE || numberType == Integer.class) {
            BigInteger asBigInt = this.toBigInteger(literal);
            BigInteger shiftRight = asBigInt.shiftRight(32);
            if (shiftRight.getLowestSetBit() != -1 || asBigInt.testBit(31) && this.getBase(literal) == 10) {
                throw new NumberFormatException("Integer literal is out of range: " + literal.getValue());
            }
            return asBigInt.intValue();
        }
        if (numberType == Double.TYPE || numberType == Double.class) {
            return Double.parseDouble(this.getDigits(literal));
        }
        if (numberType == Long.TYPE || numberType == Long.class) {
            BigInteger asBigInt = this.toBigInteger(literal);
            BigInteger shiftRight = asBigInt.shiftRight(64);
            if (shiftRight.getLowestSetBit() != -1 || asBigInt.testBit(63) && this.getBase(literal) == 10) {
                throw new NumberFormatException("Long literal is out of range: " + literal.getValue());
            }
            return asBigInt.longValue();
        }
        if (numberType == Float.TYPE || numberType == Float.class) {
            return Float.valueOf(Float.parseFloat(this.getDigits(literal)));
        }
        if (numberType == Byte.TYPE || numberType == Byte.class) {
            return Byte.parseByte(this.getDigits(literal));
        }
        if (numberType == BigInteger.class) {
            return this.toBigInteger(literal);
        }
        if (numberType == BigDecimal.class) {
            return this.toBigDecimal(literal);
        }
        throw new IllegalArgumentException("Cannot convert number literal to type" + numberType.getCanonicalName());
    }

    public BigInteger toBigInteger(XNumberLiteral literal) {
        if (this.isFloatingPoint(literal)) {
            return this.toBigDecimal(literal).toBigInteger();
        }
        return new BigInteger(this.getDigits(literal), this.getBase(literal));
    }

    public String getExponent(XNumberLiteral literal, String digits) {
        if (this.isHex(literal)) {
            return null;
        }
        int e = digits.indexOf(101);
        if (e == -1) {
            e = digits.indexOf(69);
        }
        if (e != -1) {
            if (e != digits.length() - 1 && (digits.charAt(e + 1) == '+' || digits.charAt(e + 1) == '-')) {
                ++e;
            }
            if (e < digits.length() - 1) {
                String exponent = digits.substring(e + 1);
                return exponent;
            }
        }
        return null;
    }

    protected boolean isHex(XNumberLiteral literal) {
        String text = literal.getValue();
        if (text.length() >= 2) {
            char second = text.charAt(1);
            return text.charAt(0) == '0' && (second == 'X' || second == 'x');
        }
        return false;
    }

    public BigDecimal toBigDecimal(XNumberLiteral literal) {
        if (this.isFloatingPoint(literal)) {
            String digits = this.getDigits(literal);
            String exponent = this.getExponent(literal, digits);
            if (exponent != null && exponent.length() > 10) {
                throw new NumberFormatException("Too many nonzero exponent digits.");
            }
            return new BigDecimal(digits);
        }
        int base = this.getBase(literal);
        switch (base) {
            case 16: {
                return new BigDecimal(new BigInteger(this.getDigits(literal), base));
            }
            case 10: {
                return new BigDecimal(this.getDigits(literal));
            }
        }
        throw new IllegalArgumentException("Invalid number literal base " + base);
    }
}

