/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.xtext.JvmMemberInitializableResource;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultBatchTypeResolver;

public class LogicalContainerAwareBatchTypeResolver
extends DefaultBatchTypeResolver {
    private static final Logger LOG = Logger.getLogger(LogicalContainerAwareBatchTypeResolver.class);

    @Override
    protected void validateResourceState(Resource resource) {
        super.validateResourceState(resource);
        if (resource instanceof DerivedStateAwareResource && ((DerivedStateAwareResource)resource).isInitializing()) {
            LOG.error("Discouraged attempt to compute types during model inference. Resource was : " + resource.getURI(), new Exception());
        }
        if (resource instanceof JvmMemberInitializableResource && ((JvmMemberInitializableResource)((Object)resource)).isInitializingJvmMembers()) {
            LOG.error("Discouraged attempt to compute types during JvmMember initialization. Resource was : " + resource.getURI(), new Exception());
        }
    }

    @Override
    protected List<EObject> getEntryPoints(EObject object) {
        Resource resource = object.eResource();
        EList<EObject> contents = resource.getContents();
        ArrayList<EObject> result = Lists.newArrayList();
        for (EObject content : contents) {
            if (!(content instanceof JvmType)) continue;
            result.add(content);
        }
        if (result.isEmpty()) {
            return super.getEntryPoints(object);
        }
        return result;
    }
}

