/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.RawSuperTypes;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.PublicVisibilityHelper;

public class ContextualVisibilityHelper
implements IVisibilityHelper {
    private JvmType rawContextType;
    private Set<String> superTypeNames;
    private IVisibilityHelper parent;
    private String packageName;

    public ContextualVisibilityHelper(IVisibilityHelper parent, String packageName) {
        this.parent = parent;
        this.packageName = packageName;
    }

    public ContextualVisibilityHelper(IVisibilityHelper parent, LightweightTypeReference contextType) {
        this.parent = parent;
        this.rawContextType = contextType.getRawTypeReference().getType();
        if (this.rawContextType instanceof JvmDeclaredType) {
            this.packageName = ((JvmDeclaredType)this.rawContextType).getPackageName();
        }
    }

    public ContextualVisibilityHelper(IVisibilityHelper parent, LightweightTypeReference contextType, String packageName) {
        this.parent = parent;
        this.rawContextType = contextType.getRawTypeReference().getType();
        this.packageName = packageName;
    }

    public ContextualVisibilityHelper(IVisibilityHelper parent, JvmType rawContextType, String packageName) {
        this.parent = parent;
        this.rawContextType = rawContextType;
        this.packageName = packageName;
    }

    public ContextualVisibilityHelper(IVisibilityHelper parent, JvmType rawContextType) {
        this.parent = parent;
        this.rawContextType = rawContextType;
        if (rawContextType instanceof JvmDeclaredType) {
            this.packageName = ((JvmDeclaredType)rawContextType).getPackageName();
        }
    }

    public ContextualVisibilityHelper(LightweightTypeReference contextType) {
        this((IVisibilityHelper)new PublicVisibilityHelper(), contextType);
    }

    public JvmType getRawContextType() {
        return this.rawContextType;
    }

    @Override
    public boolean isVisible(JvmMember member) {
        JvmDeclaredType type;
        JvmVisibility visibility = member.getVisibility();
        if (visibility == JvmVisibility.PUBLIC) {
            return true;
        }
        JvmDeclaredType jvmDeclaredType = type = member instanceof JvmDeclaredType ? (JvmDeclaredType)member : member.getDeclaringType();
        if (type == this.rawContextType || EcoreUtil.isAncestor(this.rawContextType, (EObject)type)) {
            return true;
        }
        if (type != null && visibility == JvmVisibility.PROTECTED) {
            JvmDeclaredType declaringType;
            if (this.superTypeNames == null) {
                this.superTypeNames = this.computeSuperTypeNames();
            }
            if (this.superTypeNames.contains(type.getIdentifier())) {
                return true;
            }
            if (type == member && (declaringType = member.getDeclaringType()) != null && this.superTypeNames.contains(declaringType.getIdentifier())) {
                return true;
            }
        }
        if (type != null && (this.rawContextType == null || this.rawContextType instanceof JvmDeclaredType) && (visibility == JvmVisibility.DEFAULT || visibility == JvmVisibility.PROTECTED) && (Strings.isEmpty(this.packageName) && Strings.isEmpty(type.getPackageName()) || this.packageName != null && this.packageName.equals(type.getPackageName()))) {
            return true;
        }
        return this.parent.isVisible(member);
    }

    protected Set<String> computeSuperTypeNames() {
        return new RawSuperTypes().collectNames(this.rawContextType);
    }

    public String getPackageName() {
        return this.packageName;
    }
}

