/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.LinkedHashMap;
import java.util.List;

public class Multimaps2 {
    public static <K, V> ListMultimap<K, V> newLinkedHashListMultimap() {
        return Multimaps.newListMultimap(Maps.newLinkedHashMap(), new Supplier<List<V>>(){

            @Override
            public List<V> get() {
                return Lists.newArrayList();
            }
        });
    }

    public static <K, V> ListMultimap<K, V> newLinkedHashListMultimap(int expectedKeys, final int expectedValuesPerKey) {
        return Multimaps.newListMultimap(new LinkedHashMap(expectedKeys), new Supplier<List<V>>(){

            @Override
            public List<V> get() {
                return Lists.newArrayListWithCapacity(expectedValuesPerKey);
            }
        });
    }

    public static <K, V> ListMultimap<K, V> newLinkedHashListMultimap(Multimap<K, V> multimap) {
        int keySetSize = multimap.keySet().size();
        int expectedKeys = Math.max(keySetSize, 2);
        ListMultimap<K, V> result = Multimaps2.newLinkedHashListMultimap(expectedKeys, Math.max(3, multimap.size() / expectedKeys));
        result.putAll(multimap);
        return result;
    }
}

