/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.util.Strings;

@Singleton
public class XtextFragmentProvider
implements IFragmentProvider {
    private static final String PREFIX = "XtextFragmentProvider_";

    @Override
    public EObject getEObject(Resource resource, String fragment, IFragmentProvider.Fallback fallback) {
        if (!fragment.startsWith(PREFIX)) {
            return fallback.getEObject(fragment);
        }
        String fragmentWithoutPrefix = fragment.substring(PREFIX.length());
        List<String> splitted = Strings.split(fragmentWithoutPrefix, '/');
        if (splitted.isEmpty()) {
            return fallback.getEObject(fragment);
        }
        String firstPart = splitted.get(0);
        Grammar grammar = null;
        for (EObject content : resource.getContents()) {
            Grammar g;
            if (!(content instanceof Grammar) || !firstPart.equals((g = (Grammar)content).getName())) continue;
            grammar = g;
            if (splitted.size() != 1) break;
            return grammar;
        }
        if (splitted.size() == 2) {
            return GrammarUtil.findRuleForName(grammar, splitted.get(1));
        }
        return fallback.getEObject(fragment);
    }

    @Override
    public String getFragment(EObject obj, IFragmentProvider.Fallback fallback) {
        if (obj instanceof Grammar) {
            return this.caseGrammar((Grammar)obj);
        }
        if (obj instanceof AbstractRule && obj.eContainer() != null) {
            return this.caseAbstractRule((AbstractRule)obj, fallback);
        }
        return fallback.getFragment(obj);
    }

    public String caseGrammar(Grammar obj) {
        return PREFIX + obj.getName();
    }

    public String caseAbstractRule(AbstractRule obj, IFragmentProvider.Fallback fallback) {
        return this.getFragment(obj.eContainer(), fallback) + "/" + obj.getName();
    }
}

