/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.proto;

import com.db.plexus.interop.dsl.gen.BaseGenTask;
import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.protobuf.Field;
import com.db.plexus.interop.dsl.protobuf.Import;
import com.db.plexus.interop.dsl.protobuf.Message;
import com.db.plexus.interop.dsl.protobuf.NamedElement;
import com.db.plexus.interop.dsl.protobuf.Option;
import com.db.plexus.interop.dsl.protobuf.Proto;
import com.db.plexus.interop.dsl.protobuf.ProtoElement;
import com.db.plexus.interop.dsl.protobuf.ProtoLangImportResolver;
import com.db.plexus.interop.dsl.protobuf.ProtobufFactory;
import com.db.plexus.interop.dsl.protobuf.ProtobufPackage;
import com.db.plexus.interop.dsl.protobuf.Service;
import com.db.plexus.interop.dsl.protobuf.StringConstant;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class ProtoGenTask
extends BaseGenTask {
    @Inject
    private IResourceValidator validator;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private ProtoLangImportResolver importResolver;
    protected final LinkedList<Option> customOptions = new LinkedList();

    @Override
    public void validateResources(PlexusGenConfig config, XtextResourceSet resourceSet) {
        super.validateResources(config, resourceSet);
        this.validateInteropResourceLoaded(config, resourceSet);
    }

    public LinkedList<Option> getCustomOptions() {
        return this.customOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGenWithResources(PlexusGenConfig config, XtextResourceSet rs) throws IOException {
        try {
            boolean _greaterThan;
            boolean _tripleEquals;
            String _input = config.getInput();
            String _plus = "Generating proto contract for " + _input;
            String _plus_1 = _plus + " to folder ";
            String _outDir = config.getOutDir();
            String _plus_2 = _plus_1 + _outDir;
            this.logger.info(_plus_2);
            URI optionsUri = URI.createURI(ClassLoader.getSystemClassLoader().getResource("interop/options.proto").toURI().toString());
            URI descriptorUri = URI.createURI(ClassLoader.getSystemClassLoader().getResource("google/protobuf/descriptor.proto").toURI().toString());
            URI interopResourceBaseUri = optionsUri.trimSegments(2).appendSegment("");
            URI protoResourceBaseUri = descriptorUri.trimSegments(3).appendSegment("");
            Functions.Function1<Resource, Boolean> _function = r -> r.getURI().toString().endsWith("interop/options.proto");
            Resource _findFirst = IterableExtensions.findFirst(rs.getResources(), _function);
            boolean bl = _tripleEquals = _findFirst == null;
            if (_tripleEquals) {
                rs.getResource(optionsUri, true);
            }
            EcoreUtil2.resolveAll(rs);
            LinkedList allIssues = new LinkedList();
            EList<Resource> _resources = rs.getResources();
            for (Resource resource : _resources) {
                URI _uRI = resource.getURI();
                String _plus_3 = "Loaded resource: " + _uRI;
                this.logger.info(_plus_3);
                List<Issue> issues = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
                allIssues.addAll(issues);
            }
            Functions.Function1<Issue, Boolean> _function_1 = x -> {
                Severity _severity = x.getSeverity();
                return Objects.equal((Object)_severity, (Object)Severity.ERROR);
            };
            List<Issue> errors = IterableExtensions.toList(IterableExtensions.filter(allIssues, _function_1));
            Functions.Function1<Issue, Boolean> _function_2 = x -> {
                Severity _severity = x.getSeverity();
                return !Objects.equal((Object)_severity, (Object)Severity.ERROR);
            };
            Iterable<Issue> otherIssues = IterableExtensions.filter(allIssues, _function_2);
            for (Issue issue : otherIssues) {
                this.logger.warning(issue.toString());
            }
            List<Issue> _converted_errors = errors;
            int _length = ((Object[])Conversions.unwrapArray(_converted_errors, Object.class)).length;
            boolean bl2 = _greaterThan = _length > 0;
            if (_greaterThan) {
                for (Issue issue_1 : errors) {
                    this.logger.severe(issue_1.toString());
                }
                throw new IOException("Errors found in the loaded resources");
            }
            LinkedList<Resource> oldResources = new LinkedList<Resource>();
            oldResources.addAll(rs.getResources());
            IResourceDescription optionsResourceDescription = this.importResolver.resolveResourceDescription(rs, "interop/options.proto");
            for (Resource r2 : oldResources) {
                boolean _startsWith_1;
                boolean _startsWith;
                URI uri;
                String deresolvedStr;
                boolean _startsWith_2;
                Functions.Function1<IEObjectDescription, Boolean> _function_3 = x -> x.getName().equals(GenUtils.INTEROP_SERVICE_ID_OPTION_NAME);
                EObject _eObjectOrProxy = IterableExtensions.findFirst(optionsResourceDescription.getExportedObjects(ProtobufPackage.Literals.FIELD, GenUtils.INTEROP_SERVICE_ID_OPTION_NAME, false), _function_3).getEObjectOrProxy();
                Field serviceIdOptionDescriptor = (Field)_eObjectOrProxy;
                Functions.Function1<IEObjectDescription, Boolean> _function_4 = x -> x.getName().equals(GenUtils.INTEROP_MESSAGE_ID_OPTION_NAME);
                EObject _eObjectOrProxy_1 = IterableExtensions.findFirst(optionsResourceDescription.getExportedObjects(ProtobufPackage.Literals.FIELD, GenUtils.INTEROP_MESSAGE_ID_OPTION_NAME, false), _function_4).getEObjectOrProxy();
                Field messageIdOptionDescriptor = (Field)_eObjectOrProxy_1;
                int _length_1 = ((Object[])Conversions.unwrapArray(r2.getContents(), Object.class)).length;
                boolean _greaterThan_1 = _length_1 > 0;
                if (!_greaterThan_1) continue;
                URI _uRI = r2.getURI();
                String _plus_3 = "Processing " + _uRI;
                this.logger.info(_plus_3);
                String uriStr = r2.getURI().toString();
                boolean isProto = uriStr.endsWith(".proto");
                boolean isDescriptorProto = isProto && (uriStr.endsWith("google/protobuf/descriptor.proto") || uriStr.endsWith("interop/descriptor.proto"));
                boolean isBuiltIn = r2.getURI().segmentCount() > 2 && r2.getURI().segment(r2.getURI().segmentCount() - 2).equals("protobuf") && r2.getURI().segment(r2.getURI().segmentCount() - 3).equals("google");
                boolean needAddCustomOptions = !isBuiltIn && !isDescriptorProto;
                boolean needAddPlexusOptions = !isBuiltIn && !isDescriptorProto && !uriStr.endsWith("interop/options.proto");
                EObject _get = (EObject)r2.getContents().get(0);
                Proto root = (Proto)_get;
                Functions.Function1<ProtoElement, Boolean> _function_5 = x -> x instanceof NamedElement;
                ProtoElement firstDefinition = IterableExtensions.findFirst(root.getElements(), _function_5);
                int addIndex = ((Object[])Conversions.unwrapArray(root.getElements(), Object.class)).length;
                if (firstDefinition != null) {
                    addIndex = root.getElements().indexOf(firstDefinition);
                }
                if (needAddPlexusOptions) {
                    boolean needAddImport;
                    Functions.Function1<Import, Boolean> _function_6 = x -> x.getImportURI().endsWith("interop/options.proto");
                    Import _findFirst_1 = IteratorExtensions.findFirst(Iterators.filter(r2.getAllContents(), Import.class), _function_6);
                    boolean bl3 = needAddImport = _findFirst_1 == null;
                    if (needAddImport) {
                        Import importElement = ProtobufFactory.eINSTANCE.createImport();
                        importElement.setImportURI("interop/options.proto");
                        root.getElements().add(addIndex, importElement);
                        ++addIndex;
                    }
                    Iterable<Service> _filter = Iterables.filter(IteratorExtensions.toIterable(r2.getAllContents()), Service.class);
                    for (Service service : _filter) {
                        Functions.Function1<Option, Boolean> _function_7 = o -> this.qualifiedNameProvider.getFullyQualifiedName(o.getDescriptor()).equals(GenUtils.INTEROP_SERVICE_ID_OPTION_NAME);
                        Option _findFirst_2 = IterableExtensions.findFirst(Iterables.filter(service.getElements(), Option.class), _function_7);
                        boolean needSetOption = _findFirst_2 == null;
                        if (!needSetOption) continue;
                        String id = this.qualifiedNameProvider.getFullyQualifiedName(service).skipFirst(1).toString();
                        StringConstant stringConstant = ProtobufFactory.eINSTANCE.createStringConstant();
                        stringConstant.setValue(id);
                        Option option = ProtobufFactory.eINSTANCE.createOption();
                        option.setIsCustom(true);
                        option.setDescriptor(serviceIdOptionDescriptor);
                        option.setValue(stringConstant);
                        service.getElements().add(0, option);
                    }
                    Iterable<Message> _filter_1 = Iterables.filter(IteratorExtensions.toIterable(r2.getAllContents()), Message.class);
                    for (Message message : _filter_1) {
                        Functions.Function1<Option, Boolean> _function_7 = o -> this.qualifiedNameProvider.getFullyQualifiedName(o.getDescriptor()).equals(GenUtils.INTEROP_MESSAGE_ID_OPTION_NAME);
                        Option _findFirst_2 = IterableExtensions.findFirst(Iterables.filter(message.getElements(), Option.class), _function_7);
                        boolean needSetOption = _findFirst_2 == null;
                        if (!needSetOption) continue;
                        String id = this.qualifiedNameProvider.getFullyQualifiedName(message).skipFirst(1).toString();
                        StringConstant stringConstant = ProtobufFactory.eINSTANCE.createStringConstant();
                        stringConstant.setValue(id);
                        Option option = ProtobufFactory.eINSTANCE.createOption();
                        option.setIsCustom(true);
                        option.setDescriptor(messageIdOptionDescriptor);
                        option.setValue(stringConstant);
                        message.getElements().add(0, option);
                    }
                }
                if (needAddCustomOptions) {
                    for (Option customOption : this.customOptions) {
                        Functions.Function1<Option, Boolean> _function_7 = o -> this.qualifiedNameProvider.getFullyQualifiedName(o.getDescriptor()).equals(this.qualifiedNameProvider.getFullyQualifiedName(customOption.getDescriptor()));
                        Option existingOption = IterableExtensions.findFirst(Iterables.filter(root.getElements(), Option.class), _function_7);
                        if (existingOption == null) {
                            root.getElements().add(addIndex, customOption);
                            ++addIndex;
                            continue;
                        }
                        existingOption.setValue(EcoreUtil2.cloneIfContained(customOption.getValue()));
                    }
                }
                if (_startsWith_2 = (deresolvedStr = (uri = (_startsWith = (uri = r2.getURI()).toString().startsWith(this.getBaseDirUri().toString())) ? uri.deresolve(this.getBaseDirUri()) : ((_startsWith_1 = uri.toString().startsWith(interopResourceBaseUri.toString())) ? uri.deresolve(interopResourceBaseUri) : uri.deresolve(protoResourceBaseUri))).toString()).startsWith("/")) {
                    uri = URI.createURI(deresolvedStr.substring(1));
                }
                uri = uri.resolve(this.getOutDirUri());
                this.logger.info("Saving " + uri);
                try (FileOutputStream fop = null;){
                    FileOutputStream _fileOutputStream;
                    String string = uri.toFileString();
                    File file = new File(string);
                    boolean _exists = file.exists();
                    if (_exists) {
                        file.delete();
                    }
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    fop = _fileOutputStream = new FileOutputStream(file);
                    r2.save(fop, Collections.EMPTY_MAP);
                    fop.flush();
                }
                this.logger.info("Saved " + uri);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }
}

