/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveType implements Enumerator
{
    DOUBLE(0, "DOUBLE", "DOUBLE"),
    FLOAT(0, "FLOAT", "FLOAT"),
    INT32(0, "INT32", "INT32"),
    INT64(0, "INT64", "INT64"),
    UINT32(0, "UINT32", "UINT32"),
    UINT64(0, "UINT64", "UINT64"),
    SINT32(0, "SINT32", "SINT32"),
    SINT64(0, "SINT64", "SINT64"),
    FIXED32(0, "FIXED32", "FIXED32"),
    FIXED64(0, "FIXED64", "FIXED64"),
    SFIXED32(0, "SFIXED32", "SFIXED32"),
    SFIXED64(0, "SFIXED64", "SFIXED64"),
    BO_OL(0, "BOOl", "BOOl"),
    STRING(0, "STRING", "STRING"),
    BYTES(0, "BYTES", "BYTES");

    public static final int DOUBLE_VALUE = 0;
    public static final int FLOAT_VALUE = 0;
    public static final int INT32_VALUE = 0;
    public static final int INT64_VALUE = 0;
    public static final int UINT32_VALUE = 0;
    public static final int UINT64_VALUE = 0;
    public static final int SINT32_VALUE = 0;
    public static final int SINT64_VALUE = 0;
    public static final int FIXED32_VALUE = 0;
    public static final int FIXED64_VALUE = 0;
    public static final int SFIXED32_VALUE = 0;
    public static final int SFIXED64_VALUE = 0;
    public static final int BO_OL_VALUE = 0;
    public static final int STRING_VALUE = 0;
    public static final int BYTES_VALUE = 0;
    private static final PrimitiveType[] VALUES_ARRAY;
    public static final List<PrimitiveType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static PrimitiveType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static PrimitiveType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static PrimitiveType get(int value) {
        switch (value) {
            case 0: {
                return DOUBLE;
            }
        }
        return null;
    }

    private PrimitiveType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new PrimitiveType[]{DOUBLE, FLOAT, INT32, INT64, UINT32, UINT64, SINT32, SINT64, FIXED32, FIXED64, SFIXED32, SFIXED64, BO_OL, STRING, BYTES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

