/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractConstructorScope;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

public abstract class AbstractTypeScopeProvider
implements IGlobalScopeProvider {
    public IScope getScope(Resource resource, EReference reference) {
        return this.getScope(resource, reference, null);
    }

    @Override
    public IScope getScope(Resource resource, EReference reference, Predicate<IEObjectDescription> filter) {
        if (resource == null) {
            throw new IllegalStateException("context must be contained in a resource");
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            throw new IllegalStateException("context must be contained in a resource set");
        }
        EClass referenceType = reference.getEReferenceType();
        if (EcoreUtil2.isAssignableFrom(TypesPackage.Literals.JVM_TYPE, referenceType)) {
            IJvmTypeProvider typeProvider = this.getTypeProvider(resourceSet);
            return this.createTypeScope(typeProvider, filter);
        }
        if (EcoreUtil2.isAssignableFrom(TypesPackage.Literals.JVM_CONSTRUCTOR, referenceType)) {
            IJvmTypeProvider typeProvider = this.getTypeProvider(resourceSet);
            return this.createConstructorScope(typeProvider, filter);
        }
        return IScope.NULLSCOPE;
    }

    public IJvmTypeProvider getTypeProvider(ResourceSet resourceSet) {
        IJvmTypeProvider typeProvider = this.getTypeProviderFactory().findOrCreateTypeProvider(resourceSet);
        return typeProvider;
    }

    public abstract AbstractTypeScope createTypeScope(IJvmTypeProvider var1, Predicate<IEObjectDescription> var2);

    public abstract AbstractConstructorScope createConstructorScope(IJvmTypeProvider var1, Predicate<IEObjectDescription> var2);

    public abstract IJvmTypeProvider.Factory getTypeProviderFactory();

    public IScope createMemberScope(JvmType containerType, Predicate<JvmMember> filter, Function<JvmMember, QualifiedName> names, IScope outer) {
        if (containerType == null || containerType.eIsProxy()) {
            return outer;
        }
        if (containerType instanceof JvmDeclaredType) {
            IScope result = outer;
            EList<JvmTypeReference> superTypes = ((JvmDeclaredType)containerType).getSuperTypes();
            for (JvmTypeReference superType : superTypes) {
                if (superType.getType() == null) continue;
                result = this.createMemberScope(superType.getType(), filter, names, result);
            }
            EList<JvmMember> members = ((JvmDeclaredType)containerType).getMembers();
            return Scopes.scopeFor(Iterables.filter(members, filter), names, result);
        }
        return outer;
    }
}

