/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProtoSyntax implements Enumerator
{
    NONE(0, "None", "None"),
    PROTO2(0, "Proto2", "Proto2"),
    PROTO3(0, "Proto3", "Proto3");

    public static final int NONE_VALUE = 0;
    public static final int PROTO2_VALUE = 0;
    public static final int PROTO3_VALUE = 0;
    private static final ProtoSyntax[] VALUES_ARRAY;
    public static final List<ProtoSyntax> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ProtoSyntax get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ProtoSyntax result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ProtoSyntax getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ProtoSyntax result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ProtoSyntax get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    private ProtoSyntax(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ProtoSyntax[]{NONE, PROTO2, PROTO3};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

