/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.validation;

import com.db.plexus.interop.dsl.validation.IssuesComparator;
import com.google.common.base.Objects;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Issues {
    public static Issue createError(String message, String code) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setCode(code);
        issue.setMessage(message);
        issue.setSeverity(Severity.ERROR);
        return issue;
    }

    public static Comparator<Issue> issuesComparator() {
        return new IssuesComparator();
    }

    public static String issuesToString(List<Issue> issues) {
        boolean _isEmpty = issues.isEmpty();
        if (_isEmpty) {
            return Issues.successStringResult();
        }
        StringBuilder errorsBuilder = new StringBuilder();
        Functions.Function2<StringBuilder, Issue, StringBuilder> _function = (builder, issue) -> builder.append(Issues.issueToString(issue)).append("\n");
        IterableExtensions.fold(issues, errorsBuilder, _function);
        return errorsBuilder.toString();
    }

    public static String issueToString(Issue issue) {
        boolean _tripleNotEquals;
        String _name = issue.getSeverity().name();
        StringBuilder result = new StringBuilder(_name);
        result.append(": ").append(issue.getMessage());
        result.append(" [");
        URI _uriToProblem = issue.getUriToProblem();
        boolean bl = _tripleNotEquals = _uriToProblem != null;
        if (_tripleNotEquals) {
            result.append(issue.getUriToProblem().trimFragment());
        }
        if (issue.getLineNumber() != null || issue.getColumn() != null) {
            result.append(" line : ").append(issue.getLineNumber()).append(" column : ").append(issue.getColumn());
        }
        return result.append("]").toString();
    }

    public static boolean hasErrors(List<Issue> issues) {
        Predicate<Issue> _function = issue -> {
            Severity _severity = issue.getSeverity();
            return Objects.equal((Object)_severity, (Object)Severity.ERROR);
        };
        boolean _isEmpty = issues.stream().filter(_function).collect(Collectors.toList()).isEmpty();
        return !_isEmpty;
    }

    public static String successStringResult() {
        return "No issues found";
    }
}

