/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IAstFactory;
import org.eclipse.xtext.parser.ITokenToStringConverter;

public class DefaultEcoreElementFactory
implements IAstFactory {
    private static final Logger log = Logger.getLogger(DefaultEcoreElementFactory.class);
    @Inject
    private IValueConverterService converterService;
    @Inject(optional=true)
    private ITokenToStringConverter tokenConverter;

    public IValueConverterService getConverterService() {
        return this.converterService;
    }

    public void setConverterService(IValueConverterService converterService) {
        this.converterService = converterService;
    }

    @Override
    public EObject create(EClassifier classifier) {
        if (classifier == null) {
            throw new NullPointerException("Classifier may not be null.");
        }
        if (!(classifier instanceof EClass)) {
            throw new IllegalArgumentException("Cannot create instance of datatype '" + classifier.getName() + "'");
        }
        EClass clazz = (EClass)classifier;
        if (clazz.isAbstract() || clazz.isInterface()) {
            throw new IllegalArgumentException("Cannot create instance of abstract class '" + clazz.getName() + "'");
        }
        if (classifier.eIsProxy()) {
            throw new IllegalStateException("Unresolved proxy " + ((InternalEObject)((Object)classifier)).eProxyURI() + ". Make sure the EPackage has been registered.");
        }
        return clazz.getEPackage().getEFactoryInstance().create(clazz);
    }

    @Override
    public void set(EObject object, String feature, Object value, String ruleName, INode node) throws ValueConverterException {
        EStructuralFeature structuralFeature = object.eClass().getEStructuralFeature(feature);
        if (structuralFeature == null) {
            throw new IllegalArgumentException(object.eClass().getName() + "." + feature + " does not exist");
        }
        try {
            Object tokenValue = this.getTokenValue(value, ruleName, node);
            this.checkNullForPrimitiveFeatures(structuralFeature, tokenValue, node);
            object.eSet(structuralFeature, tokenValue);
        }
        catch (ValueConverterWithValueException e) {
            Object tokenValue = e.getValue();
            this.checkNullForPrimitiveFeatures(structuralFeature, tokenValue, node);
            object.eSet(structuralFeature, tokenValue);
            throw e;
        }
        catch (ValueConverterException e) {
            throw e;
        }
        catch (NullPointerException e) {
            log.warn(e.getMessage(), e);
            throw new ValueConverterException("A NullPointerException occured. This indicates a missing value converter or a bug in its implementation.", node, e);
        }
        catch (Exception e) {
            throw new ValueConverterException(null, node, e);
        }
    }

    private Object getTokenValue(Object tokenOrValue, String ruleName, INode node) throws ValueConverterException {
        Object value = this.getTokenAsStringIfPossible(tokenOrValue);
        if ((value == null || value instanceof CharSequence) && ruleName != null) {
            value = this.converterService.toValue(value == null ? null : value.toString(), ruleName, node);
        }
        return value;
    }

    protected Object getTokenAsStringIfPossible(Object tokenOrValue) {
        if (this.tokenConverter != null) {
            return this.tokenConverter.getTokenAsStringIfPossible(tokenOrValue);
        }
        return tokenOrValue;
    }

    @Override
    public void add(EObject object, String feature, Object value, String ruleName, INode node) throws ValueConverterException {
        if (value == null) {
            return;
        }
        EStructuralFeature structuralFeature = object.eClass().getEStructuralFeature(feature);
        if (structuralFeature == null) {
            throw new IllegalArgumentException(object.eClass().getName() + "." + feature + " does not exist");
        }
        try {
            if (value instanceof EObject) {
                ((InternalEList)object.eGet(structuralFeature)).addUnique((EObject)value);
            } else {
                Object tokenValue = this.getTokenValue(value, ruleName, node);
                this.checkNullForPrimitiveFeatures(structuralFeature, value, node);
                ((Collection)object.eGet(structuralFeature)).add(tokenValue);
            }
        }
        catch (ValueConverterWithValueException e) {
            Object tokenValue = e.getValue();
            this.checkNullForPrimitiveFeatures(structuralFeature, value, node);
            ((Collection)object.eGet(structuralFeature)).add(tokenValue);
            throw e;
        }
        catch (ValueConverterException e) {
            throw e;
        }
        catch (NullPointerException e) {
            log.error(e.getMessage(), e);
            throw new ValueConverterException("A NullPointerException occured. This indicates a missing value converter or a bug in its implementation.", node, e);
        }
        catch (Exception e) {
            throw new ValueConverterException(null, node, e);
        }
    }

    private void checkNullForPrimitiveFeatures(EStructuralFeature structuralFeature, Object tokenValue, INode node) {
        if (tokenValue == null && structuralFeature.getEType().getInstanceClass().isPrimitive()) {
            throw new ValueConverterException("ValueConverter returned null for primitive feature " + structuralFeature.getName(), node, null);
        }
    }
}

