/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.ContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.GrammarAlias;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.sequencer.RuleCallStack;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaToProduction;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaUtil;

@Singleton
public class SyntacticSequencerPDAProvider
implements ISyntacticSequencerPDAProvider {
    private static Logger LOG = Logger.getLogger(SyntacticSequencerPDAProvider.class);
    protected Map<Grammar, SerializationContextMap<ISyntacticSequencerPDAProvider.ISynAbsorberState>> cache = Maps.newHashMap();
    @Inject
    protected ContextTypePDAProvider pdaProvider;

    protected boolean canReachAbsorber(ISerState from, ISerState to, Set<ISerState> visited) {
        if (this.isMandatoryAbsorber(from.getGrammarElement()) || !visited.add(from)) {
            return false;
        }
        for (ISerState iSerState : from.getFollowers()) {
            if (iSerState == to) {
                return true;
            }
            if (!this.canReachAbsorber(iSerState, to, visited)) continue;
            return true;
        }
        return false;
    }

    protected void collectFollowingAbsorberStates(ISerState state, boolean collect, Set<ISerState> visited, Set<ISerState> absorber) {
        if (collect) {
            if (!visited.add(state)) {
                return;
            }
            if (this.isMandatoryAbsorber(state.getGrammarElement()) || state.getType() == ISerState.SerStateType.STOP) {
                absorber.add(state);
                return;
            }
            if (this.isOptionalAbsorber(state.getGrammarElement())) {
                absorber.add(state);
            }
        }
        for (ISerState iSerState : state.getFollowers()) {
            this.collectFollowingAbsorberStates(iSerState, true, visited, absorber);
        }
    }

    protected SynAbsorberState createAbsorberState(ISerState state, Map<ISerState, SynAbsorberState> absorbers, Map<SynAbsorberState, Map<ISerState, SynState>> emitters, EClass eClass) {
        SynAbsorberState result = absorbers.get(state);
        if (result != null) {
            return result;
        }
        if (state.getType() == ISerState.SerStateType.STOP) {
            result = this.createAbsorberState(ISyntacticSequencerPDAProvider.SynStateType.STOP, null, eClass);
            absorbers.put(state, result);
            return result;
        }
        result = this.createAbsorberState(this.getType(state), state.getGrammarElement(), eClass);
        absorbers.put(state, result);
        LinkedHashSet<ISerState> followers = Sets.newLinkedHashSet();
        this.collectFollowingAbsorberStates(state, false, Sets.newHashSet(), followers);
        for (ISerState follower : followers) {
            SynAbsorberState target = this.createAbsorberState(follower, absorbers, emitters, eClass);
            SynTransition transition = this.createTransition(result, target);
            Map<ISerState, SynState> emitter = emitters.get(target);
            if (emitter == null) {
                emitter = Maps.newLinkedHashMap();
                emitters.put(target, emitter);
            }
            transition.setFollowers(this.createEmitterStates(state, follower, target, emitter));
            result.addTransition(transition);
        }
        return result;
    }

    protected SynAbsorberState createAbsorberState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, EClass eClass) {
        return new SynAbsorberState(type, element, eClass);
    }

    protected SynState createEmitterState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, SynAbsorberState target) {
        return new SynEmitterState(type, element, target);
    }

    protected List<ISyntacticSequencerPDAProvider.ISynState> createEmitterStates(ISerState from, ISerState to, SynAbsorberState target, Map<ISerState, SynState> emitters) {
        ArrayList<ISyntacticSequencerPDAProvider.ISynState> result = Lists.newArrayList();
        for (ISerState iSerState : from.getFollowers()) {
            if (iSerState == to) {
                result.add(target);
                continue;
            }
            if (!this.canReachAbsorber(iSerState, to, Sets.newHashSet())) continue;
            SynState emitter = emitters.get(iSerState);
            if (emitter == null) {
                emitter = this.createEmitterState(this.getType(iSerState), iSerState.getGrammarElement(), target);
                emitters.put(iSerState, emitter);
                emitter.setFollowers(this.createEmitterStates(iSerState, to, target, emitters));
            }
            result.add(emitter);
        }
        return result;
    }

    protected SynTransition createTransition(SynAbsorberState source, SynAbsorberState target) {
        return new SynTransition(source, target);
    }

    @Override
    public SerializationContextMap<ISyntacticSequencerPDAProvider.ISynAbsorberState> getSyntacticSequencerPDAs(Grammar grammar) {
        SerializationContextMap<ISyntacticSequencerPDAProvider.ISynAbsorberState> cached = this.cache.get(grammar);
        if (cached != null) {
            return cached;
        }
        SerializationContextMap.Builder<SynAbsorberState> builder = SerializationContextMap.builder();
        SerializationContextMap<Pda<ISerState, RuleCall>> typePDAs = this.pdaProvider.getContextTypePDAs(grammar);
        for (SerializationContextMap.Entry<Pda<ISerState, RuleCall>> e : typePDAs.values()) {
            Pda<ISerState, RuleCall> pda = e.getValue();
            List<ISerializationContext> contexts = e.getContexts();
            try {
                EClass type = contexts.get(0).getType();
                LinkedHashMap<ISerState, SynAbsorberState> absorbers = Maps.newLinkedHashMap();
                LinkedHashMap<SynAbsorberState, Map<ISerState, SynState>> emitters = Maps.newLinkedHashMap();
                SynAbsorberState state = this.createAbsorberState((ISerState)pda.getStart(), absorbers, emitters, type);
                builder.put(contexts, state);
            }
            catch (Exception x) {
                String ctxs = Joiner.on(", ").join(contexts);
                LOG.error("Error creating PDA for syntactic sequencer for contexts: " + ctxs + ": " + x.getMessage(), x);
            }
        }
        SerializationContextMap<ISyntacticSequencerPDAProvider.ISynAbsorberState> result = builder.create();
        this.cache.put(grammar, result);
        return result;
    }

    protected ISyntacticSequencerPDAProvider.SynStateType getType(ISerState state) {
        switch (state.getType()) {
            case ELEMENT: {
                AbstractElement ele = state.getGrammarElement();
                if (ele instanceof Action) {
                    if (((Action)ele).getFeature() == null) {
                        return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGEND_ACTION_CALL;
                    }
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_ACTION_CALL;
                }
                if (GrammarUtil.containingCrossReference(ele) != null) {
                    if (ele instanceof RuleCall) {
                        RuleCall rc = (RuleCall)ele;
                        if (rc.getRule() instanceof ParserRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_DATATYPE_RULE_CALL;
                        }
                        if (rc.getRule() instanceof TerminalRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_TERMINAL_RULE_CALL;
                        }
                        if (!(rc.getRule() instanceof EnumRule)) break;
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_ENUM_RULE_CALL;
                    }
                    if (!(ele instanceof Keyword)) break;
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_KEYWORD;
                }
                Assignment ass = GrammarUtil.containingAssignment(ele);
                if (ass != null) {
                    if (ele instanceof RuleCall) {
                        RuleCall rc = (RuleCall)ele;
                        if (rc.getRule() instanceof ParserRule) {
                            if (rc.getRule().getType().getClassifier() instanceof EClass) {
                                return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_PARSER_RULE_CALL;
                            }
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_DATATYPE_RULE_CALL;
                        }
                        if (rc.getRule() instanceof TerminalRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_TERMINAL_RULE_CALL;
                        }
                        if (!(rc.getRule() instanceof EnumRule)) break;
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_ENUM_RULE_CALL;
                    }
                    if (!(ele instanceof Keyword)) break;
                    if (GrammarUtil.isBooleanAssignment(ass)) {
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_BOOLEAN_KEYWORD;
                    }
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_KEYWORD;
                }
                if (ele instanceof RuleCall) {
                    RuleCall rc = (RuleCall)ele;
                    if (rc.getRule() instanceof ParserRule) {
                        return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_DATATYPE_RULE_CALL;
                    }
                    if (!(rc.getRule() instanceof TerminalRule)) break;
                    return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_TERMINAL_RULE_CALL;
                }
                if (!(ele instanceof Keyword)) break;
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGEND_KEYWORD;
            }
            case PUSH: {
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_ENTER;
            }
            case POP: {
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_EXIT;
            }
            case START: {
                return ISyntacticSequencerPDAProvider.SynStateType.START;
            }
            case STOP: {
                return ISyntacticSequencerPDAProvider.SynStateType.STOP;
            }
        }
        throw new RuntimeException("no type found for " + state);
    }

    protected boolean isMandatoryAbsorber(AbstractElement ele) {
        if (ele == null) {
            return true;
        }
        if (GrammarUtil.isAssigned(ele)) {
            return true;
        }
        return GrammarUtil.isAssignedAction(ele);
    }

    protected boolean isOptionalAbsorber(AbstractElement ele) {
        return false;
    }

    protected static class SynTransition
    extends SynNavigable
    implements ISyntacticSequencerPDAProvider.ISynTransition {
        protected GrammarAlias.AbstractElementAlias ambiguousSyntax = null;
        protected List<GrammarAlias.AbstractElementAlias> ambiguousSyntaxes = null;
        protected ISyntacticSequencerPDAProvider.ISynAbsorberState source;

        public SynTransition(ISyntacticSequencerPDAProvider.ISynAbsorberState source, ISyntacticSequencerPDAProvider.ISynAbsorberState target) {
            super(ISyntacticSequencerPDAProvider.SynStateType.TRANSITION, null, target);
            this.source = source;
        }

        @Override
        public Nfa<ISyntacticSequencerPDAProvider.ISynState> getAmbiguousNfa() {
            Nfa<ISyntacticSequencerPDAProvider.ISynState> nfa = new PdaUtil().filterUnambiguousPaths(this.getPathToTarget());
            return new NfaUtil().filter(nfa, new Filter());
        }

        @Override
        public GrammarAlias.AbstractElementAlias getAmbiguousSyntax() {
            if (this.ambiguousSyntax != null) {
                return this.ambiguousSyntax;
            }
            Nfa<ISyntacticSequencerPDAProvider.ISynState> nfa = this.getAmbiguousNfa();
            NfaToProduction prod = new NfaToProduction();
            this.ambiguousSyntax = prod.nfaToGrammar(nfa, new ISyntacticSequencerPDAProvider.GetGrammarElement(), new GrammarAlias.GrammarAliasFactory());
            return this.ambiguousSyntax;
        }

        @Override
        public List<GrammarAlias.AbstractElementAlias> getAmbiguousSyntaxes() {
            if (this.ambiguousSyntaxes != null) {
                return this.ambiguousSyntaxes;
            }
            if (!this.isSyntacticallyAmbiguous()) {
                this.ambiguousSyntaxes = Collections.emptyList();
                return this.ambiguousSyntaxes;
            }
            this.ambiguousSyntaxes = Lists.newArrayList();
            GrammarAlias.AbstractElementAlias syntax = this.getAmbiguousSyntax();
            if (syntax instanceof GrammarAlias.GroupAlias) {
                GrammarAlias.GroupAlias group = (GrammarAlias.GroupAlias)syntax;
                for (GrammarAlias.AbstractElementAlias child : group.getChildren()) {
                    if (!child.isMany() && !child.isOptional() && !(child instanceof GrammarAlias.AlternativeAlias)) continue;
                    this.ambiguousSyntaxes.add(child);
                }
            } else {
                this.ambiguousSyntaxes.add(syntax);
            }
            return this.ambiguousSyntaxes;
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynAbsorberState getSource() {
            return this.source;
        }

        public GrammarAlias.AbstractElementAlias getSyntax() {
            Pda<ISyntacticSequencerPDAProvider.ISynState, RuleCall> pathToTarget = this.getPathToTarget();
            return new NfaToProduction().nfaToGrammar(pathToTarget, new ISyntacticSequencerPDAProvider.GetGrammarElement(), new GrammarAlias.GrammarAliasFactory());
        }

        @Override
        public String toString() {
            return this.getSyntax().toString();
        }

        private static final class Filter
        implements Predicate<ISyntacticSequencerPDAProvider.ISynState> {
            private Filter() {
            }

            @Override
            public boolean apply(ISyntacticSequencerPDAProvider.ISynState input) {
                AbstractElement ge = input.getGrammarElement();
                return ge instanceof Keyword || GrammarUtil.isDatatypeRuleCall(ge) || GrammarUtil.isEnumRuleCall(ge) || GrammarUtil.isTerminalRuleCall(ge);
            }
        }
    }

    protected static abstract class SynState
    implements ISyntacticSequencerPDAProvider.ISynState {
        protected AbstractElement element;
        protected List<ISyntacticSequencerPDAProvider.ISynState> followers = Collections.emptyList();
        protected ISyntacticSequencerPDAProvider.SynStateType type;

        public SynState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element) {
            this.type = type;
            this.element = element;
            this.followers = Collections.emptyList();
        }

        protected void addFollower(ISyntacticSequencerPDAProvider.ISynState follower) {
            if (this.followers.isEmpty()) {
                this.followers = Lists.newArrayList();
            }
            this.followers.add(follower);
        }

        protected void addFollower(List<ISyntacticSequencerPDAProvider.ISynState> follower) {
            if (this.followers.isEmpty()) {
                this.followers = Lists.newArrayList();
            }
            this.followers.addAll(follower);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getFollowers() {
            return this.followers;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.element;
        }

        @Override
        public ISyntacticSequencerPDAProvider.SynStateType getType() {
            return this.type;
        }

        protected void setFollowers(List<ISyntacticSequencerPDAProvider.ISynState> followers) {
            this.followers = followers;
        }

        public String toString() {
            return this.toString(new GrammarElementTitleSwitch().showAssignments().showQualified());
        }

        @Override
        public String toString(Function<AbstractElement, String> elementFormatter) {
            if (this.type == null) {
                return "(type is null)";
            }
            switch (this.type.getSimpleType()) {
                case ELEMENT: {
                    return this.element == null ? "(null)" : elementFormatter.apply(this.element);
                }
                case RULECALL_ENTER: {
                    return ">>" + (this.element == null ? "(null)" : elementFormatter.apply(this.element));
                }
                case RULECALL_EXIT: {
                    return "<<" + (this.element == null ? "(null)" : elementFormatter.apply(this.element));
                }
                case START: {
                    return "start";
                }
                case STOP: {
                    return "stop";
                }
            }
            return "";
        }
    }

    protected static class SynNavigable
    extends SynState
    implements ISyntacticSequencerPDAProvider.ISynNavigable {
        protected static final List<ISyntacticSequencerPDAProvider.ISynState> RULE_EXIT_DEPENDENT = Lists.newArrayList();
        protected int distanceToAbsorber = -1;
        protected Boolean involvesRuleExit;
        protected Boolean involvesUnassignedTokenRuleCalls = null;
        protected List<ISyntacticSequencerPDAProvider.ISynState> shortestPathToAbsorber = null;
        protected Boolean syntacticallyAmbiguous = null;
        protected ISyntacticSequencerPDAProvider.ISynAbsorberState target;

        public SynNavigable(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, ISyntacticSequencerPDAProvider.ISynAbsorberState target) {
            super(type, element);
            this.target = target;
        }

        @Override
        public EClass getEClass() {
            return this.target.getEClass();
        }

        @Override
        public Pda<ISyntacticSequencerPDAProvider.ISynState, RuleCall> getPathToTarget() {
            return new NavigablePDA(this);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestPathTo(final AbstractElement ele, RuleCallStack stack) {
            return this.shortestPathTo(stack.iterator(), new Predicate<ISyntacticSequencerPDAProvider.ISynState>(){

                @Override
                public boolean apply(ISyntacticSequencerPDAProvider.ISynState input) {
                    return input.getGrammarElement() == ele;
                }
            }, true);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestPathToAbsorber(RuleCallStack stack) {
            if (this.involvesRuleExit().booleanValue()) {
                return this.shortestPathTo(stack.iterator(), Predicates.equalTo(this.getTarget()), false);
            }
            if (this.shortestPathToAbsorber == null) {
                this.shortestPathToAbsorber = this.shortestPathTo(stack.iterator(), Predicates.equalTo(this.getTarget()), false);
            }
            return this.shortestPathToAbsorber;
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestStackpruningPathTo(final AbstractElement ele, RuleCallStack stack) {
            return this.shortestStackpruningPathTo(stack.iterator(), new Predicate<ISyntacticSequencerPDAProvider.ISynState>(){

                @Override
                public boolean apply(ISyntacticSequencerPDAProvider.ISynState input) {
                    return input.getGrammarElement() == ele;
                }
            }, true);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestStackpruningPathToAbsorber(RuleCallStack stack) {
            if (this.involvesRuleExit().booleanValue()) {
                return this.shortestStackpruningPathTo(stack.iterator(), Predicates.equalTo(this.getTarget()), false);
            }
            if (this.shortestPathToAbsorber == null) {
                this.shortestPathToAbsorber = this.shortestPathTo(stack.iterator(), Predicates.equalTo(this.getTarget()), false);
            }
            return this.shortestPathToAbsorber;
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynAbsorberState getTarget() {
            return this.target;
        }

        @Override
        public boolean hasEmitters() {
            return this.getFollowers().size() != 1 || !(this.getFollowers().get(0) instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState);
        }

        protected boolean involves(ISyntacticSequencerPDAProvider.ISynState from, Set<ISyntacticSequencerPDAProvider.SynStateType> types, Set<ISyntacticSequencerPDAProvider.ISynState> visited) {
            if (types.contains((Object)from.getType())) {
                return true;
            }
            if (!visited.add(from)) {
                return false;
            }
            for (ISyntacticSequencerPDAProvider.ISynState state : from.getFollowers()) {
                if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState || !this.involves(state, types, visited)) continue;
                return true;
            }
            return false;
        }

        protected boolean involves(Set<ISyntacticSequencerPDAProvider.SynStateType> types) {
            HashSet<ISyntacticSequencerPDAProvider.ISynState> visited = Sets.newHashSet();
            for (ISyntacticSequencerPDAProvider.ISynState state : this.followers) {
                if (!this.involves(state, types, visited)) continue;
                return true;
            }
            return false;
        }

        protected Boolean involvesRuleExit() {
            if (this.involvesRuleExit == null) {
                this.involvesRuleExit = this.involves(EnumSet.of(ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_EXIT));
            }
            return this.involvesRuleExit;
        }

        @Override
        public boolean involvesUnassignedTokenRuleCalls() {
            if (this.involvesUnassignedTokenRuleCalls == null) {
                this.involvesUnassignedTokenRuleCalls = this.involves(EnumSet.of(ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_DATATYPE_RULE_CALL, ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_TERMINAL_RULE_CALL));
            }
            return this.involvesUnassignedTokenRuleCalls;
        }

        @Override
        public boolean isSyntacticallyAmbiguous() {
            if (this.syntacticallyAmbiguous == null) {
                this.syntacticallyAmbiguous = this.isSyntacticallyAmbiguous(this.followers);
            }
            return this.syntacticallyAmbiguous;
        }

        protected boolean isSyntacticallyAmbiguous(ISyntacticSequencerPDAProvider.ISynState state, RuleCallStack exits, RuleCallStack stack, List<RuleCallStack> results, Set<ISyntacticSequencerPDAProvider.ISynState> visited) {
            if (!visited.add(state)) {
                return true;
            }
            if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
                results.add(exits);
                return false;
            }
            switch (state.getType().getSimpleType()) {
                case RULECALL_ENTER: {
                    stack = (RuleCallStack)stack.cloneAndPush((RuleCall)state.getGrammarElement());
                    break;
                }
                case RULECALL_EXIT: {
                    RuleCall rc = (RuleCall)state.getGrammarElement();
                    if (!stack.isEmpty()) {
                        if (rc == stack.peek()) {
                            stack = (RuleCallStack)stack.cloneAndPop();
                            break;
                        }
                        return false;
                    }
                    if (exits.contains(rc)) {
                        return false;
                    }
                    visited = Sets.newHashSet();
                    exits = (RuleCallStack)exits.cloneAndPush(rc);
                    break;
                }
            }
            for (ISyntacticSequencerPDAProvider.ISynState follower : state.getFollowers()) {
                if (!this.isSyntacticallyAmbiguous(follower, exits, stack, results, visited)) continue;
                return true;
            }
            return false;
        }

        protected boolean isSyntacticallyAmbiguous(List<ISyntacticSequencerPDAProvider.ISynState> states) {
            RuleCallStack exits = new RuleCallStack();
            RuleCallStack stack = new RuleCallStack();
            ArrayList<RuleCallStack> results = Lists.newArrayList();
            HashSet<ISyntacticSequencerPDAProvider.ISynState> visited = Sets.newHashSet();
            for (ISyntacticSequencerPDAProvider.ISynState state : states) {
                if (!this.isSyntacticallyAmbiguous(state, exits, stack, results, visited)) continue;
                return true;
            }
            return results.size() != Sets.newHashSet(results).size();
        }

        protected List<ISyntacticSequencerPDAProvider.ISynState> shortestPathTo(Iterator<RuleCall> stack, Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, boolean includeMatch) {
            List<Predicate<ISyntacticSequencerPDAProvider.ISynState>> pathTo = new PdaUtil().shortestPathTo(this.getPathToTarget(), stack, matches);
            if (pathTo != null) {
                return pathTo.subList(1, pathTo.size() - (includeMatch ? 0 : 1));
            }
            return null;
        }

        protected List<ISyntacticSequencerPDAProvider.ISynState> shortestStackpruningPathTo(Iterator<RuleCall> stack, Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, boolean includeMatch) {
            List<Predicate<ISyntacticSequencerPDAProvider.ISynState>> pathTo = new PdaUtil().shortestStackpruningPathTo(this.getPathToTarget(), stack, matches);
            if (pathTo != null) {
                return pathTo.subList(1, pathTo.size() - (includeMatch ? 0 : 1));
            }
            return null;
        }
    }

    protected static class SynEmitterState
    extends SynNavigable
    implements ISyntacticSequencerPDAProvider.ISynEmitterState {
        public SynEmitterState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, SynAbsorberState target) {
            super(type, element, target);
        }
    }

    protected static class SynAbsorberState
    extends SynState
    implements ISyntacticSequencerPDAProvider.ISynAbsorberState {
        protected EClass eClass;
        protected List<ISyntacticSequencerPDAProvider.ISynAbsorberState> outAbsorber = Lists.newArrayList();
        protected Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> outTransitionsByElement = Maps.newLinkedHashMap();

        public SynAbsorberState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, EClass eClass) {
            super(type, element);
            this.eClass = eClass;
        }

        protected void addTransition(ISyntacticSequencerPDAProvider.ISynTransition transition) {
            this.addFollower(transition.getFollowers());
            this.outAbsorber.add(transition.getTarget());
            switch (transition.getTarget().getType().getSimpleType()) {
                case START: {
                    throw new UnsupportedOperationException("StartStates can not have incoming transitions");
                }
                case ELEMENT: 
                case STOP: {
                    if (this.outTransitionsByElement.isEmpty()) {
                        this.outTransitionsByElement = Maps.newLinkedHashMap();
                    }
                    this.outTransitionsByElement.put(transition.getTarget().getGrammarElement(), transition);
                    break;
                }
            }
        }

        @Override
        public EClass getEClass() {
            return this.eClass;
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynAbsorberState> getOutAbsorbers() {
            return this.outAbsorber;
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynTransition> getOutTransitions() {
            ArrayList<ISyntacticSequencerPDAProvider.ISynTransition> result = Lists.newArrayList();
            result.addAll(this.outTransitionsByElement.values());
            return result;
        }

        @Override
        public Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> getOutTransitionsByElement() {
            return this.outTransitionsByElement;
        }
    }

    protected static class NavigablePDA
    implements Pda<ISyntacticSequencerPDAProvider.ISynState, RuleCall> {
        protected ISyntacticSequencerPDAProvider.ISynNavigable navigable;

        public NavigablePDA(ISyntacticSequencerPDAProvider.ISynNavigable navigable) {
            this.navigable = navigable;
        }

        @Override
        public Iterable<ISyntacticSequencerPDAProvider.ISynState> getFollowers(ISyntacticSequencerPDAProvider.ISynState node) {
            if (node instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
                if (this.navigable instanceof ISyntacticSequencerPDAProvider.ISynTransition && ((ISyntacticSequencerPDAProvider.ISynTransition)this.navigable).getSource() == node) {
                    return this.navigable.getFollowers();
                }
                return Collections.emptyList();
            }
            return node.getFollowers();
        }

        @Override
        public RuleCall getPop(ISyntacticSequencerPDAProvider.ISynState state) {
            return state.getType() == ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_EXIT ? (RuleCall)state.getGrammarElement() : null;
        }

        @Override
        public RuleCall getPush(ISyntacticSequencerPDAProvider.ISynState state) {
            return state.getType() == ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_ENTER ? (RuleCall)state.getGrammarElement() : null;
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynState getStart() {
            if (this.navigable instanceof ISyntacticSequencerPDAProvider.ISynTransition) {
                return ((ISyntacticSequencerPDAProvider.ISynTransition)this.navigable).getSource();
            }
            return (ISyntacticSequencerPDAProvider.ISynState)((Object)this.navigable);
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynState getStop() {
            return this.navigable.getTarget();
        }
    }
}

