/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IApplicableCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ExtendedEarlyExitComputer;

public class RootResolvedTypes
extends ResolvedTypes {
    private Set<XExpression> toBeInferredRootExpressions;

    protected RootResolvedTypes(DefaultReentrantTypeResolver resolver, CancelIndicator monitor) {
        super(new ResolvedTypes.Shared(resolver, monitor));
        this.shared.root = this;
    }

    public void resolveUnboundTypeParameters() {
        for (UnboundTypeReference unbound : this.basicGetTypeParameters().values()) {
            unbound.resolve();
        }
    }

    public void resolveProxies() {
        Map<XExpression, IApplicableCandidate> candidates = this.basicGetLinkingMap();
        for (IApplicableCandidate candidate : candidates.values()) {
            candidate.applyToModel(this);
        }
    }

    @Override
    protected LightweightTypeReference getExpectedTypeForAssociatedExpression(JvmMember member, XExpression expression) {
        if (this.toBeInferredRootExpressions != null && this.toBeInferredRootExpressions.contains(expression)) {
            return null;
        }
        return this.getActualType(member);
    }

    @Override
    protected void markToBeInferred(XExpression expression) {
        if (this.toBeInferredRootExpressions == null) {
            this.toBeInferredRootExpressions = Sets.newHashSet();
        }
        this.toBeInferredRootExpressions.add(expression);
    }

    public void addDiagnostics(final Resource resource) {
        if (resource instanceof XtextResource && ((XtextResource)resource).isValidationDisabled()) {
            return;
        }
        class DiagnosticAcceptor
        implements IAcceptor<AbstractDiagnostic> {
            DiagnosticAcceptor() {
            }

            @Override
            public void accept(AbstractDiagnostic diagnostic) {
                if (diagnostic instanceof EObjectDiagnosticImpl) {
                    Severity severity = ((EObjectDiagnosticImpl)diagnostic).getSeverity();
                    if (severity == Severity.ERROR) {
                        resource.getErrors().add(diagnostic);
                    } else if (severity == Severity.WARNING) {
                        resource.getWarnings().add(diagnostic);
                    }
                } else {
                    resource.getErrors().add(diagnostic);
                }
            }
        }
        DiagnosticAcceptor acceptor = new DiagnosticAcceptor();
        this.addQueuedDiagnostics(acceptor);
        this.addLinkingDiagnostics(acceptor);
        this.addTypeDiagnostics(acceptor);
    }

    protected void addTypeDiagnostics(IAcceptor<? super AbstractDiagnostic> acceptor) {
        for (Map.Entry<XExpression, List<TypeData>> entry : this.basicGetExpressionTypes().entrySet()) {
            XExpression expression = entry.getKey();
            if (this.isPropagatedType(expression)) continue;
            this.addTypeDiagnostic(expression, this.mergeTypeData(expression, entry.getValue(), false, false), acceptor);
        }
    }

    protected void addTypeDiagnostic(XExpression expression, TypeData typeData, IAcceptor<? super AbstractDiagnostic> acceptor) {
        if (typeData != null) {
            LightweightTypeReference actualType = typeData.getActualType();
            ITypeExpectation expectation = typeData.getExpectation();
            int knownFlags = typeData.getConformanceFlags();
            if ((knownFlags & 0x14000000) == 0) {
                if (actualType.isPrimitiveVoid() && this.isIntentionalEarlyExit(expression)) {
                    return;
                }
                LightweightTypeReference expectedType = expectation.getExpectedType();
                if (expectedType != null) {
                    AbstractDiagnostic diagnostic;
                    int conformanceFlags;
                    if (!expectedType.isPrimitiveVoid() && ((conformanceFlags = this.getConformanceFlags(typeData, false)) & 0x200) == 0 && (diagnostic = this.createTypeDiagnostic(expression, actualType, expectedType)) != null) {
                        acceptor.accept(diagnostic);
                    }
                } else if (!expectation.isVoidTypeAllowed() && actualType.isPrimitiveVoid()) {
                    EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", "Type mismatch: type void is not applicable at this location", expression, null, -1, null);
                    acceptor.accept(diagnostic);
                }
            }
        }
    }

    protected boolean isIntentionalEarlyExit(XExpression expression) {
        ExtendedEarlyExitComputer earlyExitComputer = this.getReferenceOwner().getServices().getEarlyExitComputer();
        return earlyExitComputer.isIntentionalEarlyExit(expression);
    }

    protected AbstractDiagnostic createTypeDiagnostic(XExpression expression, LightweightTypeReference actualType, LightweightTypeReference expectedType) {
        if (!expectedType.isAny()) {
            String expectedName;
            String actualName = actualType.getSimpleName();
            if (actualName.equals(expectedName = expectedType.getSimpleName()) && expectedType.isAssignableFrom(actualType)) {
                return null;
            }
            if (expression.eContainingFeature() == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__IMPLICIT_FIRST_ARGUMENT) {
                return new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert implicit first argument from %s to %s", actualType.getHumanReadableName(), expectedType.getHumanReadableName()), expression, null, -1, null);
            }
            return new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert from %s to %s", actualType.getHumanReadableName(), expectedType.getHumanReadableName()), expression, null, -1, null);
        }
        return new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: type %s is not applicable at this location", actualType.getHumanReadableName()), expression, null, -1, null);
    }

    protected void addLinkingDiagnostics(IAcceptor<? super AbstractDiagnostic> acceptor) {
        Map<XExpression, IApplicableCandidate> candidates = this.basicGetLinkingMap();
        for (IApplicableCandidate candidate : candidates.values()) {
            candidate.validate(acceptor);
        }
    }

    protected void addQueuedDiagnostics(IAcceptor<? super AbstractDiagnostic> acceptor) {
        for (AbstractDiagnostic diagnostic : this.getQueuedDiagnostics()) {
            acceptor.accept(diagnostic);
        }
    }

    protected void processDeferredLogic() {
        for (IAcceptor<? super IResolvedTypes> runnable : this.getDeferredLogic()) {
            runnable.accept(this);
        }
        this.clearDeferredLogic();
    }
}

