/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.ts;

import com.db.plexus.interop.dsl.Application;
import com.db.plexus.interop.dsl.gen.BaseGenTask;
import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.gen.ts.TypescriptApplicationApiGenerator;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResourceSet;

@Named
public class TsGenTask
extends BaseGenTask {
    public static final String PROTO_TS_COMPILER = "pbts";
    public static final String PROTO_TS_COMPILER_CMD = "pbts.cmd";
    public static final String PROTO_JS_COMPILER = "pbjs";
    public static final String PROTO_JS_COMPILER_CMD = "pbjs.cmd";
    public static final String PLEXUS_MESSAGES_MODULES = "plexus-messages";
    @Inject
    private TypescriptApplicationApiGenerator codeOutputGenerator;

    @Override
    public void validateResources(PlexusGenConfig config, XtextResourceSet resourceSet) {
        super.validateResources(config, resourceSet);
        this.validateInteropResourceLoaded(config, resourceSet);
    }

    @Override
    protected void doGenWithResources(PlexusGenConfig config, XtextResourceSet resourceSet) throws IOException {
        EList<Resource> resources = resourceSet.getResources();
        String pbTsPath = null;
        String pbJsPath = null;
        String configProtocPath = config.getProtocPath();
        if (configProtocPath == null || configProtocPath.isEmpty()) {
            this.logger.info("Proto compiler not provided, messages generation will be skipped");
        } else if (!configProtocPath.endsWith(PROTO_TS_COMPILER) && !configProtocPath.endsWith(PROTO_TS_COMPILER_CMD)) {
            this.logger.warning("Only pbts compiler supported, messages generation will be skipped");
        } else {
            pbTsPath = configProtocPath;
            pbJsPath = configProtocPath.endsWith(PROTO_TS_COMPILER) ? configProtocPath.substring(0, configProtocPath.lastIndexOf(PROTO_TS_COMPILER)) + PROTO_JS_COMPILER : configProtocPath.substring(0, configProtocPath.lastIndexOf(PROTO_TS_COMPILER_CMD)) + PROTO_JS_COMPILER_CMD;
        }
        List<String> protoFilePaths = this.getProtoFilePaths(resources, config);
        String outDirPath = this.getAbsolutePath(config.getOutDir());
        if (protoFilePaths.isEmpty()) {
            this.logger.warning("No proto resources detected");
        }
        if (!protoFilePaths.isEmpty() && pbJsPath != null) {
            this.logger.info("Using " + pbJsPath + " to generate JS messages");
            ArrayList<String> pbJsArgs = new ArrayList<String>(Arrays.asList(pbJsPath));
            pbJsArgs.addAll(this.jsProtoArgs(config, outDirPath));
            pbJsArgs.addAll(protoFilePaths);
            int resultCode = this.generateMessages(pbJsArgs);
            if (resultCode == 0) {
                this.logger.info("Generated successfully");
                this.logger.info("Using " + pbTsPath + " to generate TS messages definitions");
                ArrayList<String> pbTsArgs = new ArrayList<String>(Arrays.asList(pbTsPath));
                pbTsArgs.addAll(this.tsProtoArgs(config, outDirPath));
                int code = this.generateMessages(pbTsArgs);
                if (code == 0) {
                    this.logger.info("Generated successfully");
                }
            }
        }
        List<Application> applications = GenUtils.getApplications(resources.toArray(new Resource[0]));
        config.setExternalDependencies(Arrays.asList("./plexus-messages"));
        for (Application application : applications) {
            this.logger.info("Generating TS Client for " + application.getName());
            String stringContent = this.codeOutputGenerator.generate(config, application, resources);
            this.logger.info("Generated successfully");
            this.writeToFile(config.getOutDir() + "/" + application.getName() + "GeneratedClient.ts", stringContent);
        }
    }

    private List<String> tsProtoArgs(PlexusGenConfig config, String outDirPath) {
        return Arrays.asList("--force-long", "-t", "static-module", "-r", config.getNamespace(), "-w", "commonjs", "-o", outDirPath + File.separator + PLEXUS_MESSAGES_MODULES + ".d.ts", outDirPath + File.separator + PLEXUS_MESSAGES_MODULES + ".js");
    }

    private List<String> jsProtoArgs(PlexusGenConfig config, String outDirPath) {
        return Arrays.asList("--force-long", "-t", "static-module", "-r", config.getNamespace(), "-w", "commonjs", "-o", outDirPath + File.separator + PLEXUS_MESSAGES_MODULES + ".js");
    }
}

