/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FieldLabel implements Enumerator
{
    NONE(0, "None", "None"),
    OPTIONAL(0, "Optional", "Optional"),
    REQUIRED(0, "Required", "Required"),
    REPEATED(0, "Repeated", "Repeated");

    public static final int NONE_VALUE = 0;
    public static final int OPTIONAL_VALUE = 0;
    public static final int REQUIRED_VALUE = 0;
    public static final int REPEATED_VALUE = 0;
    private static final FieldLabel[] VALUES_ARRAY;
    public static final List<FieldLabel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static FieldLabel get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            FieldLabel result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static FieldLabel getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            FieldLabel result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static FieldLabel get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    private FieldLabel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new FieldLabel[]{NONE, OPTIONAL, REQUIRED, REPEATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

