/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.protobuf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImportModifier implements Enumerator
{
    NONE(0, "None", "None"),
    PUBLIC(0, "Public", "Public"),
    WEAK(0, "Weak", "Weak");

    public static final int NONE_VALUE = 0;
    public static final int PUBLIC_VALUE = 0;
    public static final int WEAK_VALUE = 0;
    private static final ImportModifier[] VALUES_ARRAY;
    public static final List<ImportModifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ImportModifier get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ImportModifier result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ImportModifier getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ImportModifier result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ImportModifier get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    private ImportModifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ImportModifier[]{NONE, PUBLIC, WEAK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

