/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.generator.trace.AbstractStatefulTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IndentNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.generator.trace.node.TextNode;
import org.eclipse.xtext.generator.trace.node.TraceNode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class GeneratorNodeProcessor {
    public Result process(IGeneratorNode root) {
        Context _context = new Context();
        Procedures.Procedure1<Context> _function = it -> {
            StringBuilder _stringBuilder = new StringBuilder();
            ((Context)it).lines = CollectionLiterals.newArrayList(_stringBuilder);
            ArrayDeque _arrayDeque = new ArrayDeque();
            ((Context)it).currentIndents = _arrayDeque;
            ((Context)it).pendingIndent = true;
        };
        Context ctx = ObjectExtensions.operator_doubleArrow(_context, _function);
        this.doProcess(root, ctx);
        String _join = IterableExtensions.join(ctx.lines);
        return new Result(_join, ctx.currentRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _doProcess(IndentNode node, Context ctx) {
        boolean __hasContent = this._hasContent(node, ctx);
        if (__hasContent) {
            if (node.isIndentImmediately() && !ctx.pendingIndent) {
                ctx.currentLine().append(node.getIndentationString());
            }
            try {
                ctx.currentIndents.push(node);
                this.doProcessChildren(node, ctx);
            }
            finally {
                ctx.currentIndents.pop();
            }
        }
    }

    protected void _doProcess(NewLineNode node, Context ctx) {
        if (node.isIfNotEmpty() && !GeneratorNodeProcessor.hasNonWhitespace(ctx.currentLine())) {
            int _currentLineNumber = ctx.currentLineNumber();
            StringBuilder _stringBuilder = new StringBuilder();
            ctx.lines.set(_currentLineNumber, _stringBuilder);
        } else {
            if (ctx.pendingIndent) {
                this.handlePendingIndent(ctx, true);
            }
            ctx.currentLine().append(node.getLineDelimiter());
            StringBuilder _stringBuilder_1 = new StringBuilder();
            ctx.lines.add(_stringBuilder_1);
        }
        ctx.pendingIndent = true;
    }

    protected void _doProcess(TextNode node, Context ctx) {
        boolean __hasContent = this._hasContent(node, ctx);
        if (__hasContent) {
            if (ctx.pendingIndent) {
                this.handlePendingIndent(ctx, false);
            }
            ctx.currentLine().append(node.getText());
        }
    }

    protected void handlePendingIndent(Context ctx, boolean endOfLine) {
        boolean _greaterThan;
        StringBuilder indentString = new StringBuilder();
        for (IndentNode indentNode : ctx.currentIndents) {
            if (!indentNode.isIndentEmptyLines() && endOfLine) continue;
            indentString.append(indentNode.getIndentationString());
        }
        int _length = indentString.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            ctx.currentLine().insert(0, indentString);
        }
        ctx.pendingIndent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _doProcess(TraceNode node, Context ctx) {
        boolean __hasContent = this._hasContent(node, ctx);
        if (__hasContent) {
            AbstractTraceRegion beforeRegion = ctx.currentRegion;
            boolean _isUseForDebugging = node.isUseForDebugging();
            ILocationData _sourceLocation = node.getSourceLocation();
            CompletableTraceRegion newRegion = new CompletableTraceRegion(_isUseForDebugging, _sourceLocation, beforeRegion);
            int offset = ctx.contentLength();
            int startLineNumber = ctx.currentLineNumber();
            try {
                ctx.currentRegion = newRegion;
                this.doProcessChildren(node, ctx);
            }
            finally {
                if (beforeRegion != null) {
                    ctx.currentRegion = beforeRegion;
                }
                int _contentLength = ctx.contentLength();
                int _minus = _contentLength - offset;
                newRegion.complete(offset, _minus, startLineNumber, ctx.currentLineNumber());
            }
        }
    }

    protected void _doProcess(CompositeGeneratorNode node, Context ctx) {
        this.doProcessChildren(node, ctx);
    }

    protected void doProcessChildren(CompositeGeneratorNode node, Context ctx) {
        List<IGeneratorNode> _children = node.getChildren();
        for (IGeneratorNode child : _children) {
            this.doProcess(child, ctx);
        }
    }

    protected boolean _hasContent(CompositeGeneratorNode node, Context ctx) {
        Functions.Function1<IGeneratorNode, Boolean> _function = it -> this.hasContent((IGeneratorNode)it, ctx);
        return IterableExtensions.exists(node.getChildren(), _function);
    }

    protected boolean _hasContent(NewLineNode node, Context ctx) {
        return !node.isIfNotEmpty() || ctx.currentLine().length() != 0;
    }

    protected boolean _hasContent(TextNode node, Context ctx) {
        boolean _isNullOrEmpty = GeneratorNodeProcessor.isNullOrEmpty(node.getText());
        return !_isNullOrEmpty;
    }

    protected static boolean hasNonWhitespace(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            boolean _not;
            boolean _isWhitespace = Character.isWhitespace(s.charAt(i));
            boolean bl = _not = !_isWhitespace;
            if (!_not) continue;
            return true;
        }
        return false;
    }

    protected static boolean isNullOrEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    protected void doProcess(IGeneratorNode node, Context ctx) {
        if (node instanceof IndentNode) {
            this._doProcess((IndentNode)node, ctx);
            return;
        }
        if (node instanceof TraceNode) {
            this._doProcess((TraceNode)node, ctx);
            return;
        }
        if (node instanceof CompositeGeneratorNode) {
            this._doProcess((CompositeGeneratorNode)node, ctx);
            return;
        }
        if (node instanceof NewLineNode) {
            this._doProcess((NewLineNode)node, ctx);
            return;
        }
        if (node instanceof TextNode) {
            this._doProcess((TextNode)node, ctx);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, ctx).toString());
    }

    protected boolean hasContent(IGeneratorNode node, Context ctx) {
        if (node instanceof CompositeGeneratorNode) {
            return this._hasContent((CompositeGeneratorNode)node, ctx);
        }
        if (node instanceof NewLineNode) {
            return this._hasContent((NewLineNode)node, ctx);
        }
        if (node instanceof TextNode) {
            return this._hasContent((TextNode)node, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, ctx).toString());
    }

    public static class CompletableTraceRegion
    extends AbstractStatefulTraceRegion {
        private CompletableTextRegion region;

        public CompletableTraceRegion(boolean useForDebugging, ILocationData associatedLocation, AbstractTraceRegion parent) {
            this(new CompletableTextRegion(), useForDebugging, associatedLocation, parent);
        }

        protected CompletableTraceRegion(CompletableTextRegion region, boolean useForDebugging, ILocationData associatedLocation, AbstractTraceRegion parent) {
            super((ITextRegionWithLineInformation)region, useForDebugging, associatedLocation, parent);
            this.region = region;
        }

        public void complete(int offset, int length, int startLine, int endLine) {
            TextRegionWithLineInformation _textRegionWithLineInformation = new TextRegionWithLineInformation(offset, length, startLine, endLine);
            this.region.delegate = _textRegionWithLineInformation;
        }

        @Override
        protected boolean isConsistentWithParent() {
            return true;
        }

        public static class CompletableTextRegion
        implements ITextRegionWithLineInformation {
            private ITextRegionWithLineInformation delegate;

            @Delegate
            public ITextRegionWithLineInformation getDelegate() {
                if (this.delegate == null) {
                    throw new IllegalStateException("region not completed");
                }
                return this.delegate;
            }

            @Override
            public int getLineNumber() {
                return this.getDelegate().getLineNumber();
            }

            @Override
            public int getEndLineNumber() {
                return this.getDelegate().getEndLineNumber();
            }

            @Override
            public ITextRegionWithLineInformation merge(ITextRegionWithLineInformation arg0) {
                return this.getDelegate().merge(arg0);
            }

            @Override
            public int getOffset() {
                return this.getDelegate().getOffset();
            }

            @Override
            public int getLength() {
                return this.getDelegate().getLength();
            }

            @Override
            public ITextRegion merge(ITextRegion arg0) {
                return this.getDelegate().merge(arg0);
            }

            @Override
            public boolean contains(ITextRegion arg0) {
                return this.getDelegate().contains(arg0);
            }

            @Override
            public boolean contains(int arg0) {
                return this.getDelegate().contains(arg0);
            }
        }
    }

    @Accessors
    protected static class Context {
        private List<StringBuilder> lines;
        private Deque<IndentNode> currentIndents;
        private boolean pendingIndent;
        private AbstractTraceRegion currentRegion = null;

        protected Context() {
        }

        public StringBuilder currentLine() {
            return this.lines.get(this.currentLineNumber());
        }

        public int contentLength() {
            Functions.Function2<Integer, StringBuilder, Integer> _function = ($0, $1) -> {
                int _length = $1.length();
                return $0 + _length;
            };
            Integer contentLength = IterableExtensions.fold(this.lines, 0, _function);
            if (this.pendingIndent) {
                Functions.Function2<Integer, IndentNode, Integer> _function_1 = ($0, $1) -> {
                    int _length = $1.getIndentationString().length();
                    return $0 + _length;
                };
                Integer _fold = IterableExtensions.fold(this.currentIndents, 0, _function_1);
                return contentLength + _fold;
            }
            return contentLength;
        }

        public int currentLineNumber() {
            int _size = this.lines.size();
            return _size - 1;
        }

        @Pure
        public List<StringBuilder> getLines() {
            return this.lines;
        }

        public void setLines(List<StringBuilder> lines) {
            this.lines = lines;
        }

        @Pure
        public Deque<IndentNode> getCurrentIndents() {
            return this.currentIndents;
        }

        public void setCurrentIndents(Deque<IndentNode> currentIndents) {
            this.currentIndents = currentIndents;
        }

        @Pure
        public boolean isPendingIndent() {
            return this.pendingIndent;
        }

        public void setPendingIndent(boolean pendingIndent) {
            this.pendingIndent = pendingIndent;
        }

        @Pure
        public AbstractTraceRegion getCurrentRegion() {
            return this.currentRegion;
        }

        public void setCurrentRegion(AbstractTraceRegion currentRegion) {
            this.currentRegion = currentRegion;
        }
    }

    @Data
    public static class Result
    implements CharSequence,
    ITraceRegionProvider {
        @Delegate
        private final CharSequence contents;
        private final AbstractTraceRegion traceRegion;

        @Override
        public AbstractTraceRegion getTraceRegion() throws TraceNotFoundException {
            return this.traceRegion;
        }

        @Override
        public String toString() {
            return this.contents.toString();
        }

        public Result(CharSequence contents, AbstractTraceRegion traceRegion) {
            this.contents = contents;
            this.traceRegion = traceRegion;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
            result = 31 * result + (this.traceRegion == null ? 0 : this.traceRegion.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
                return false;
            }
            return !(this.traceRegion == null ? other.traceRegion != null : !this.traceRegion.equals(other.traceRegion));
        }

        @Pure
        public CharSequence getContents() {
            return this.contents;
        }

        @Override
        public int length() {
            return this.contents.length();
        }

        @Override
        public char charAt(int arg0) {
            return this.contents.charAt(arg0);
        }

        @Override
        public CharSequence subSequence(int arg0, int arg1) {
            return this.contents.subSequence(arg0, arg1);
        }

        @Override
        public IntStream chars() {
            return this.contents.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.contents.codePoints();
        }
    }
}

