/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.TracedAccessors;
import org.eclipse.xtext.generator.trace.node.TracingSugar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TracedAccessorsProcessor
extends AbstractClassProcessor {
    private static final Set<String> TYPES_WITH_GOOD_TO_STRING = Collections.unmodifiableSet(CollectionLiterals.newHashSet("string", "boolean", "int", "long", "integer"));

    @Override
    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        TypeReference[] factories;
        annotatedClass.setExtendedClass(context.newTypeReference(TracingSugar.class, new TypeReference[0]));
        TypeReference iterableType = context.newTypeReference(Iterable.class, context.newWildcardTypeReference());
        TypeReference annotationType = context.newTypeReference(TracedAccessors.class, new TypeReference[0]);
        AnnotationReference _findAnnotation = annotatedClass.findAnnotation(annotationType.getType());
        TypeReference[] _classArrayValue = null;
        if (_findAnnotation != null) {
            _classArrayValue = _findAnnotation.getClassArrayValue("value");
        }
        if ((factories = _classArrayValue) == null) {
            return;
        }
        Functions.Function1<TypeReference, Type> _function = it -> it.getType();
        Iterable<InterfaceDeclaration> _filter = Iterables.filter(ListExtensions.map((List)Conversions.doWrapArray(factories), _function), InterfaceDeclaration.class);
        for (InterfaceDeclaration f : _filter) {
            Functions.Function1<MethodDeclaration, Boolean> _function_1 = it -> it.getSimpleName().startsWith("create") && IterableExtensions.isEmpty(it.getParameters());
            Functions.Function1<MethodDeclaration, TypeReference> _function_2 = it -> it.getReturnType();
            Iterable<TypeReference> _map = IterableExtensions.map(IterableExtensions.filter(f.getDeclaredMethods(), _function_1), _function_2);
            for (TypeReference t : _map) {
                Functions.Function1<ResolvedMethod, Boolean> _function_3 = it -> this.isSupportedGetter((ResolvedMethod)it);
                Functions.Function1<ResolvedMethod, Boolean> _function_4 = it -> {
                    boolean _isAssignableFrom = iterableType.isAssignableFrom(it.getDeclaration().getReturnType());
                    return !_isAssignableFrom;
                };
                Iterable<ResolvedMethod> _filter_1 = IterableExtensions.filter(IterableExtensions.filter(t.getAllResolvedMethods(), _function_3), _function_4);
                for (final ResolvedMethod getter : _filter_1) {
                    TypeReference rt = getter.getResolvedReturnType();
                    boolean _contains = TYPES_WITH_GOOD_TO_STRING.contains(rt.getType().getSimpleName().toLowerCase());
                    if (_contains) {
                        Procedures.Procedure1<MutableMethodDeclaration> _function_5 = it -> {
                            it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                            it.addParameter("target", t);
                            StringConcatenationClient _client = new StringConcatenationClient(){

                                @Override
                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append(EStructuralFeature.class);
                                    _builder.append(" feature = target.eClass().getEStructuralFeature(\"");
                                    String _featureName = TracedAccessorsProcessor.this.featureName(getter);
                                    _builder.append(_featureName);
                                    _builder.append("\");");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append(ILocationData.class);
                                    _builder.append(" location = this.location(target, feature, -1);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append(CompositeGeneratorNode.class);
                                    _builder.append(" trace = this.trace(location);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("this.append(trace, target.");
                                    String _simpleName = getter.getDeclaration().getSimpleName();
                                    _builder.append(_simpleName);
                                    _builder.append("());");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("return trace;");
                                    _builder.newLine();
                                }
                            };
                            it.setBody(_client);
                        };
                        annotatedClass.addMethod(this.tracerName(getter), _function_5);
                        Procedures.Procedure1<MutableMethodDeclaration> _function_6 = it -> {
                            it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                            it.addParameter("target", t);
                            it.addParameter("useForDebugging", context.newTypeReference(Boolean.TYPE, new TypeReference[0]));
                            StringConcatenationClient _client = new StringConcatenationClient(){

                                @Override
                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append(EStructuralFeature.class);
                                    _builder.append(" feature = target.eClass().getEStructuralFeature(\"");
                                    String _featureName = TracedAccessorsProcessor.this.featureName(getter);
                                    _builder.append(_featureName);
                                    _builder.append("\");");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append(ILocationData.class);
                                    _builder.append(" location = this.location(target, feature, -1);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append(CompositeGeneratorNode.class);
                                    _builder.append(" trace = this.trace(location, useForDebugging);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("this.append(trace, target.");
                                    String _simpleName = getter.getDeclaration().getSimpleName();
                                    _builder.append(_simpleName);
                                    _builder.append("());");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("return trace;");
                                    _builder.newLine();
                                }
                            };
                            it.setBody(_client);
                        };
                        annotatedClass.addMethod(this.tracerName(getter), _function_6);
                    }
                    Procedures.Procedure1<MutableMethodDeclaration> _function_7 = it -> {
                        it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                        it.addParameter("target", t);
                        TypeReference stringProvider = context.newTypeReference(Function.class, rt, context.getString());
                        it.addParameter("stringProvider", stringProvider);
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            @Override
                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append(EStructuralFeature.class);
                                _builder.append(" feature = target.eClass().getEStructuralFeature(\"");
                                String _featureName = TracedAccessorsProcessor.this.featureName(getter);
                                _builder.append(_featureName);
                                _builder.append("\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append(ILocationData.class);
                                _builder.append(" location = this.location(target, feature, -1);");
                                _builder.newLineIfNotEmpty();
                                _builder.append(CompositeGeneratorNode.class);
                                _builder.append(" trace = this.trace(location);");
                                _builder.newLineIfNotEmpty();
                                _builder.append("this.append(trace, stringProvider.apply(target.");
                                String _simpleName = getter.getDeclaration().getSimpleName();
                                _builder.append(_simpleName);
                                _builder.append("()));");
                                _builder.newLineIfNotEmpty();
                                _builder.append("return trace;");
                                _builder.newLine();
                            }
                        };
                        it.setBody(_client);
                    };
                    annotatedClass.addMethod(this.tracerName(getter), _function_7);
                }
            }
        }
    }

    public String tracerName(ResolvedMethod m) {
        String _featureName = this.featureName(m);
        return "_" + _featureName;
    }

    public String featureName(ResolvedMethod m) {
        String _xblockexpression = null;
        String n = m.getDeclaration().getSimpleName();
        int _xifexpression = 0;
        boolean _startsWith = n.startsWith("get");
        _xifexpression = _startsWith ? 3 : 2;
        int skip = _xifexpression;
        _xblockexpression = StringExtensions.toFirstLower(m.getDeclaration().getSimpleName().substring(skip));
        return _xblockexpression;
    }

    public boolean isSupportedGetter(ResolvedMethod it) {
        String _name;
        boolean _not;
        boolean _isEmpty = IterableExtensions.isEmpty(it.getDeclaration().getParameters());
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return false;
        }
        boolean _isStatic = it.getDeclaration().isStatic();
        if (_isStatic) {
            return false;
        }
        String n = it.getDeclaration().getSimpleName();
        String _qualifiedName = it.getDeclaration().getDeclaringType().getQualifiedName();
        boolean _equals = Objects.equal(_qualifiedName, _name = Object.class.getName());
        if (_equals) {
            return false;
        }
        return n.startsWith("get") || n.startsWith("is");
    }
}

