/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.naming;

import com.google.inject.ImplementedBy;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

@ImplementedBy(value=DefaultImpl.class)
public interface IQualifiedNameConverter {
    public String toString(QualifiedName var1);

    public QualifiedName toQualifiedName(String var1);

    @Singleton
    public static class DefaultImpl
    implements IQualifiedNameConverter {
        @Override
        public String toString(QualifiedName qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Qualified name cannot be null");
            }
            return qualifiedName.toString(this.getDelimiter());
        }

        @Override
        public QualifiedName toQualifiedName(String qualifiedNameAsString) {
            if (qualifiedNameAsString == null) {
                throw new IllegalArgumentException("Qualified name cannot be null");
            }
            if (qualifiedNameAsString.equals("")) {
                throw new IllegalArgumentException("Qualified name cannot be empty");
            }
            if (Strings.isEmpty(this.getDelimiter())) {
                return QualifiedName.create(qualifiedNameAsString);
            }
            List<String> segs = this.getDelimiter().length() == 1 ? Strings.split(qualifiedNameAsString, this.getDelimiter().charAt(0)) : Strings.split(qualifiedNameAsString, this.getDelimiter());
            return QualifiedName.create(segs);
        }

        public String getDelimiter() {
            return ".";
        }
    }
}

