/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;

public class ResourceDescriptionsProvider
implements IResourceDescriptionsProvider {
    public static final String NAMED_BUILDER_SCOPE = "org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE";
    public static final String LIVE_SCOPE = "org.eclipse.xtext.scoping.LIVE_SCOPE";
    public static final String PERSISTED_DESCRIPTIONS = "org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE")
    private Provider<IResourceDescriptions> builderScopeResourceDescriptions;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.scoping.LIVE_SCOPE")
    private Provider<IResourceDescriptions> liveScopeResourceDescriptions;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS")
    private Provider<IResourceDescriptions> persistedResourceDescriptions;
    @Inject(optional=true)
    private Provider<IResourceDescriptions> resourceDescriptions;

    public IResourceDescriptions getResourceDescriptions(Resource resource) {
        return this.getResourceDescriptions(resource.getResourceSet());
    }

    @Override
    public IResourceDescriptions getResourceDescriptions(ResourceSet resourceSet) {
        IResourceDescriptions result;
        String flag = this.getFlagFromLoadOptions(resourceSet);
        if (NAMED_BUILDER_SCOPE.equals(flag)) {
            result = this.createBuilderScopeResourceDescriptions();
        } else if (LIVE_SCOPE.equals(flag)) {
            result = this.createLiveScopeResourceDescriptions();
        } else if (PERSISTED_DESCRIPTIONS.equals(flag)) {
            result = this.createPersistedResourceDescriptions();
        } else {
            result = ChunkedResourceDescriptions.findInEmfObject(resourceSet);
            if (result == null) {
                result = this.createResourceDescriptions();
            }
        }
        if (result instanceof IResourceDescriptions.IContextAware) {
            ((IResourceDescriptions.IContextAware)result).setContext(resourceSet);
        }
        return result;
    }

    private String getFlagFromLoadOptions(ResourceSet resourceSet) {
        Map<Object, Object> loadOptions = resourceSet.getLoadOptions();
        String[] mutualExclusiveFlags = new String[]{NAMED_BUILDER_SCOPE, LIVE_SCOPE, PERSISTED_DESCRIPTIONS};
        String result = null;
        for (int i = 0; i < mutualExclusiveFlags.length; ++i) {
            String candidate = mutualExclusiveFlags[i];
            if (!loadOptions.containsKey(candidate)) continue;
            if (result == null) {
                result = candidate;
                continue;
            }
            String msg = "Ambiguous scope for the resource set. Can't combine " + result + " and " + candidate;
            throw new IllegalStateException(msg);
        }
        return result;
    }

    public IResourceDescriptions createLiveScopeResourceDescriptions() {
        return this.liveScopeResourceDescriptions.get();
    }

    public IResourceDescriptions createBuilderScopeResourceDescriptions() {
        return this.builderScopeResourceDescriptions.get();
    }

    public IResourceDescriptions createResourceDescriptions() {
        return this.resourceDescriptions.get();
    }

    public IResourceDescriptions createPersistedResourceDescriptions() {
        if (this.persistedResourceDescriptions == null) {
            throw new IllegalStateException("Language does not provide persisted descriptions.");
        }
        return this.persistedResourceDescriptions.get();
    }

    public void setBuilderScopeResourceDescriptions(Provider<IResourceDescriptions> resourceDescriptions) {
        this.builderScopeResourceDescriptions = resourceDescriptions;
    }

    public void setResourceDescriptions(Provider<IResourceDescriptions> resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
    }

    public void setLiveScopeResourceDescriptions(Provider<IResourceDescriptions> liveScopeResourceDescriptions) {
        this.liveScopeResourceDescriptions = liveScopeResourceDescriptions;
    }

    public void setPersistedResourceDescriptions(Provider<IResourceDescriptions> persistedResourceDescriptions) {
        this.persistedResourceDescriptions = persistedResourceDescriptions;
    }
}

