/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.GrammarElementDeclarationOrder;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.impl.FeatureFinderUtil;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaFactory;
import org.eclipse.xtext.util.formallang.NfaGraphFormatter;
import org.eclipse.xtext.util.formallang.NfaUtil;

@Singleton
public class SemanticSequencerNfaProvider
implements ISemanticSequencerNfaProvider {
    private static Logger LOG = Logger.getLogger(SemanticSequencerNfaProvider.class);
    protected Map<Grammar, SerializationContextMap<Nfa<ISemanticSequencerNfaProvider.ISemState>>> cache = Maps.newHashMap();
    @Inject
    protected ISyntacticSequencerPDAProvider pdaProvider;
    @Inject
    private NfaUtil util;

    protected boolean addAll(BitSet to, BitSet bits) {
        BitSet cpy = new BitSet();
        cpy.or(to);
        cpy.or(bits);
        if (cpy.equals(to)) {
            return false;
        }
        to.or(bits);
        return true;
    }

    protected SemNfa createNfa(Grammar grammar, ISyntacticSequencerPDAProvider.ISynAbsorberState synState, EClass type) {
        ISyntacticSequencerPDAProvider.SynAbsorberNfaAdapter synNfa = new ISyntacticSequencerPDAProvider.SynAbsorberNfaAdapter(synState);
        Map<ISyntacticSequencerPDAProvider.ISynAbsorberState, Integer> distanceMap = this.util.distanceToFinalStateMap(synNfa);
        SemNfa nfa = this.util.create(this.util.sort(synNfa, distanceMap), new SemStateFactory());
        if (type != null) {
            this.initContentValidationNeeded(type, nfa);
        }
        this.initRemainingFeatures(nfa.getStop(), this.util.inverse(nfa), Sets.newHashSet());
        this.initOrderIDs(grammar, nfa);
        return nfa;
    }

    @Override
    public SerializationContextMap<Nfa<ISemanticSequencerNfaProvider.ISemState>> getSemanticSequencerNFAs(Grammar grammar) {
        SerializationContextMap<Nfa<ISemanticSequencerNfaProvider.ISemState>> cached = this.cache.get(grammar);
        if (cached != null) {
            return cached;
        }
        SerializationContextMap.Builder<SemNfa> builder = SerializationContextMap.builder();
        SerializationContextMap<ISyntacticSequencerPDAProvider.ISynAbsorberState> PDAs = this.pdaProvider.getSyntacticSequencerPDAs(grammar);
        for (SerializationContextMap.Entry<ISyntacticSequencerPDAProvider.ISynAbsorberState> e : PDAs.values()) {
            ISyntacticSequencerPDAProvider.ISynAbsorberState synState = e.getValue();
            for (EClass type : e.getTypes()) {
                List<ISerializationContext> contexts = e.getContexts(type);
                try {
                    SemNfa nfa = this.createNfa(grammar, synState, type);
                    builder.put(contexts, nfa);
                }
                catch (Exception x) {
                    LOG.error("Error during static analysis of context '" + contexts + "': " + x.getMessage(), x);
                }
            }
        }
        SerializationContextMap<Nfa<ISemanticSequencerNfaProvider.ISemState>> result = builder.create();
        this.cache.put(grammar, result);
        return result;
    }

    protected void initContentValidationNeeded(EClass clazz, Nfa<ISemanticSequencerNfaProvider.ISemState> nfa) {
        LinkedHashMultimap<EStructuralFeature, AbstractElement> assignments = LinkedHashMultimap.create();
        Set<ISemanticSequencerNfaProvider.ISemState> states = new NfaUtil().collect(nfa);
        for (ISemanticSequencerNfaProvider.ISemState state : states) {
            if (state.getFeature() == null) continue;
            assignments.put(state.getFeature(), state.getAssignedGrammarElement());
        }
        boolean[] validationNeeded = new boolean[clazz.getFeatureCount()];
        for (EStructuralFeature feature : clazz.getEAllStructuralFeatures()) {
            validationNeeded[clazz.getFeatureID((EStructuralFeature)feature)] = this.isContentValidationNeeded(assignments.get(feature));
        }
        for (ISemanticSequencerNfaProvider.ISemState state : states) {
            if (state.getFeature() != null && validationNeeded[state.getFeatureID()]) {
                ((SemState)state).contentValidationNeeded = Lists.newArrayList(assignments.get(state.getFeature()));
                continue;
            }
            ((SemState)state).contentValidationNeeded = Collections.emptyList();
        }
    }

    protected void initOrderIDs(Grammar grammar, Nfa<ISemanticSequencerNfaProvider.ISemState> nfa) {
        GrammarElementDeclarationOrder order = GrammarElementDeclarationOrder.get(grammar);
        for (ISemanticSequencerNfaProvider.ISemState state : new NfaUtil().collect(nfa)) {
            if (state.getAssignedGrammarElement() == null) continue;
            ((SemState)state).orderID = order.getElementID(state.getAssignedGrammarElement());
        }
    }

    protected void initRemainingFeatures(ISemanticSequencerNfaProvider.ISemState state, Nfa<ISemanticSequencerNfaProvider.ISemState> inverseNfa, Set<ISemanticSequencerNfaProvider.ISemState> visited) {
        BitSet features = state.getAllFollowerFeatures();
        if (state.getFeature() != null) {
            BitSet f = new BitSet();
            f.or(features);
            f.set(state.getFeatureID());
            features = f;
        }
        for (ISemanticSequencerNfaProvider.ISemState follower : inverseNfa.getFollowers(state)) {
            if (!this.addAll(follower.getAllFollowerFeatures(), features) && !visited.add(follower)) continue;
            this.initRemainingFeatures(follower, inverseNfa, visited);
        }
    }

    protected boolean isContentValidationNeeded(Collection<AbstractElement> ass) {
        if (ass == null || ass.size() < 2) {
            return false;
        }
        Iterator<AbstractElement> it = ass.iterator();
        AbstractElement first = it.next();
        CrossReference firstRef = GrammarUtil.containingCrossReference(first);
        while (it.hasNext()) {
            CrossReference nextRef;
            AbstractElement next = it.next();
            if (next instanceof Action) {
                return true;
            }
            if (!EcoreUtil.equals(first, next)) {
                return true;
            }
            if (firstRef == null || (nextRef = GrammarUtil.containingCrossReference(next)) == null || nextRef.getType().getClassifier() == firstRef.getType().getClassifier()) continue;
            return true;
        }
        return false;
    }

    protected static class SemStateFactory
    implements NfaFactory<SemNfa, ISemanticSequencerNfaProvider.ISemState, ISyntacticSequencerPDAProvider.ISynAbsorberState> {
        protected SemStateFactory() {
        }

        @Override
        public SemNfa create(ISyntacticSequencerPDAProvider.ISynAbsorberState start, ISyntacticSequencerPDAProvider.ISynAbsorberState stop) {
            SemState starts = new SemState(stop.getEClass(), stop.getGrammarElement());
            SemState stops = new SemState(start.getEClass(), start.getGrammarElement());
            return new SemNfa(starts, stops);
        }

        @Override
        public ISemanticSequencerNfaProvider.ISemState createState(SemNfa nfa, ISyntacticSequencerPDAProvider.ISynAbsorberState token) {
            return new SemState(token.getEClass(), token.getGrammarElement());
        }

        @Override
        public void setFollowers(SemNfa nfa, ISemanticSequencerNfaProvider.ISemState owner, Iterable<ISemanticSequencerNfaProvider.ISemState> followers) {
            ((SemState)owner).followers = Lists.newArrayList(followers);
        }
    }

    protected static class SemState
    implements ISemanticSequencerNfaProvider.ISemState {
        protected BitSet allFollowerFeatures;
        protected AbstractElement assignedGrammarElement;
        protected Boolean booleanAssignment;
        protected List<AbstractElement> contentValidationNeeded;
        protected EStructuralFeature feature;
        protected int featureID = -2;
        protected List<ISemanticSequencerNfaProvider.ISemState> followers;
        protected int orderID = 0;
        protected EClass type;

        public SemState(EClass type, AbstractElement assignedGrammarElement) {
            this.type = type;
            this.assignedGrammarElement = assignedGrammarElement;
        }

        @Override
        public BitSet getAllFollowerFeatures() {
            if (this.allFollowerFeatures == null) {
                this.allFollowerFeatures = new BitSet();
            }
            return this.allFollowerFeatures;
        }

        @Override
        public AbstractElement getAssignedGrammarElement() {
            return this.assignedGrammarElement;
        }

        @Override
        public EStructuralFeature getFeature() {
            if (this.feature == null && this.assignedGrammarElement != null) {
                this.feature = FeatureFinderUtil.getFeature(this.assignedGrammarElement, this.type);
            }
            return this.feature;
        }

        @Override
        public int getFeatureID() {
            if (this.featureID < -1) {
                this.featureID = this.getFeature() != null ? this.type.getFeatureID(this.getFeature()) : -1;
            }
            return this.featureID;
        }

        @Override
        public List<ISemanticSequencerNfaProvider.ISemState> getFollowers() {
            return this.followers == null ? Collections.emptyList() : this.followers;
        }

        @Override
        public int getOrderID() {
            return this.orderID;
        }

        @Override
        public List<AbstractElement> getToBeValidatedAssignedElements() {
            return this.contentValidationNeeded;
        }

        @Override
        public boolean isBooleanAssignment() {
            if (this.booleanAssignment == null) {
                Assignment assignment = GrammarUtil.containingAssignment(this.assignedGrammarElement);
                this.booleanAssignment = assignment != null && GrammarUtil.isBooleanAssignment(assignment);
            }
            return this.booleanAssignment;
        }

        public String toString() {
            if (this.assignedGrammarElement == null) {
                return "(null)";
            }
            return new GrammarElementTitleSwitch().showQualified().showAssignments().apply(this.assignedGrammarElement);
        }
    }

    protected static class SemNfa
    implements Nfa<ISemanticSequencerNfaProvider.ISemState> {
        protected int hashCode = -1;
        protected final ISemanticSequencerNfaProvider.ISemState start;
        protected final ISemanticSequencerNfaProvider.ISemState stop;

        public SemNfa(ISemanticSequencerNfaProvider.ISemState starts, ISemanticSequencerNfaProvider.ISemState stops) {
            this.start = starts;
            this.stop = stops;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return new NfaUtil().equalsIgnoreOrder(this, (SemNfa)obj, ISemanticSequencerNfaProvider.GET_ASSIGNED_GRAMMAR_ELEMENT);
        }

        @Override
        public List<ISemanticSequencerNfaProvider.ISemState> getFollowers(ISemanticSequencerNfaProvider.ISemState node) {
            return node.getFollowers();
        }

        @Override
        public ISemanticSequencerNfaProvider.ISemState getStart() {
            return this.start;
        }

        @Override
        public ISemanticSequencerNfaProvider.ISemState getStop() {
            return this.stop;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = new NfaUtil().hashCodeIgnoreOrder(this, ISemanticSequencerNfaProvider.GET_ASSIGNED_GRAMMAR_ELEMENT);
            }
            return this.hashCode;
        }

        public String toString() {
            return new NfaGraphFormatter().format(this);
        }
    }
}

