/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

public class EmitterNodeUtil {
    public static List<INode> collectEmitterNodes(INode from, INode to) {
        List<INode> actual = EmitterNodeUtil.collectEmitterNodesInternal(from, to);
        return actual;
    }

    private static List<INode> collectEmitterNodesInternal(INode from, INode to) {
        if (from == null) {
            return Collections.emptyList();
        }
        INode current = EmitterNodeUtil.findNext(from, to);
        ArrayList<INode> result = null;
        while (current != null && current != to) {
            EObject grammarElement = current.getGrammarElement();
            if (EmitterNodeUtil.isEmitter(current, grammarElement)) {
                if (EmitterNodeUtil.isAbsorber(grammarElement)) break;
                if (result == null) {
                    result = Lists.newArrayList();
                }
                result.add(current);
                current = EmitterNodeUtil.findNextSibling(current, to);
                continue;
            }
            current = EmitterNodeUtil.findNext(current, to);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    private static INode findNext(INode node, INode to) {
        INode firstChild;
        if (node instanceof ICompositeNode && (firstChild = ((ICompositeNode)node).getFirstChild()) != null) {
            if (firstChild == to) {
                return null;
            }
            return firstChild;
        }
        return EmitterNodeUtil.findNextSibling(node, to);
    }

    private static INode findNextSibling(INode node, INode to) {
        INode successor = node.getNextSibling();
        if (successor != null) {
            if (successor == to) {
                return null;
            }
            return successor;
        }
        ICompositeNode parent = node.getParent();
        if (parent == null || parent == to) {
            return null;
        }
        return EmitterNodeUtil.findNextSibling(parent, to);
    }

    private static boolean isAbsorber(EObject grammarElement) {
        return grammarElement != null && GrammarUtil.isAssigned(grammarElement);
    }

    private static boolean isEmitter(INode node, EObject grammarElement) {
        if (node instanceof ILeafNode) {
            ILeafNode leaf = (ILeafNode)node;
            return !leaf.isHidden();
        }
        if (node instanceof ICompositeNode) {
            return GrammarUtil.isDatatypeRuleCall(grammarElement) || grammarElement instanceof CrossReference;
        }
        return false;
    }
}

