/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;

public class EcoreGenericsUtil {
    public EClass getReferenceType(EReference reference, EClass context) {
        EGenericType genericType = reference.getEGenericType();
        if (genericType == null) {
            return reference.getEReferenceType();
        }
        EGenericType boundGenericType = this.getBoundGenericType(genericType, context);
        if (boundGenericType.getEClassifier() == null) {
            throw new IllegalStateException("Either typeParameter or eRawType must be set in EGenericType " + genericType);
        }
        return (EClass)boundGenericType.getEClassifier();
    }

    public EGenericType getBoundGenericType(EGenericType genericType, EClass context) {
        ETypeParameter typeParameter = genericType.getETypeParameter();
        if (typeParameter != null) {
            TypeBindingAcceptor typeBindingAcceptor = new TypeBindingAcceptor();
            EcoreGenericsUtil.addTypeParameterBindingsRecursively(context, typeBindingAcceptor);
            return typeBindingAcceptor.getBoundGenericType(typeParameter);
        }
        if (genericType.getEClassifier() == null) {
            throw new IllegalStateException("Either typeParameter or eRawType must be set in EGenericType " + genericType);
        }
        return genericType;
    }

    protected static void addTypeParameterBindingsRecursively(EClass context, TypeBindingAcceptor bindingAcceptor) {
        for (EGenericType genericSuperType : context.getEGenericSuperTypes()) {
            EClassifier rawSuperType = genericSuperType.getEClassifier();
            EList<EGenericType> typeArguments = genericSuperType.getETypeArguments();
            EList<ETypeParameter> typeParameters = rawSuperType.getETypeParameters();
            if (typeArguments.size() != typeParameters.size()) {
                throw new IllegalStateException("Number of typeArguments does not match number of typeParameters in EGenericType " + genericSuperType);
            }
            for (int i = 0; i < typeArguments.size(); ++i) {
                bindingAcceptor.accept((ETypeParameter)typeParameters.get(i), (EGenericType)typeArguments.get(i));
            }
            if (!(rawSuperType instanceof EClass)) continue;
            EcoreGenericsUtil.addTypeParameterBindingsRecursively((EClass)rawSuperType, bindingAcceptor);
        }
    }

    protected static class TypeBindingAcceptor {
        private Map<ETypeParameter, EGenericType> bindings;

        protected TypeBindingAcceptor() {
        }

        public void accept(ETypeParameter typeParameter, EGenericType typeArgument) {
            ETypeParameter replacedParameter;
            if (this.bindings == null) {
                this.bindings = new HashMap<ETypeParameter, EGenericType>();
            }
            if ((replacedParameter = typeArgument.getETypeParameter()) != null) {
                EGenericType existingBoundType = this.bindings.get(replacedParameter);
                if (existingBoundType != null) {
                    this.bindings.remove(replacedParameter);
                    this.bindings.put(typeParameter, existingBoundType);
                    return;
                }
            } else if (typeArgument.getEClassifier() == null) {
                throw new IllegalStateException("Either typeParameter or eClassifier must be set in ETypeArgument " + typeArgument);
            }
            this.bindings.put(typeParameter, typeArgument);
        }

        public EGenericType getBoundGenericType(ETypeParameter typeParameter) {
            if (this.bindings == null) {
                return null;
            }
            return this.bindings.get(typeParameter);
        }
    }
}

