/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.inject.ImplementedBy;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.util.IAcceptor;

@ImplementedBy(value=JavaIoFileSystemScanner.class)
public interface IFileSystemScanner {
    public void scan(URI var1, IAcceptor<URI> var2);

    public static class JavaIoFileSystemScanner
    implements IFileSystemScanner {
        @Override
        public void scan(URI root, IAcceptor<URI> acceptor) {
            String _fileString = root.toFileString();
            File file = new File(_fileString);
            this.scanRec(file, acceptor);
        }

        public void scanRec(File file, IAcceptor<URI> acceptor) {
            File[] files;
            Path path = Paths.get(file.getAbsoluteFile().toURI());
            URI uri = URI.createURI(path.toUri().toString());
            acceptor.accept(uri);
            boolean _isDirectory = file.isDirectory();
            if (_isDirectory && (files = file.listFiles()) != null) {
                for (File f : files) {
                    this.scanRec(f, acceptor);
                }
            }
        }
    }
}

