/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.io.File;
import org.eclipse.emf.common.util.URI;

public class UriUtil {
    public static boolean isPrefixOf(URI prefix, URI uri) {
        if (prefix.scheme() == null || !prefix.scheme().equals(uri.scheme())) {
            return false;
        }
        String[] prefixSeg = prefix.segments();
        String[] uriSeg = uri.segments();
        if (prefixSeg.length == 0 || uriSeg.length == 0) {
            return false;
        }
        if (!prefix.hasTrailingPathSeparator()) {
            return false;
        }
        if (uriSeg.length < prefixSeg.length - 1) {
            return false;
        }
        for (int i = 0; i < prefixSeg.length - 1; ++i) {
            if (uriSeg[i].equals(prefixSeg[i])) continue;
            return false;
        }
        return true;
    }

    public static URI createFolderURI(File file) {
        URI uri = URI.createFileURI(file.getAbsolutePath());
        return UriUtil.toFolderURI(uri);
    }

    public static URI toFolderURI(URI uri) {
        if (uri.hasTrailingPathSeparator()) {
            return uri;
        }
        return uri.appendSegment("");
    }
}

