/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler.output;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegionToString;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;

public class AppendableBasedTraceRegion
extends AbstractTraceRegion {
    private final String generatedText;
    private final String sourceText;
    private final List<ILocationData> locations;
    private int offset;
    private int length;
    private int lineNumber;
    private int endLineNumber;
    private boolean useForDebugging;

    @Override
    public boolean isUseForDebugging() {
        return this.useForDebugging;
    }

    public AppendableBasedTraceRegion(AbstractTraceRegion parent, TreeAppendable delegate, int offset, int lineNumber) {
        super(parent);
        SourceRelativeURI parentPath;
        this.offset = offset;
        this.lineNumber = lineNumber;
        this.useForDebugging = delegate.isUseForDebugging();
        boolean useLocationsFromDelegate = true;
        if (parent != null && (parentPath = parent.getAssociatedSrcRelativePath()) != null) {
            useLocationsFromDelegate = !this.allLocationsMatch(delegate, parentPath);
        }
        this.locations = this.copyLocationData(delegate, useLocationsFromDelegate);
        int length = 0;
        int line = lineNumber;
        for (Object object : delegate.getChildren()) {
            if (object instanceof TreeAppendable) {
                TreeAppendable castedChild = (TreeAppendable)object;
                if (!this.hasVisibleChildren(castedChild)) continue;
                AppendableBasedTraceRegion childRegion = new AppendableBasedTraceRegion(this, castedChild, offset + length, line);
                length += childRegion.getMyLength();
                line = childRegion.getMyEndLineNumber();
                continue;
            }
            String s = object.toString();
            length += s.length();
            line += Strings.countLineBreaks(s);
        }
        this.length = length;
        this.endLineNumber = line;
        if (parent == null) {
            this.generatedText = delegate.getContent();
            this.compressTrace(this.generatedText);
            IParseResult result = ((XtextResource)delegate.getState().getResource()).getParseResult();
            this.sourceText = result != null ? result.getRootNode().getText() : null;
        } else {
            this.generatedText = null;
            this.sourceText = null;
        }
    }

    private List<ILocationData> copyLocationData(TreeAppendable delegate, boolean useOriginalLocations) {
        if (useOriginalLocations) {
            return Lists.newArrayList(delegate.getLocationData());
        }
        ArrayList<ILocationData> result = Lists.newArrayList();
        for (ILocationData locationData : delegate.getLocationData()) {
            result.add(new LocationData(locationData, null));
        }
        return result;
    }

    private boolean allLocationsMatch(TreeAppendable appendable, SourceRelativeURI path) {
        for (ILocationData locationData : appendable.getLocationData()) {
            if (path.equals(locationData.getSrcRelativePath())) continue;
            return false;
        }
        return true;
    }

    protected void compressTrace(String completeContent) {
        this.leftCompressTrace(completeContent);
        this.rightCompressTrace(completeContent);
    }

    protected void leftCompressTrace(String completeContent) {
        List<AbstractTraceRegion> allNested = this.getWritableNestedRegions();
        int i = 0;
        while (i < allNested.size()) {
            int diff;
            AppendableBasedTraceRegion nested = (AppendableBasedTraceRegion)allNested.get(i);
            int offset = nested.getMyOffset();
            for (diff = 0; completeContent.charAt(offset + diff) <= ' ' && diff < nested.length; ++diff) {
            }
            if (diff == nested.length) {
                allNested.remove(i);
                continue;
            }
            nested.lineNumber += Strings.countLineBreaks(completeContent, offset, offset + diff);
            nested.offset += diff;
            nested.length -= diff;
            nested.leftCompressTrace(completeContent);
            ++i;
        }
    }

    protected void rightCompressTrace(String completeContent) {
        List<AbstractTraceRegion> allNested = this.getWritableNestedRegions();
        for (int i = 0; i < allNested.size(); ++i) {
            int diff;
            AppendableBasedTraceRegion nested = (AppendableBasedTraceRegion)allNested.get(i);
            int endOffset = nested.getMyOffset() + nested.getMyLength() - 1;
            for (diff = 0; completeContent.charAt(endOffset - diff) <= ' ' && diff < nested.length; ++diff) {
            }
            if (diff == 0) continue;
            nested.endLineNumber -= Strings.countLineBreaks(completeContent, endOffset - diff + 1, endOffset + 1);
            nested.length -= diff;
            nested.rightCompressTrace(completeContent);
        }
    }

    protected boolean hasVisibleChildren(TreeAppendable castedChild) {
        for (Object object : castedChild.getChildren()) {
            if (object instanceof String) {
                return true;
            }
            if (!this.hasVisibleChildren((TreeAppendable)object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMyLength() {
        return this.length;
    }

    @Override
    public int getMyOffset() {
        return this.offset;
    }

    @Override
    public int getMyLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getMyEndLineNumber() {
        return this.endLineNumber;
    }

    @Override
    public List<ILocationData> getAssociatedLocations() {
        return this.locations;
    }

    @Override
    public AppendableBasedTraceRegion getRoot() {
        return (AppendableBasedTraceRegion)super.getRoot();
    }

    @Override
    public String toString() {
        return new AbstractTraceRegionToString(){

            @Override
            protected String getRemoteText(SourceRelativeURI uri) {
                return AppendableBasedTraceRegion.this.getRoot().sourceText;
            }

            @Override
            protected String getLocalText() {
                return AppendableBasedTraceRegion.this.getRoot().generatedText;
            }

            @Override
            protected AbstractTraceRegion getTrace() {
                return AppendableBasedTraceRegion.this;
            }
        }.toString();
    }
}

