/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeKind;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReferenceResolver;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;
import org.eclipse.xtext.xtype.XComputedTypeReference;

public class UnboundTypeReference
extends LightweightTypeReference {
    private LightweightTypeReference resolvedTo;
    private final JvmTypeParameter typeParameter;
    private final Object handle;
    private final XExpression expression;
    boolean copying = false;

    public static UnboundTypeReference create(ITypeExpectation expectation, XExpression expression, JvmTypeParameter typeParameter) {
        return expectation.createUnboundTypeReference(expression, typeParameter);
    }

    @Override
    public int getKind() {
        return 6;
    }

    protected UnboundTypeReference(ITypeReferenceOwner owner, XExpression expression, JvmTypeParameter typeParameter) {
        this(owner, expression, typeParameter, new Object());
    }

    protected UnboundTypeReference(ITypeReferenceOwner owner, XExpression expression, JvmTypeParameter typeParameter, Object handle) {
        super(owner);
        this.typeParameter = typeParameter;
        this.handle = handle;
        this.expression = expression;
    }

    public XExpression getExpression() {
        return this.expression;
    }

    protected UnboundTypeReference createCopy(ITypeReferenceOwner owner) {
        UnboundTypeReference result = new UnboundTypeReference(owner, this.expression, this.getTypeParameter(), this.getHandle());
        return result;
    }

    public void tryResolve() {
        this.tryResolve(true);
    }

    public void tryResolve(boolean constraintsAreSignificant) {
        if (this.internalIsResolved()) {
            return;
        }
        List<LightweightBoundTypeArgument> hints = this.getAllHints();
        if (!hints.isEmpty() && this.hasSignificantHints(hints, constraintsAreSignificant)) {
            this.resolveWithHints(hints);
        }
    }

    public boolean canResolveTo(LightweightTypeReference reference) {
        if (this.internalIsResolved()) {
            return reference.isAssignableFrom(this.resolvedTo, new TypeConformanceComputationArgument(false, true, true, true, false, false));
        }
        List<LightweightBoundTypeArgument> hints = this.getAllHints();
        if (!hints.isEmpty() && this.hasSignificantHints(hints)) {
            return this.canResolveTo(reference, hints);
        }
        return false;
    }

    public boolean hasSignificantHints() {
        if (this.internalIsResolved()) {
            return true;
        }
        List<LightweightBoundTypeArgument> hints = this.getAllHints();
        return !hints.isEmpty() && this.hasSignificantHints(hints);
    }

    public boolean hasSignificantHints(List<LightweightBoundTypeArgument> hints) {
        return this.hasSignificantHints(hints, true);
    }

    protected boolean hasSignificantHints(List<LightweightBoundTypeArgument> hints, boolean constraintsAreSignificant) {
        for (LightweightBoundTypeArgument hint : hints) {
            if (hint.getOrigin() instanceof VarianceInfo || !constraintsAreSignificant && hint.getSource() == BoundTypeArgumentSource.CONSTRAINT) continue;
            return true;
        }
        return false;
    }

    @Override
    public JvmTypeReference toTypeReference() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.toTypeReference();
        }
        XComputedTypeReference result = this.getServices().getXtypeFactory().createXComputedTypeReference();
        result.setTypeProvider(new UnboundTypeReferenceResolver(this));
        return result;
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper visibilityHelper) {
        return this.resolve().toJavaCompliantTypeReference(visibilityHelper);
    }

    @Override
    public boolean isRawType() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.isRawType();
        }
        return false;
    }

    @Override
    public boolean isAnonymous() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.isAnonymous();
        }
        return false;
    }

    public JvmTypeParameter getTypeParameter() {
        return this.typeParameter;
    }

    public Object getHandle() {
        return this.handle;
    }

    public LightweightTypeReference getResolvedTo() {
        return this.internalGetResolvedTo();
    }

    @Override
    public LightweightTypeReference getUpperBoundSubstitute() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.getUpperBoundSubstitute();
        }
        return super.getUpperBoundSubstitute();
    }

    @Override
    public LightweightTypeReference getLowerBoundSubstitute() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.getLowerBoundSubstitute();
        }
        return super.getLowerBoundSubstitute();
    }

    @Override
    public LightweightTypeReference getInvariantBoundSubstitute() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.getInvariantBoundSubstitute();
        }
        return super.getInvariantBoundSubstitute();
    }

    public LightweightTypeReference resolve() {
        LightweightTypeReference result;
        if (this.internalIsResolved()) {
            return this.resolvedTo;
        }
        List<LightweightBoundTypeArgument> allHints = this.getAllHints();
        if (!allHints.isEmpty() && this.resolveWithHints(allHints) && (result = this.internalGetResolvedTo()) != null) {
            return result;
        }
        this.resolveAgainstConstraints();
        return this.resolvedTo;
    }

    protected void resolveAgainstConstraints() {
        TypeParameterByConstraintSubstitutor unboundSubstitutor = new TypeParameterByConstraintSubstitutor(Collections.emptyMap(), this.getOwner(), true);
        LightweightTypeReference substitute = unboundSubstitutor.substitute(this.getOwner().newParameterizedTypeReference(this.typeParameter));
        this.getOwner().acceptHint(this.getHandle(), new LightweightBoundTypeArgument(substitute, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT));
        this.resolvedTo = substitute;
    }

    protected boolean canResolveTo(LightweightTypeReference reference, List<LightweightBoundTypeArgument> allHints) {
        ArrayList<LightweightBoundTypeArgument> inferredHints = Lists.newArrayListWithCapacity(allHints.size());
        ArrayList<LightweightBoundTypeArgument> effectiveHints = Lists.newArrayListWithCapacity(allHints.size());
        EnumSet<VarianceInfo> varianceHints = EnumSet.noneOf(VarianceInfo.class);
        for (LightweightBoundTypeArgument hint : allHints) {
            if (hint.getOrigin() instanceof VarianceInfo) {
                varianceHints.add((VarianceInfo)((Object)hint.getOrigin()));
                continue;
            }
            effectiveHints.add(hint);
            if (hint.getSource() != BoundTypeArgumentSource.INFERRED) continue;
            inferredHints.add(hint);
        }
        if (effectiveHints.isEmpty()) {
            return false;
        }
        boolean result = this.getServices().getBoundTypeArgumentMerger().isPossibleMergeResult(!inferredHints.isEmpty() ? inferredHints : effectiveHints, reference);
        return result;
    }

    protected boolean resolveWithHints(List<LightweightBoundTypeArgument> allHints) {
        LightweightBoundTypeArgument hint;
        ArrayList<LightweightBoundTypeArgument> inferredHints = Lists.newArrayListWithCapacity(allHints.size());
        ArrayList<LightweightBoundTypeArgument> effectiveHints = Lists.newArrayListWithCapacity(allHints.size());
        ArrayList<LightweightBoundTypeArgument> inferredConstraintHints = Lists.newArrayListWithCapacity(allHints.size());
        EnumSet<VarianceInfo> varianceHints = EnumSet.noneOf(VarianceInfo.class);
        boolean hasContraintHints = this.populateListsFromHints(allHints, inferredHints, effectiveHints, inferredConstraintHints, varianceHints);
        if (inferredHints.size() == 1 && !varianceHints.isEmpty() && (hint = (LightweightBoundTypeArgument)inferredHints.get(0)).getDeclaredVariance() == VarianceInfo.IN && hint.getActualVariance() == VarianceInfo.INVARIANT && !hint.getTypeReference().isWildcard()) {
            inferredHints.clear();
        }
        if (effectiveHints.isEmpty()) {
            return false;
        }
        LightweightMergedBoundTypeArgument typeArgument = this.getServices().getBoundTypeArgumentMerger().merge(!inferredHints.isEmpty() ? inferredHints : effectiveHints, this.getOwner());
        if (typeArgument != null) {
            this.resolvedTo = typeArgument.getTypeReference();
            if (this.resolvedTo != null) {
                LightweightBoundTypeArgument constraintTypeRef;
                boolean outResolvedToInvariant;
                boolean bl = outResolvedToInvariant = varianceHints.contains((Object)VarianceInfo.OUT) && varianceHints.size() == 1 && typeArgument.getVariance() == VarianceInfo.INVARIANT;
                if (outResolvedToInvariant && this.resolvedTo.getKind() == 8) {
                    this.resolvedTo = this.resolvedTo.getUpperBoundSubstitute();
                } else if (outResolvedToInvariant && this.resolvedTo.getKind() != 8 && inferredConstraintHints.size() == 1) {
                    LightweightTypeReference constraintTypeRef2 = ((LightweightBoundTypeArgument)inferredConstraintHints.get(0)).getTypeReference();
                    if (constraintTypeRef2.isAssignableFrom(this.resolvedTo)) {
                        this.resolvedTo = constraintTypeRef2;
                    }
                } else if (varianceHints.contains((Object)VarianceInfo.IN) && varianceHints.size() == 1 && typeArgument.getVariance() == VarianceInfo.INVARIANT && this.resolvedTo instanceof WildcardTypeReference) {
                    this.resolvedTo = this.resolvedTo.getInvariantBoundSubstitute();
                } else if (varianceHints.isEmpty() && typeArgument.getVariance() == VarianceInfo.OUT && allHints.size() == 1) {
                    LightweightBoundTypeArgument singleHint = allHints.get(0);
                    if (singleHint.getDeclaredVariance() == VarianceInfo.INVARIANT && singleHint.getSource() == BoundTypeArgumentSource.INFERRED_LATER) {
                        WildcardTypeReference wildcard = this.resolvedTo.getOwner().newWildcardTypeReference();
                        wildcard.addUpperBound(this.resolvedTo);
                        this.resolvedTo = wildcard;
                    }
                } else if (varianceHints.isEmpty() && inferredConstraintHints.size() == 1 && typeArgument.getVariance() == VarianceInfo.INVARIANT && (constraintTypeRef = (LightweightBoundTypeArgument)inferredConstraintHints.get(0)).getTypeReference().getKind() != 8 && constraintTypeRef.getDeclaredVariance() == VarianceInfo.OUT && constraintTypeRef.getActualVariance() == VarianceInfo.INVARIANT) {
                    if (this.resolvedTo.getKind() == 8 && ((WildcardTypeReference)this.resolvedTo).getLowerBound() != null) {
                        if (this.resolvedTo.getInvariantBoundSubstitute().isAssignableFrom(constraintTypeRef.getTypeReference())) {
                            WildcardTypeReference wildcard = this.resolvedTo.getOwner().newWildcardTypeReference();
                            wildcard.addUpperBound(this.resolvedTo.getInvariantBoundSubstitute());
                            this.resolvedTo = wildcard;
                        }
                    } else if (this.resolvedTo.isAssignableFrom(constraintTypeRef.getTypeReference())) {
                        this.resolvedTo = constraintTypeRef.getTypeReference();
                    }
                }
            }
            this.getOwner().acceptHint(this.getHandle(), new LightweightBoundTypeArgument(this.resolvedTo, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, typeArgument.getVariance()));
            if (hasContraintHints) {
                this.propageResolvedTypeToConstraints(allHints);
            }
            return true;
        }
        return false;
    }

    private boolean populateListsFromHints(List<LightweightBoundTypeArgument> allHints, List<LightweightBoundTypeArgument> inferredHints, List<LightweightBoundTypeArgument> effectiveHints, List<LightweightBoundTypeArgument> inferredConstraintHints, EnumSet<VarianceInfo> varianceHints) {
        boolean hasContraintHints = false;
        boolean hasInferred = false;
        ArrayList<LightweightBoundTypeArgument> expectationHints = null;
        for (LightweightBoundTypeArgument hint : allHints) {
            if (hint.getOrigin() instanceof VarianceInfo) {
                varianceHints.add((VarianceInfo)((Object)hint.getOrigin()));
                continue;
            }
            if (hint.getSource() == BoundTypeArgumentSource.CONSTRAINT) {
                hasContraintHints = true;
            }
            effectiveHints.add(hint);
            if (hint.getSource() == BoundTypeArgumentSource.INFERRED) {
                if (inferredHints.isEmpty()) {
                    hasInferred = true;
                }
                inferredHints.add(hint);
            }
            if (hint.getSource() == BoundTypeArgumentSource.INFERRED_EXPECTATION) {
                if (expectationHints == null) {
                    expectationHints = Lists.newArrayListWithCapacity(2);
                }
                expectationHints.add(hint);
            }
            if (hasInferred || hint.getSource() != BoundTypeArgumentSource.INFERRED_CONSTRAINT) continue;
            inferredConstraintHints.add(hint);
        }
        if (expectationHints != null) {
            inferredHints.addAll(expectationHints);
        }
        return hasContraintHints;
    }

    protected void propageResolvedTypeToConstraints(List<LightweightBoundTypeArgument> hints) {
        if (!this.resolvedTo.isRawType()) {
            for (LightweightBoundTypeArgument hint : hints) {
                LightweightTypeReference hintReference = hint.getTypeReference();
                if (hintReference == null || hintReference.isRawType() || hint.getSource() != BoundTypeArgumentSource.CONSTRAINT) continue;
                DeferredTypeParameterHintCollector collector = new DeferredTypeParameterHintCollector(this.getOwner()){

                    @Override
                    protected BoundTypeArgumentSource getTypeArgumentSource() {
                        return BoundTypeArgumentSource.INFERRED_CONSTRAINT;
                    }

                    @Override
                    protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                        if (typeParameter.getHandle() != UnboundTypeReference.this.getHandle()) {
                            super.addHint(typeParameter, reference);
                        }
                    }
                };
                collector.processPairedReferences(hintReference, this.resolvedTo);
            }
        }
    }

    @Override
    public LightweightTypeReference copyInto(ITypeReferenceOwner owner) {
        return this.doCopyInto(owner);
    }

    @Override
    public boolean isResolved() {
        if (this.internalGetResolvedTo() != null) {
            return this.resolvedTo.isResolved();
        }
        return false;
    }

    public boolean internalIsResolved() {
        return this.internalGetResolvedTo() != null;
    }

    public LightweightTypeReference internalGetResolvedTo() {
        if (this.resolvedTo != null) {
            if (!this.getOwner().isResolved(this.handle)) {
                throw new IllegalStateException("owner should know that this one is resolved");
            }
            return this.resolvedTo;
        }
        if (this.getOwner().isResolved(this.getHandle())) {
            List<LightweightBoundTypeArgument> hints = this.getOwner().getAllHints(this.getHandle());
            if (hints.isEmpty()) {
                throw new IllegalStateException("cannot have empty hints if marked as resolved");
            }
            if (hints.size() != 1) {
                return null;
            }
            LightweightBoundTypeArgument singleHint = hints.get(0);
            if (singleHint.getSource() == BoundTypeArgumentSource.RESOLVED) {
                this.resolvedTo = singleHint.getTypeReference();
                if (!this.getOwner().isResolved(this.handle)) {
                    throw new IllegalStateException("owner should know that this one is resolved");
                }
                return this.resolvedTo;
            }
        }
        return null;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getTypeArguments();
        }
        return super.getTypeArguments();
    }

    @Override
    public boolean hasTypeArguments() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.hasTypeArguments();
        }
        return super.hasTypeArguments();
    }

    @Override
    public boolean isArray() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isArray();
        }
        return false;
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isVisible(visibilityHelper);
        }
        return true;
    }

    @Override
    public boolean isAny() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isAny();
        }
        return false;
    }

    @Override
    public boolean isUnknown() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isUnknown();
        }
        return false;
    }

    @Override
    public FunctionTypeKind getFunctionTypeKind() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getFunctionTypeKind();
        }
        return super.getFunctionTypeKind();
    }

    @Override
    public ArrayTypeReference tryConvertToArray() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.tryConvertToArray();
        }
        return super.tryConvertToArray();
    }

    @Override
    public FunctionTypeReference tryConvertToFunctionTypeReference(boolean rawType) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.tryConvertToFunctionTypeReference(rawType);
        }
        return super.tryConvertToFunctionTypeReference(rawType);
    }

    @Override
    public LightweightTypeReference tryConvertToListType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.tryConvertToListType();
        }
        return null;
    }

    @Override
    public LightweightTypeReference getComponentType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getComponentType();
        }
        return super.getComponentType();
    }

    @Override
    public boolean isWrapper() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isWrapper();
        }
        return false;
    }

    @Override
    public boolean isPrimitive() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isPrimitive();
        }
        return false;
    }

    @Override
    public Primitives.Primitive getPrimitiveKind() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getPrimitiveKind();
        }
        return null;
    }

    @Override
    public Primitives.Primitive getPrimitiveKindIfWrapperType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getPrimitiveKindIfWrapperType();
        }
        return null;
    }

    @Override
    public boolean isPrimitiveVoid() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isPrimitiveVoid();
        }
        return false;
    }

    @Override
    public boolean isInterfaceType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isInterfaceType();
        }
        return false;
    }

    @Override
    public LightweightTypeReference getPrimitiveIfWrapperType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getPrimitiveIfWrapperType();
        }
        return this;
    }

    @Override
    public JvmType getType() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getType();
        }
        return this.getTypeParameter();
    }

    @Override
    public boolean isType(Class<?> clazz) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.isType(clazz);
        }
        return false;
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getSuperTypes(substitutor);
        }
        return Collections.emptyList();
    }

    @Override
    public LightweightTypeReference getSuperType(JvmType rawType) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getSuperType(rawType);
        }
        return null;
    }

    @Override
    public LightweightTypeReference getSuperType(Class<?> rawType) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getSuperType(rawType);
        }
        return null;
    }

    @Override
    public LightweightTypeReference getWrapperTypeIfPrimitive() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getWrapperTypeIfPrimitive();
        }
        return super.getWrapperTypeIfPrimitive();
    }

    @Override
    protected LightweightTypeReference doCopyInto(ITypeReferenceOwner owner) {
        if (this.internalIsResolved()) {
            if (this.copying) {
                throw new IllegalStateException();
            }
            this.copying = true;
            try {
                LightweightTypeReference lightweightTypeReference = this.resolvedTo.copyInto(owner);
                return lightweightTypeReference;
            }
            finally {
                this.copying = false;
            }
        }
        UnboundTypeReference result = this.createCopy(owner);
        return result;
    }

    @Override
    public String getSimpleName() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getSimpleName();
        }
        return "Unbound[" + this.typeParameter.getSimpleName() + "]";
    }

    @Override
    public String getIdentifier() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getIdentifier();
        }
        return "Unbound[" + this.typeParameter.getIdentifier() + "]";
    }

    @Override
    public String getUniqueIdentifier() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getUniqueIdentifier();
        }
        return "Unbound[" + this.getUniqueIdentifier(this.typeParameter) + ":" + this.handle + "]";
    }

    @Override
    public String getJavaIdentifier() {
        if (this.internalIsResolved()) {
            return this.resolvedTo.getJavaIdentifier();
        }
        return this.getIdentifier();
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        if (this.internalIsResolved()) {
            this.resolvedTo.accept(visitor);
        } else {
            visitor.doVisitUnboundTypeReference(this);
        }
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        if (this.internalIsResolved()) {
            this.resolvedTo.accept(visitor, param);
        } else {
            visitor.doVisitUnboundTypeReference(this, param);
        }
    }

    @Override
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.accept(visitor);
        }
        return visitor.doVisitUnboundTypeReference(this);
    }

    @Override
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        if (this.internalIsResolved()) {
            return this.resolvedTo.accept(visitor, param);
        }
        return visitor.doVisitUnboundTypeReference(this, param);
    }

    public void acceptHint(VarianceInfo variance) {
        this.acceptHint(new LightweightBoundTypeArgument(null, null, (Object)variance, null, null));
    }

    public void acceptHint(LightweightTypeReference hint, BoundTypeArgumentSource source, Object origin, VarianceInfo expectedVariance, VarianceInfo actualVariance) {
        if (!hint.isValidHint()) {
            throw new IllegalArgumentException("Hint may not be primitive void, <any> or <unknown>");
        }
        if (hint instanceof UnboundTypeReference && ((UnboundTypeReference)hint).getHandle() == this.getHandle()) {
            return;
        }
        this.acceptHint(new LightweightBoundTypeArgument(hint.getWrapperTypeIfPrimitive(), source, origin, expectedVariance, actualVariance));
    }

    public void acceptHint(LightweightBoundTypeArgument hint) {
        if (this.internalIsResolved()) {
            throw new IllegalStateException("Cannot add hints to a resolved reference");
        }
        if (hint.getSource() == BoundTypeArgumentSource.EXPLICIT) {
            LightweightTypeReference reference = hint.getTypeReference();
            if (!(reference instanceof ParameterizedTypeReference || reference.isArray() || reference.isUnknown())) {
                throw new IllegalArgumentException("cannot set " + hint + " as explicit hint");
            }
            if (!this.getAllHints().isEmpty()) {
                throw new IllegalStateException("Cannot set explicit hint if other hints are present: " + this.getAllHints());
            }
            this.resolvedTo = reference;
            this.getOwner().acceptHint(this.getHandle(), new LightweightBoundTypeArgument(this.resolvedTo, BoundTypeArgumentSource.RESOLVED, this, hint.getDeclaredVariance(), hint.getActualVariance()));
            return;
        }
        this.getOwner().acceptHint(this.getHandle(), hint);
    }

    public List<LightweightBoundTypeArgument> getAllHints() {
        if (this.internalGetResolvedTo() != null) {
            throw new IllegalStateException("Cannot query hints for a resolved reference");
        }
        return this.getOwner().getAllHints(this.getHandle());
    }

    public boolean equalHandles(UnboundTypeReference reference) {
        return this.getHandle().equals(reference.getHandle());
    }

    @Override
    public boolean isWildcard() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.isWildcard();
        }
        return false;
    }

    @Override
    public boolean isMultiType() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.isMultiType();
        }
        return super.isMultiType();
    }

    @Override
    public boolean isSynonym() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.isSynonym();
        }
        return super.isSynonym();
    }

    @Override
    public LightweightTypeReference toJavaType() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.toJavaType();
        }
        return super.toJavaType();
    }

    @Override
    public List<LightweightTypeReference> getMultiTypeComponents() {
        if (this.resolvedTo != null) {
            return this.resolvedTo.getMultiTypeComponents();
        }
        return super.getMultiTypeComponents();
    }
}

