/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

@Singleton
public class ReferencedInvalidTypeFinder
extends TypeReferenceVisitorWithResult<LightweightTypeReference> {
    @Inject
    private CommonTypeComputationServices services;

    public LightweightTypeReference findReferencedInvalidType(JvmIdentifiableElement element) {
        return this.internalFindReferencedInvalidType(element);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmIdentifiableElement field) {
        return null;
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(Void field) {
        return null;
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmField field) {
        LightweightTypeReference type = this.toLightweightTypeReference(field.getType());
        boolean _isPrimitiveVoid = type.isPrimitiveVoid();
        if (_isPrimitiveVoid) {
            return type;
        }
        return this.findUnknownType(type);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmOperation operation) {
        LightweightTypeReference unknownType = this.findUnknownType(operation.getReturnType());
        if (unknownType != null) {
            return unknownType;
        }
        return this._internalFindReferencedInvalidType((JvmExecutable)operation);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmExecutable executable) {
        LightweightTypeReference unknownType;
        Functions.Function1<JvmTypeParameter, EList> _function = it -> it.getConstraints();
        Functions.Function1<JvmTypeConstraint, JvmTypeReference> _function_1 = it -> it.getTypeReference();
        Iterable<JvmTypeReference> _map = IterableExtensions.map(Iterables.concat(ListExtensions.map(executable.getTypeParameters(), _function)), _function_1);
        for (JvmTypeReference typeReference : _map) {
            LightweightTypeReference unknownType2 = this.findUnknownType(typeReference);
            if (unknownType2 == null) continue;
            return unknownType2;
        }
        Functions.Function1<JvmFormalParameter, LightweightTypeReference> _function_2 = it -> this.toLightweightTypeReference(it.getParameterType());
        List<LightweightTypeReference> _map_1 = ListExtensions.map(executable.getParameters(), _function_2);
        for (LightweightTypeReference parameterType : _map_1) {
            boolean _isPrimitiveVoid = parameterType.isPrimitiveVoid();
            if (_isPrimitiveVoid) {
                return parameterType;
            }
            unknownType = this.findUnknownType(parameterType);
            if (unknownType == null) continue;
            return unknownType;
        }
        EList<JvmTypeReference> _exceptions = executable.getExceptions();
        for (JvmTypeReference exception : _exceptions) {
            unknownType = this.findUnknownType(exception);
            if (unknownType == null) continue;
            return unknownType;
        }
        return null;
    }

    protected LightweightTypeReference findUnknownType(JvmTypeReference reference) {
        return this.findUnknownType(this.toLightweightTypeReference(reference));
    }

    protected LightweightTypeReference findUnknownType(LightweightTypeReference type) {
        return type.accept(this);
    }

    @Override
    protected LightweightTypeReference doVisitTypeReference(LightweightTypeReference reference) {
        boolean _isUnknown = reference.isUnknown();
        if (_isUnknown) {
            return reference;
        }
        return null;
    }

    @Override
    protected LightweightTypeReference doVisitArrayTypeReference(ArrayTypeReference reference) {
        return reference.getComponentType().accept(this);
    }

    @Override
    protected LightweightTypeReference doVisitWildcardTypeReference(WildcardTypeReference reference) {
        LightweightTypeReference unknownType = this.visit(reference.getUpperBounds());
        if (unknownType != null) {
            return unknownType;
        }
        LightweightTypeReference lowerBound = reference.getLowerBound();
        if (lowerBound != null) {
            return lowerBound.accept(this);
        }
        return null;
    }

    @Override
    protected LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
        return this.visit(reference.getTypeArguments());
    }

    @Override
    protected LightweightTypeReference doVisitCompoundTypeReference(CompoundTypeReference reference) {
        return this.visit(reference.getMultiTypeComponents());
    }

    protected LightweightTypeReference visit(List<LightweightTypeReference> references) {
        Functions.Function1<LightweightTypeReference, LightweightTypeReference> _function = it -> it.accept(this);
        return IterableExtensions.head(IterableExtensions.filterNull(ListExtensions.map(references, _function)));
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef) {
        return new StandardTypeReferenceOwner(this.services, typeRef).toLightweightTypeReference(typeRef);
    }

    protected LightweightTypeReference internalFindReferencedInvalidType(JvmIdentifiableElement operation) {
        if (operation instanceof JvmOperation) {
            return this._internalFindReferencedInvalidType((JvmOperation)operation);
        }
        if (operation instanceof JvmExecutable) {
            return this._internalFindReferencedInvalidType((JvmExecutable)operation);
        }
        if (operation instanceof JvmField) {
            return this._internalFindReferencedInvalidType((JvmField)operation);
        }
        if (operation != null) {
            return this._internalFindReferencedInvalidType(operation);
        }
        if (operation == null) {
            return this._internalFindReferencedInvalidType((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(operation).toString());
    }
}

