/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl;

import com.db.plexus.interop.dsl.Application;
import com.db.plexus.interop.dsl.ConsumedMethod;
import com.db.plexus.interop.dsl.ConsumedService;
import com.db.plexus.interop.dsl.InteropOption;
import com.db.plexus.interop.dsl.ProvidedMethod;
import com.db.plexus.interop.dsl.ProvidedService;
import com.db.plexus.interop.dsl.protobuf.Message;
import com.db.plexus.interop.dsl.protobuf.ProtoLangImportResolver;
import com.db.plexus.interop.dsl.protobuf.ProtobufPackage;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class InteropLangUtils {
    public static final String DESCRIPTOR_RESOURCE_PATH = "interop/descriptor.proto";
    public static final QualifiedName DESCRIPTOR_PACKAGE_NAME = QualifiedName.create("", "interop");
    @Inject
    protected IResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    protected ProtoLangImportResolver importResolver;
    @Inject
    protected IQualifiedNameProvider qualifiedNameProvider;

    public Message getDescriptorsContainer(InteropOption option) {
        QualifiedName name = InteropLangUtils.getDescriptorContainerName(option);
        ResourceSet resourceSet = option.eResource().getResourceSet();
        IResourceDescription description = this.getDescriptorResourceDescription(resourceSet);
        if (description == null) {
            Resource descriptorResource = this.importResolver.resolveResource(resourceSet, DESCRIPTOR_RESOURCE_PATH);
            Functions.Function1<Message, Boolean> _function = m -> name.equals(this.qualifiedNameProvider.getFullyQualifiedName((EObject)m));
            Message message = IteratorExtensions.findFirst(Iterators.filter(descriptorResource.getAllContents(), Message.class), _function);
            return message;
        }
        Iterable<IEObjectDescription> objects = description.getExportedObjects(ProtobufPackage.Literals.MESSAGE, name, false);
        Functions.Function1<IEObjectDescription, Boolean> _function_1 = x -> true;
        IEObjectDescription message_1 = IterableExtensions.findFirst(objects, _function_1);
        Message _xifexpression = null;
        if (message_1 != null) {
            EObject _eObjectOrProxy = message_1.getEObjectOrProxy();
            _xifexpression = (Message)_eObjectOrProxy;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public IResourceDescription getDescriptorResourceDescription(ResourceSet resourceSet) {
        return this.importResolver.resolveResourceDescription(resourceSet, DESCRIPTOR_RESOURCE_PATH);
    }

    private static QualifiedName getDescriptorContainerName(InteropOption option) {
        return DESCRIPTOR_PACKAGE_NAME.append(InteropLangUtils.getOptionDescriptorMessageName(option.eContainer()));
    }

    private static String getOptionDescriptorMessageName(EObject container) {
        try {
            String _switchResult = null;
            boolean _matched = false;
            if (container instanceof Application) {
                _matched = true;
                _switchResult = "ApplicationOptions";
            }
            if (!_matched && container instanceof ProvidedService) {
                _matched = true;
                _switchResult = "ProvidedServiceOptions";
            }
            if (!_matched && container instanceof ProvidedMethod) {
                _matched = true;
                _switchResult = "ProvidedMethodOptions";
            }
            if (!_matched && container instanceof ConsumedService) {
                _matched = true;
                _switchResult = "ConsumedServiceOptions";
            }
            if (!_matched && container instanceof ConsumedMethod) {
                _matched = true;
                _switchResult = "ConsumedMethodOptions";
            }
            if (!_matched) {
                String _name = container.eClass().getName();
                String _plus = "Unexpected option container: " + _name;
                throw new Exception(_plus);
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }
}

