/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.ts;

import com.db.plexus.interop.dsl.Application;
import com.db.plexus.interop.dsl.ApplicationElement;
import com.db.plexus.interop.dsl.ConsumedMethod;
import com.db.plexus.interop.dsl.ConsumedService;
import com.db.plexus.interop.dsl.ProvidedMethod;
import com.db.plexus.interop.dsl.ProvidedService;
import com.db.plexus.interop.dsl.gen.ApplicationCodeGenerator;
import com.db.plexus.interop.dsl.gen.GenUtils;
import com.db.plexus.interop.dsl.gen.PlexusGenConfig;
import com.db.plexus.interop.dsl.protobuf.Method;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Named
public class TypescriptApplicationApiGenerator
extends ApplicationCodeGenerator {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public String fullName(EObject obj) {
        return this.qualifiedNameProvider.getFullyQualifiedName(obj).skipFirst(1).toString();
    }

    public String namespace(EObject obj) {
        return this.qualifiedNameProvider.getFullyQualifiedName(obj).skipFirst(1).skipLast(1).toString();
    }

    @Override
    public String generate(PlexusGenConfig genConfig, Application app, List<Resource> resources) {
        boolean _not;
        String _xblockexpression = null;
        List<ConsumedService> consumedServices = GenUtils.getConsumedServices(app);
        List<ProvidedService> providedServices = GenUtils.getProvidedServices(app);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _imports = this.imports(genConfig);
        _builder.append(_imports);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasElements = false;
        for (ConsumedService consumedService : consumedServices) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate("\n", "");
            }
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*  Proxy interface of ");
            String _firstUpper = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstUpper, " ");
            _builder.append(" service, to be consumed by Client API");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("export abstract class ");
            String _firstUpper_1 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstUpper_1);
            _builder.append("Proxy {");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            List<ConsumedMethod> _methods = GenUtils.getMethods(consumedService);
            boolean _hasElements_1 = false;
            for (ConsumedMethod consumedMethod : _methods) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate("\n", "    ");
                }
                _builder.append("    ");
                _builder.append("public abstract ");
                CharSequence _clientMethodSignature = this.clientMethodSignature(consumedMethod, genConfig);
                _builder.append((Object)_clientMethodSignature, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _hasElements_2 = false;
        for (ConsumedService consumedService : consumedServices) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate("\n", "");
            }
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*  Internal Proxy implementation for ");
            String _firstUpper_2 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstUpper_2, " ");
            _builder.append(" service");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("export class ");
            String _firstUpper_3 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstUpper_3);
            _builder.append("ProxyImpl implements ");
            String _firstUpper_4 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService));
            _builder.append(_firstUpper_4);
            _builder.append("Proxy {");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("constructor(private readonly genericClient: GenericClientApi) { }");
            _builder.newLine();
            _builder.newLine();
            List<ConsumedMethod> _methods_1 = GenUtils.getMethods(consumedService);
            boolean _hasElements_3 = false;
            for (ConsumedMethod consumedMethod : _methods_1) {
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder.appendImmediate("\n", "    ");
                }
                _builder.append("    ");
                _builder.append("public ");
                CharSequence _clientMethodSignature_1 = this.clientMethodSignature(consumedMethod, genConfig);
                _builder.append((Object)_clientMethodSignature_1, "    ");
                _builder.append(" {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                String _clientMethodImpl = this.clientMethodImpl(consumedMethod, consumedService, genConfig);
                _builder.append(_clientMethodImpl, "        ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Main client API");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("export interface ");
        String _name = app.getName();
        _builder.append(_name);
        _builder.append("Client extends GenericClientApi  {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasElements_4 = false;
        for (ConsumedService consumedService_2 : consumedServices) {
            if (!_hasElements_4) {
                _hasElements_4 = true;
            } else {
                _builder.appendImmediate("\n", "    ");
            }
            _builder.append("    ");
            _builder.append("get");
            Iterator<ApplicationElement> _firstUpper_5 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService_2));
            _builder.append((String)((Object)_firstUpper_5), "    ");
            _builder.append("Proxy(): ");
            String _firstUpper_6 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService_2));
            _builder.append(_firstUpper_6, "    ");
            _builder.append("Proxy;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Client's API internal implementation");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("class ");
        String _name_1 = app.getName();
        _builder.append(_name_1);
        _builder.append("ClientImpl extends GenericClientApiBase implements ");
        String string = app.getName();
        _builder.append(string);
        _builder.append("Client {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public constructor(");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("private readonly genericClient: GenericClientApi,");
        _builder.newLine();
        boolean _hasElements_5 = false;
        for (ConsumedService consumedService_3 : consumedServices) {
            if (!_hasElements_5) {
                _hasElements_5 = true;
            } else {
                _builder.appendImmediate(",", "        ");
            }
            _builder.append("        ");
            _builder.append("private readonly ");
            String _firstLower = StringExtensions.toFirstLower(GenUtils.getAliasOrName(consumedService_3));
            _builder.append(_firstLower, "        ");
            _builder.append("Proxy: ");
            String _firstUpper_7 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService_3));
            _builder.append(_firstUpper_7, "        ");
            _builder.append("Proxy");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append(") {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("super(genericClient);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _hasElements_6 = false;
        for (ConsumedService consumedService_4 : consumedServices) {
            if (!_hasElements_6) {
                _hasElements_6 = true;
            } else {
                _builder.appendImmediate("\n", "    ");
            }
            _builder.append("    ");
            _builder.append("public get");
            String _firstUpper_8 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService_4));
            _builder.append(_firstUpper_8, "    ");
            _builder.append("Proxy(): ");
            String _firstUpper_9 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService_4));
            _builder.append(_firstUpper_9, "    ");
            _builder.append("Proxy {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("return this.");
            String string2 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(consumedService_4));
            _builder.append(string2, "        ");
            _builder.append("Proxy;");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _hasElements_7 = false;
        for (ProvidedService providedService : providedServices) {
            if (!_hasElements_7) {
                _hasElements_7 = true;
            } else {
                _builder.appendImmediate("\n", "");
            }
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Client invocation handler for ");
            String _firstUpper_10 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedService));
            _builder.append(_firstUpper_10, " ");
            _builder.append(", to be implemented by Client");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("export abstract class ");
            String _firstUpper_11 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedService));
            _builder.append(_firstUpper_11);
            _builder.append("InvocationHandler {");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            List<ProvidedMethod> list = GenUtils.getMethods(providedService);
            boolean _hasElements_8 = false;
            for (ProvidedMethod providedMethod : list) {
                if (!_hasElements_8) {
                    _hasElements_8 = true;
                } else {
                    _builder.appendImmediate("\n", "    ");
                }
                _builder.append("    ");
                _builder.append("public abstract ");
                CharSequence _clientHandlerSignature = this.clientHandlerSignature(providedMethod.getMethod(), genConfig);
                _builder.append((Object)_clientHandlerSignature, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Client API builder");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("export class ");
        String _name_3 = app.getName();
        _builder.append(_name_3);
        _builder.append("ClientBuilder implements ClientApiBuilder<");
        String _name_4 = app.getName();
        _builder.append(_name_4);
        _builder.append("Client, ");
        String _name_5 = app.getName();
        _builder.append(_name_5);
        _builder.append("ClientBuilder> {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("protected genericBuilder: GenericClientApiBuilder =");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("new ContainerAwareClientAPIBuilder()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append(".withApplicationId('");
        String _fullName = this.fullName(app);
        _builder.append(_fullName, "            ");
        _builder.append("');");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasElements_9 = false;
        for (ProvidedService providedElement : providedServices) {
            if (!_hasElements_9) {
                _hasElements_9 = true;
            } else {
                _builder.appendImmediate("\n", "    ");
            }
            _builder.append("    ");
            _builder.append("private ");
            String _firstLower_2 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(providedElement));
            _builder.append(_firstLower_2, "    ");
            _builder.append("Handler: ");
            String _firstUpper_12 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedElement));
            _builder.append(_firstUpper_12, "    ");
            _builder.append("InvocationHandler;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _hasElements_10 = false;
        for (ProvidedService providedMethod_1 : providedServices) {
            if (!_hasElements_10) {
                _hasElements_10 = true;
            } else {
                _builder.appendImmediate("\n", "    ");
            }
            _builder.append("    ");
            _builder.append("public with");
            String _firstUpper_13 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedMethod_1));
            _builder.append(_firstUpper_13, "    ");
            _builder.append("InvocationsHandler(invocationsHandler: ");
            String _firstUpper_14 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(providedMethod_1));
            _builder.append(_firstUpper_14, "    ");
            _builder.append("InvocationHandler): ");
            String _name_6 = app.getName();
            _builder.append(_name_6, "    ");
            _builder.append("ClientBuilder {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("this.");
            String _firstLower_3 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(providedMethod_1));
            _builder.append(_firstLower_3, "        ");
            _builder.append("Handler = invocationsHandler;");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public withClientApiDecorator(clientApiDecorator: (client: InternalGenericClientApi) => Promise<GenericClientApi>): ");
        String _name_7 = app.getName();
        _builder.append(_name_7, "    ");
        _builder.append("ClientBuilder {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("this.genericBuilder.withClientApiDecorator(clientApiDecorator);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public withClientExtension(extension: (builder: ClientApiBuilder<");
        String string3 = app.getName();
        _builder.append(string3, "    ");
        _builder.append("Client, ");
        String _name_9 = app.getName();
        _builder.append(_name_9, "    ");
        _builder.append("ClientBuilder>) => void): ");
        String _name_10 = app.getName();
        _builder.append(_name_10, "    ");
        _builder.append("ClientBuilder {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("extension(this);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public withTransportConnectionProvider(provider: () => Promise<TransportConnection>): ");
        String _name_11 = app.getName();
        _builder.append(_name_11, "    ");
        _builder.append("ClientBuilder {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("this.genericBuilder.withTransportConnectionProvider(provider);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public withAppInstanceId(appInstanceId: UniqueId): ");
        String _name_12 = app.getName();
        _builder.append(_name_12, "    ");
        _builder.append("ClientBuilder {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("this.genericBuilder.withAppInstanceId(appInstanceId);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public withAppId(appId: string): ");
        String _name_13 = app.getName();
        _builder.append(_name_13, "    ");
        _builder.append("ClientBuilder {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("this.genericBuilder.withApplicationId(appId);");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public connect(): Promise<");
        String _name_14 = app.getName();
        _builder.append(_name_14, "    ");
        _builder.append("Client> {");
        _builder.newLineIfNotEmpty();
        for (ProvidedService providedService_1 : providedServices) {
            _builder.append("        ");
            _builder.append("if (!this.");
            String _firstLower_4 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(providedService_1));
            _builder.append(_firstLower_4, "        ");
            _builder.append("Handler) {");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("    ");
            _builder.append("return Promise.reject('Invocation handler for ");
            String _aliasOrName = GenUtils.getAliasOrName(providedService_1);
            _builder.append(_aliasOrName, "            ");
            _builder.append(" is not provided');");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("        ");
        _builder.append("return this.genericBuilder");
        _builder.newLine();
        for (ProvidedService providedService_2 : providedServices) {
            List<ProvidedMethod> _methods_3 = GenUtils.getMethods(providedService_2);
            for (ProvidedMethod providedMethod_2 : _methods_3) {
                _builder.append("            ");
                CharSequence _invocationHandlerBuilder = this.invocationHandlerBuilder(providedMethod_2.getMethod(), providedService_2, genConfig);
                _builder.append((Object)_invocationHandlerBuilder, "            ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("            ");
        _builder.append(".connect()");
        _builder.newLine();
        _builder.append("            ");
        _builder.append(".then(genericClient => new ");
        String _name_15 = app.getName();
        _builder.append(_name_15, "            ");
        _builder.append("ClientImpl(");
        _builder.newLineIfNotEmpty();
        _builder.append("                ");
        _builder.append("genericClient");
        boolean _isEmpty = consumedServices.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append(",");
        }
        _builder.newLineIfNotEmpty();
        boolean _hasElements_11 = false;
        for (ConsumedService consumedService_5 : consumedServices) {
            if (!_hasElements_11) {
                _hasElements_11 = true;
            } else {
                _builder.appendImmediate(",", "                ");
            }
            _builder.append("                ");
            _builder.append("new ");
            String _firstUpper_15 = StringExtensions.toFirstUpper(GenUtils.getAliasOrName(consumedService_5));
            _builder.append(_firstUpper_15, "                ");
            _builder.append("ProxyImpl(genericClient)");
            _builder.newLineIfNotEmpty();
            _builder.append("                ");
        }
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public CharSequence invocationHandlerBuilder(Method rpcMethod, ProvidedService providedService, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".withTypeAwareUnaryHandler({");
            _builder.newLine();
            _builder.append("    ");
            String _handlerBuilderParam = this.handlerBuilderParam(rpcMethod, providedService, genConfig);
            _builder.append(_handlerBuilderParam, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append("}, ");
            CharSequence _requestTypeImpl = this.requestTypeImpl(rpcMethod, genConfig);
            _builder.append(_requestTypeImpl);
            _builder.append(", ");
            CharSequence _responseTypeImpl = this.responseTypeImpl(rpcMethod, genConfig);
            _builder.append(_responseTypeImpl);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _switchResult = _builder;
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".withTypeAwareBidiStreamingHandler({");
            _builder_1.newLine();
            _builder_1.append("    ");
            String _handlerBuilderParam_1 = this.handlerBuilderParam(rpcMethod, providedService, genConfig);
            _builder_1.append(_handlerBuilderParam_1, "    ");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("}, ");
            CharSequence _requestTypeImpl_1 = this.requestTypeImpl(rpcMethod, genConfig);
            _builder_1.append(_requestTypeImpl_1);
            _builder_1.append(", ");
            CharSequence _responseTypeImpl_1 = this.responseTypeImpl(rpcMethod, genConfig);
            _builder_1.append(_responseTypeImpl_1);
            _builder_1.append(")");
            _builder_1.newLineIfNotEmpty();
            _switchResult = _builder_1;
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(".withTypeAwareServerStreamingHandler({");
            _builder_2.newLine();
            _builder_2.append("    ");
            String _handlerBuilderParam_2 = this.handlerBuilderParam(rpcMethod, providedService, genConfig);
            _builder_2.append(_handlerBuilderParam_2, "    ");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("}, ");
            CharSequence _requestTypeImpl_2 = this.requestTypeImpl(rpcMethod, genConfig);
            _builder_2.append(_requestTypeImpl_2);
            _builder_2.append(", ");
            CharSequence _responseTypeImpl_2 = this.responseTypeImpl(rpcMethod, genConfig);
            _builder_2.append(_responseTypeImpl_2);
            _builder_2.append(")");
            _builder_2.newLineIfNotEmpty();
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    public String handlerBuilderParam(Method rpcMethod, ProvidedService providedService, PlexusGenConfig genConfig) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("serviceInfo: {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("serviceId: '");
        String _fullName = this.fullName(GenUtils.getService(rpcMethod));
        _builder.append(_fullName, "    ");
        _builder.append("'");
        String _alias = providedService.getAlias();
        boolean bl = _tripleNotEquals = _alias != null;
        if (_tripleNotEquals) {
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("serviceAlias: '");
            String _alias_1 = providedService.getAlias();
            _builder.append(_alias_1, "    ");
            _builder.append("'");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("},");
        _builder.newLine();
        _builder.append("methodId: '");
        String _name = rpcMethod.getName();
        _builder.append(_name);
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("handle: this.");
        String _firstLower = StringExtensions.toFirstLower(GenUtils.getAliasOrName(providedService));
        _builder.append(_firstLower);
        _builder.append("Handler.on");
        String _name_1 = rpcMethod.getName();
        _builder.append(_name_1);
        _builder.append(".bind(this.");
        String _firstLower_1 = StringExtensions.toFirstLower(GenUtils.getAliasOrName(providedService));
        _builder.append(_firstLower_1);
        _builder.append("Handler)");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public CharSequence imports(PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import { InternalGenericClientApi, ClientApiBuilder, MethodInvocationContext, Completion, ClientConnectRequest, StreamingInvocationClient, GenericClientApi, InvocationRequestInfo, InvocationClient, GenericRequest, GenericClientApiBase } from '@plexus-interop/client';");
        _builder.newLine();
        _builder.append("import { ProvidedMethodReference, ServiceDiscoveryRequest, ServiceDiscoveryResponse, MethodDiscoveryRequest, MethodDiscoveryResponse, GenericClientApiBuilder, ValueHandler } from '@plexus-interop/client';");
        _builder.newLine();
        _builder.append("import { TransportConnection, UniqueId } from '@plexus-interop/transport-common';");
        _builder.newLine();
        _builder.append("import { Arrays, Observer } from '@plexus-interop/common';");
        _builder.newLine();
        _builder.append("import { InvocationObserver, InvocationObserverConverter, ContainerAwareClientAPIBuilder } from '@plexus-interop/client';");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import * as ");
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(" from '");
        String _get = genConfig.getExternalDependencies().get(0);
        _builder.append(_get);
        _builder.append("';");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence clientMethodSignature(ConsumedMethod methodLink, PlexusGenConfig genConfig) {
        return this.clientMethodSignature(methodLink.getMethod(), genConfig);
    }

    public CharSequence clientMethodSignature(Method rpcMethod, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            String _firstLower = StringExtensions.toFirstLower(rpcMethod.getName());
            _builder.append(_firstLower);
            _builder.append("(request: ");
            CharSequence _requestType = this.requestType(rpcMethod, genConfig);
            _builder.append(_requestType);
            _builder.append("): Promise<");
            CharSequence _responseType = this.responseType(rpcMethod, genConfig);
            _builder.append(_responseType);
            _builder.append(">");
            _switchResult = _builder;
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            String _firstLower_1 = StringExtensions.toFirstLower(rpcMethod.getName());
            _builder_1.append(_firstLower_1);
            _builder_1.append("(responseObserver: InvocationObserver<");
            CharSequence _responseType_1 = this.responseType(rpcMethod, genConfig);
            _builder_1.append(_responseType_1);
            _builder_1.append(">): Promise<StreamingInvocationClient<");
            CharSequence _requestType_1 = this.requestType(rpcMethod, genConfig);
            _builder_1.append(_requestType_1);
            _builder_1.append(">>");
            _switchResult = _builder_1;
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            String _firstLower_2 = StringExtensions.toFirstLower(rpcMethod.getName());
            _builder_2.append(_firstLower_2);
            _builder_2.append("(request: ");
            CharSequence _requestType_2 = this.requestType(rpcMethod, genConfig);
            _builder_2.append(_requestType_2);
            _builder_2.append(", responseObserver: InvocationObserver<");
            CharSequence _responseType_2 = this.responseType(rpcMethod, genConfig);
            _builder_2.append(_responseType_2);
            _builder_2.append(">): Promise<InvocationClient>");
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    public CharSequence requestType(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _lowerCase = this.namespace(rpcMethod.getRequest().getMessage()).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".I");
        String _name = rpcMethod.getRequest().getMessage().getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence responseType(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _lowerCase = this.namespace(rpcMethod.getResponse().getMessage()).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".I");
        String _name = rpcMethod.getResponse().getMessage().getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence requestTypeImpl(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _lowerCase = this.namespace(rpcMethod.getRequest().getMessage()).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".");
        String _name = rpcMethod.getRequest().getMessage().getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence responseTypeImpl(Method rpcMethod, PlexusGenConfig genConfig) {
        StringConcatenation _builder = new StringConcatenation();
        String _namespace = genConfig.getNamespace();
        _builder.append(_namespace);
        _builder.append(".");
        String _lowerCase = this.namespace(rpcMethod.getResponse().getMessage()).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".");
        String _name = rpcMethod.getResponse().getMessage().getName();
        _builder.append(_name);
        return _builder;
    }

    public String clientMethodImpl(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        String _xblockexpression = null;
        Method rpcMethod = consumed.getMethod();
        String _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            _switchResult = this.clientPointToPointImpl(consumed, consumedService, genConfig);
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            _switchResult = this.clientBidiStreamingImpl(consumed, consumedService, genConfig);
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            _switchResult = this.serverStreamingImpl(consumed, consumedService, genConfig);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String clientPointToPointImpl(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        Method rpcMethod = consumed.getMethod();
        StringConcatenation _builder = new StringConcatenation();
        String _clientInvocationInfo = this.clientInvocationInfo(consumed, consumedService, genConfig);
        _builder.append(_clientInvocationInfo);
        _builder.newLineIfNotEmpty();
        _builder.append("return new Promise((resolve, reject) => {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("this.genericClient.sendUnaryRequest(invocationInfo, request, {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("value: responsePayload => resolve(responsePayload),");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("error: e => reject(e)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}, ");
        CharSequence _requestTypeImpl = this.requestTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_requestTypeImpl, "    ");
        _builder.append(", ");
        CharSequence _responseTypeImpl = this.responseTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_responseTypeImpl, "    ");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("});");
        _builder.newLine();
        return _builder.toString();
    }

    public String clientBidiStreamingImpl(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        Method rpcMethod = consumed.getMethod();
        StringConcatenation _builder = new StringConcatenation();
        String _clientInvocationInfo = this.clientInvocationInfo(consumed, consumedService, genConfig);
        _builder.append(_clientInvocationInfo);
        _builder.newLineIfNotEmpty();
        _builder.append("return this.genericClient.sendBidirectionalStreamingRequest(");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("invocationInfo,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("responseObserver,");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _requestTypeImpl = this.requestTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_requestTypeImpl, "    ");
        _builder.append(", ");
        CharSequence _responseTypeImpl = this.responseTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_responseTypeImpl, "    ");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serverStreamingImpl(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        Method rpcMethod = consumed.getMethod();
        StringConcatenation _builder = new StringConcatenation();
        String _clientInvocationInfo = this.clientInvocationInfo(consumed, consumedService, genConfig);
        _builder.append(_clientInvocationInfo);
        _builder.newLineIfNotEmpty();
        _builder.append("return this.genericClient.sendServerStreamingRequest(");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("invocationInfo,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("request,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("responseObserver,");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _requestTypeImpl = this.requestTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_requestTypeImpl, "    ");
        _builder.append(", ");
        CharSequence _responseTypeImpl = this.responseTypeImpl(rpcMethod, genConfig);
        _builder.append((Object)_responseTypeImpl, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append(");");
        _builder.newLine();
        return _builder.toString();
    }

    public String clientInvocationInfo(ConsumedMethod consumed, ConsumedService consumedService, PlexusGenConfig genConfig) {
        boolean _tripleNotEquals;
        Method rpcMethod = consumed.getMethod();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const invocationInfo: InvocationRequestInfo = {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("methodId: '");
        String _name = rpcMethod.getName();
        _builder.append(_name, "    ");
        _builder.append("',");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("serviceId: '");
        String _fullName = this.fullName(GenUtils.getService(rpcMethod));
        _builder.append(_fullName, "    ");
        _builder.append("'");
        String _alias = consumedService.getAlias();
        boolean bl = _tripleNotEquals = _alias != null;
        if (_tripleNotEquals) {
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("serviceAlias: '");
            String _alias_1 = consumedService.getAlias();
            _builder.append(_alias_1, "    ");
            _builder.append("'");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence clientHandlerSignature(Method rpcMethod, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("on");
            String _name = rpcMethod.getName();
            _builder.append(_name);
            _builder.append("(invocationContext: MethodInvocationContext, request: ");
            CharSequence _requestType = this.requestType(rpcMethod, genConfig);
            _builder.append(_requestType);
            _builder.append("): Promise<");
            CharSequence _responseType = this.responseType(rpcMethod, genConfig);
            _builder.append(_responseType);
            _builder.append(">");
            _switchResult = _builder;
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("on");
            String _name_1 = rpcMethod.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(invocationContext: MethodInvocationContext, hostClient: StreamingInvocationClient<");
            CharSequence _responseType_1 = this.responseType(rpcMethod, genConfig);
            _builder_1.append(_responseType_1);
            _builder_1.append(">): InvocationObserver<");
            CharSequence _requestType_1 = this.requestType(rpcMethod, genConfig);
            _builder_1.append(_requestType_1);
            _builder_1.append(">");
            _switchResult = _builder_1;
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("on");
            String _name_2 = rpcMethod.getName();
            _builder_2.append(_name_2);
            _builder_2.append("(invocationContext: MethodInvocationContext, request: ");
            CharSequence _requestType_2 = this.requestType(rpcMethod, genConfig);
            _builder_2.append(_requestType_2);
            _builder_2.append(", hostClient: StreamingInvocationClient<");
            CharSequence _responseType_2 = this.responseType(rpcMethod, genConfig);
            _builder_2.append(_responseType_2);
            _builder_2.append(">): void");
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    public CharSequence genericClientHandlerSignature(Method rpcMethod, PlexusGenConfig genConfig) {
        boolean _isServerStreaming;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        boolean _isPointToPoint = GenUtils.isPointToPoint(rpcMethod);
        if (_isPointToPoint) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("on");
            String _name = rpcMethod.getName();
            _builder.append(_name);
            _builder.append("(invocationContext: MethodInvocationContext, request: ArrayBuffer): Promise<ArrayBuffer>");
            _switchResult = _builder;
        }
        if (!_matched && (GenUtils.isBidiStreaming(rpcMethod) || GenUtils.isClientStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("on");
            String _name_1 = rpcMethod.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(invocationContext: MethodInvocationContext, hostClient: StreamingInvocationClient<ArrayBuffer>): InvocationObserver<ArrayBuffer>");
            _switchResult = _builder_1;
        }
        if (!_matched && (_isServerStreaming = GenUtils.isServerStreaming(rpcMethod))) {
            _matched = true;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("on");
            String _name_2 = rpcMethod.getName();
            _builder_2.append(_name_2);
            _builder_2.append("(invocationContext: MethodInvocationContext, request: ArrayBuffer, hostClient: StreamingInvocationClient<ArrayBuffer>): void");
            _switchResult = _builder_2;
        }
        return _switchResult;
    }
}

