/*
 * Decompiled with CFR 0.152.
 */
package com.db.plexus.interop.dsl.gen.util;

import com.db.plexus.interop.dsl.gen.util.CombinedFilePathMatcher;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.apache.log4j.Logger;

public class FileUtils {
    private static Logger log = Logger.getLogger(FileUtils.class);

    public static File createTempDir() throws IOException {
        Path directory = Files.createTempDirectory("plexus" + Long.toString(System.nanoTime()), new FileAttribute[0]);
        return directory.toFile();
    }

    public static void writeStringToFile(File file, String content) throws IOException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(content);
        }
    }

    public static void processFiles(String baseDir, String pattern, Consumer<Path> fileHandler) throws IOException {
        Files.walkFileTree(Paths.get(baseDir, new String[0]), new Finder(pattern, fileHandler));
    }

    private static class Finder
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;
        private final Consumer<Path> fileHandler;

        Finder(String pattern, Consumer<Path> fileHandler) {
            this.matcher = new CombinedFilePathMatcher(pattern);
            this.fileHandler = fileHandler;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path name = file.getFileName();
            if (this.matcher.matches(file) || name != null && this.matcher.matches(name)) {
                this.fileHandler.accept(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            log.error(String.format("Failed to load %s file", file.toString()), exc);
            return FileVisitResult.CONTINUE;
        }
    }
}

