/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class JvmTypeReferenceBuilder {
    private StandardTypeReferenceOwner typeReferenceOwner;
    private ResourceSet context;
    @Inject
    private TypeReferences references;

    public JvmTypeReference typeRef(Class<?> clazz, JvmTypeReference ... typeArgs) {
        JvmType type = this.references.findDeclaredType(clazz, (Notifier)this.context);
        if (type == null) {
            return this.createUnknownTypeReference(clazz.getName());
        }
        return this.typeRef(type, typeArgs);
    }

    private JvmTypeReference createUnknownTypeReference(String name) {
        JvmUnknownTypeReference reference = TypesFactory.eINSTANCE.createJvmUnknownTypeReference();
        reference.setQualifiedName(name);
        return reference;
    }

    public JvmTypeReference typeRef(String typeName, JvmTypeReference ... typeArgs) {
        JvmType type = this.references.findDeclaredType(typeName, (Notifier)this.context);
        if (type == null) {
            return this.createUnknownTypeReference(typeName);
        }
        return this.typeRef(type, typeArgs);
    }

    public JvmTypeReference typeRef(JvmType type, JvmTypeReference ... typeArgs) {
        int typeParams = 0;
        if (type instanceof JvmGenericType) {
            typeParams = ((JvmGenericType)type).getTypeParameters().size();
        }
        if (typeParams < typeArgs.length) {
            throw new IllegalArgumentException("The type " + type.getIdentifier() + " only declares " + typeParams + " type parameters. You passed " + typeArgs.length + ".");
        }
        LightweightTypeReference reference = this.typeReferenceOwner.toPlainTypeReference(type);
        for (JvmTypeReference jvmTypeReference : typeArgs) {
            ((ParameterizedTypeReference)reference).addTypeArgument(this.typeReferenceOwner.toLightweightTypeReference(jvmTypeReference));
        }
        return reference.toJavaCompliantTypeReference();
    }

    public JvmTypeReference wildcardExtends(JvmTypeReference extendsBound) {
        WildcardTypeReference wildcardTypeReference = this.typeReferenceOwner.newWildcardTypeReference();
        wildcardTypeReference.addUpperBound(this.typeReferenceOwner.toLightweightTypeReference(extendsBound));
        return wildcardTypeReference.toTypeReference();
    }

    public JvmTypeReference wildcardSuper(JvmTypeReference superBound) {
        WildcardTypeReference wildcardTypeReference = this.typeReferenceOwner.newWildcardTypeReference();
        wildcardTypeReference.addUpperBound(this.typeReferenceOwner.toLightweightTypeReference(this.typeRef(Object.class, new JvmTypeReference[0])));
        wildcardTypeReference.setLowerBound(this.typeReferenceOwner.toLightweightTypeReference(superBound));
        return wildcardTypeReference.toTypeReference();
    }

    public JvmTypeReference wildcard() {
        return this.wildcardExtends(this.typeRef(Object.class, new JvmTypeReference[0]));
    }

    public static class Factory {
        @Inject
        Provider<JvmTypeReferenceBuilder> builderProvider;
        @Inject
        CommonTypeComputationServices services;

        public JvmTypeReferenceBuilder create(ResourceSet context) {
            if (context == null) {
                throw new NullPointerException("'context' cannot be null.");
            }
            JvmTypeReferenceBuilder result = this.builderProvider.get();
            result.context = context;
            result.typeReferenceOwner = new StandardTypeReferenceOwner(this.services, context);
            return result;
        }
    }
}

