/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.jvm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import jogamp.common.Debug;

public class JNILibLoaderBase {
    public static final boolean DEBUG = Debug.debug("JNILibLoader");
    private static final Set<String> loaded = new HashSet<String>();
    private static LoaderAction loaderAction = new DefaultAction();

    public static boolean isLoaded(String string) {
        return loaded.contains(string);
    }

    public static void addLoaded(String string) {
        loaded.add(string);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase Loaded Native Library: " + string);
        }
    }

    public static void disableLoading() {
        JNILibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        JNILibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        JNILibLoaderBase.loaderAction = loaderAction;
    }

    protected static synchronized boolean loadLibrary(String string, boolean bl) {
        if (loaderAction != null) {
            return loaderAction.loadLibrary(string, bl);
        }
        return false;
    }

    protected static synchronized void loadLibrary(String string, String[] stringArray, boolean bl) {
        if (loaderAction != null) {
            loaderAction.loadLibrary(string, stringArray, bl);
        }
    }

    private static class DefaultAction
    implements LoaderAction {
        private static final Method customLoadLibraryMethod;
        private static final AccessControlContext localACC;
        private static final String osAndArch;
        private static final String ext;
        private static final String prefix;

        private DefaultAction() {
        }

        public boolean loadLibrary(String string, boolean bl) {
            boolean bl2;
            block5: {
                bl2 = true;
                if (!JNILibLoaderBase.isLoaded(string)) {
                    try {
                        this.loadLibraryImpl(string);
                        JNILibLoaderBase.addLoaded(string);
                        if (DEBUG) {
                            System.err.println(this.getClass() + " loaded " + string);
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        bl2 = false;
                        if (DEBUG) {
                            unsatisfiedLinkError.printStackTrace();
                        }
                        if (bl || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) break block5;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            return bl2;
        }

        public void loadLibrary(String string, String[] stringArray, boolean bl) {
            if (!JNILibLoaderBase.isLoaded(string)) {
                if (null != stringArray) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.loadLibrary(stringArray[i], bl);
                    }
                }
                this.loadLibrary(string, false);
            }
        }

        private void loadLibraryImpl(String string) {
            if (null != customLoadLibraryMethod && !string.equals("jawt")) {
                this.loadCustom(string);
            } else {
                try {
                    if (this.loadFromClasspath(string)) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException("can not load " + string + " from classpath", iOException);
                }
                this.loadFromLibpath(string);
            }
        }

        private void loadCustom(String string) {
            try {
                customLoadLibraryMethod.invoke(null, string);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("can not load library " + string).initCause(exception);
            }
        }

        private void loadFromLibpath(String string) {
            System.loadLibrary(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadFromClasspath(String string) throws IOException {
            String string2 = '/' + osAndArch + '/' + prefix + string + '.' + ext;
            InputStream inputStream = this.getClass().getResourceAsStream(string2);
            if (inputStream != null) {
                File file = File.createTempFile(prefix + string, '.' + ext);
                file.deleteOnExit();
                FileOutputStream fileOutputStream = null;
                try {
                    int n;
                    fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[8192];
                    while ((n = inputStream.read(byArray)) > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    finally {
                        if (fileOutputStream != null) {
                            ((OutputStream)fileOutputStream).close();
                        }
                    }
                }
                System.load(file.getPath());
                return true;
            }
            return false;
        }

        static {
            String string;
            localACC = AccessController.getContext();
            Method method = null;
            Class<?> clazz = null;
            if (Debug.getBooleanProperty("sun.jnlp.applet.launcher", false, localACC)) {
                try {
                    clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    method = clazz.getDeclaredMethod("loadLibrary", String.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (DEBUG) {
                        classNotFoundException.printStackTrace();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (DEBUG) {
                        noSuchMethodException.printStackTrace();
                    }
                    clazz = null;
                }
            }
            if (null == clazz && null != (string = Debug.getProperty("jnlp.launcher.class", false, localACC))) {
                try {
                    clazz = Class.forName(string);
                    method = clazz.getDeclaredMethod("loadLibrary", String.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (DEBUG) {
                        classNotFoundException.printStackTrace();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (DEBUG) {
                        noSuchMethodException.printStackTrace();
                    }
                    clazz = null;
                }
            }
            customLoadLibraryMethod = method;
            string = System.getProperty("os.name").toLowerCase();
            if (string.contains("windows")) {
                string = "windows";
                ext = "dll";
                prefix = "";
            } else if (string.contains("mac os")) {
                string = "macosx";
                ext = "jnilib";
                prefix = "lib";
            } else {
                string = "linux";
                ext = "so";
                prefix = "lib";
            }
            String string2 = System.getProperty("os.arch").toLowerCase();
            string2 = string.equals("macosx") ? "universal" : (string2.contains("64") ? "amd64" : "i586");
            osAndArch = string + "-" + string2;
        }
    }

    public static interface LoaderAction {
        public boolean loadLibrary(String var1, boolean var2);

        public void loadLibrary(String var1, String[] var2, boolean var3);
    }
}

