/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.NativeBuffer;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBuffer<B extends AbstractBuffer>
implements NativeBuffer {
    protected final ByteBuffer bb;
    protected final int capacity;
    private final int ELEMENT_SIZE;

    protected AbstractBuffer(ByteBuffer byteBuffer, int n) {
        this.bb = byteBuffer;
        this.capacity = byteBuffer.capacity() / n;
        this.ELEMENT_SIZE = n;
    }

    @Override
    public final int limit() {
        return this.bb.limit() / this.ELEMENT_SIZE;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int position() {
        return this.bb.position() / this.ELEMENT_SIZE;
    }

    public B position(int n) {
        if (0 > n || n >= this.capacity) {
            throw new IndexOutOfBoundsException("Sorry to interrupt, but the position " + n + " was out of bounds. " + "My capacity is " + this.capacity() + ".");
        }
        this.bb.position(n * this.ELEMENT_SIZE);
        return (B)this;
    }

    @Override
    public final int remaining() {
        return this.bb.remaining() / this.ELEMENT_SIZE;
    }

    @Override
    public final boolean hasRemaining() {
        return this.bb.hasRemaining();
    }

    public B rewind() {
        this.bb.rewind();
        return (B)this;
    }

    @Override
    public boolean hasArray() {
        return this.bb.hasArray();
    }

    @Override
    public final byte[] array() {
        return this.bb.array();
    }

    @Override
    public int arrayOffset() {
        return this.bb.arrayOffset();
    }

    @Override
    public final ByteBuffer getBuffer() {
        return this.bb;
    }

    @Override
    public final boolean isDirect() {
        return this.bb.isDirect();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[capacity " + this.capacity() + ", position " + this.position() + ", elementSize " + this.bb.capacity() / this.capacity + "]";
    }
}

