/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.common.os.Platform;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public final class PointerBuffer
extends NativeSizeBuffer {
    protected final Map<Long, Buffer> dataMap = new HashMap<Long, Buffer>();

    protected PointerBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public static PointerBuffer allocate(int n) {
        return new PointerBuffer(ByteBuffer.wrap(new byte[PointerBuffer.elementSize() * n]));
    }

    public static PointerBuffer allocate(long[] lArray) {
        return PointerBuffer.allocate(lArray.length).put(lArray, 0, lArray.length).rewind();
    }

    public static PointerBuffer allocateDirect(int n) {
        return new PointerBuffer(Buffers.newDirectByteBuffer(PointerBuffer.elementSize() * n));
    }

    public static PointerBuffer allocateDirect(long[] lArray) {
        return PointerBuffer.allocateDirect(lArray.length).put(lArray, 0, lArray.length).rewind();
    }

    public static PointerBuffer wrap(ByteBuffer byteBuffer) {
        return new PointerBuffer(byteBuffer);
    }

    public PointerBuffer put(NativeBuffer nativeBuffer) {
        if (this.remaining() < nativeBuffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        while (nativeBuffer.hasRemaining()) {
            long l = nativeBuffer.get();
            this.put(l);
            Buffer buffer = this.dataMap.get(l);
            if (buffer != null) {
                this.dataMap.put(l, buffer);
                continue;
            }
            this.dataMap.remove(l);
        }
        return this;
    }

    private void referenceBufferImpl(int n, Buffer buffer, boolean bl) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (buffer.isDirect() != this.isDirect()) {
            throw new IllegalArgumentException("buffer.isDirect() != this.isDirect()");
        }
        long l = Platform.is32Bit() ? 0xFFFFFFFFL : -1L;
        long l2 = this.getDirectBufferAddressImpl(buffer) & l;
        if (l2 == 0L) {
            throw new RuntimeException("Couldn't determine native address of given Buffer: " + buffer);
        }
        if (bl) {
            this.put(l2);
        } else {
            this.put(n, l2);
        }
        this.dataMap.put(l2, buffer);
    }

    public final PointerBuffer referenceBuffer(int n, Buffer buffer) {
        this.referenceBufferImpl(n, buffer, false);
        return this;
    }

    public final PointerBuffer referenceBuffer(Buffer buffer) {
        this.referenceBufferImpl(0, buffer, true);
        return this;
    }

    public final Buffer getReferencedBuffer(int n) {
        long l = this.get(n);
        return this.dataMap.get(l);
    }

    public final Buffer getReferencedBuffer() {
        long l = this.get();
        return this.dataMap.get(l);
    }

    protected native long getDirectBufferAddressImpl(Object var1);

    public PointerBuffer put(int n, long l) {
        return (PointerBuffer)super.put(n, l);
    }

    public PointerBuffer get(long[] lArray, int n, int n2) {
        return (PointerBuffer)super.get(lArray, n, n2);
    }

    public PointerBuffer put(long l) {
        return (PointerBuffer)super.put(l);
    }

    public PointerBuffer put(long[] lArray, int n, int n2) {
        return (PointerBuffer)super.put(lArray, n, n2);
    }

    public PointerBuffer position(int n) {
        return (PointerBuffer)super.position(n);
    }

    public PointerBuffer rewind() {
        return (PointerBuffer)super.rewind();
    }
}

