/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Logging {
    static void init() {
        String string = Logging.class.getPackage().getName();
        String string2 = System.getProperty(string + ".level");
        Level level = string2 != null ? Level.parse(string2) : Level.WARNING;
        ConsoleHandler consoleHandler = new ConsoleHandler(){

            @Override
            public Formatter getFormatter() {
                return new PlainLogFormatter();
            }
        };
        consoleHandler.setFormatter(new PlainLogFormatter());
        consoleHandler.setLevel(level);
        Logger logger = Logger.getLogger(string);
        logger.setUseParentHandlers(false);
        logger.setLevel(level);
        logger.addHandler(consoleHandler);
    }

    private static class PlainLogFormatter
    extends Formatter {
        private PlainLogFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("[").append(logRecord.getLevel()).append(' ').append(logRecord.getSourceClassName()).append("]: ");
            stringBuilder.append(this.formatMessage(logRecord)).append("\n");
            return stringBuilder.toString();
        }
    }
}

