/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram;

import com.jogamp.gluegen.cgram.TNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CSymbolTable {
    private Vector scopeStack = new Vector(10);
    private Hashtable symTable = new Hashtable(533);

    public void pushScope(String string) {
        this.scopeStack.addElement(string);
    }

    public void popScope() {
        int n = this.scopeStack.size();
        if (n > 0) {
            this.scopeStack.removeElementAt(n - 1);
        }
    }

    public String currentScopeAsString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = true;
        Enumeration enumeration = this.scopeStack.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("::");
            }
            stringBuffer.append(enumeration.nextElement().toString());
        }
        return stringBuffer.toString();
    }

    public String addCurrentScopeToName(String string) {
        String string2 = this.currentScopeAsString();
        return this.addScopeToName(string2, string);
    }

    public String addScopeToName(String string, String string2) {
        if (string == null || string.length() > 0) {
            return string + "::" + string2;
        }
        return string2;
    }

    public String removeOneLevelScope(String string) {
        int n = string.lastIndexOf("::");
        if (n > 0) {
            return string.substring(0, n);
        }
        if (string.length() > 0) {
            return "";
        }
        return null;
    }

    public TNode add(String string, TNode tNode) {
        return this.symTable.put(this.addCurrentScopeToName(string), tNode);
    }

    public TNode lookupScopedName(String string) {
        return (TNode)((Object)this.symTable.get(string));
    }

    public TNode lookupNameInCurrentScope(String string) {
        String string2 = this.currentScopeAsString();
        TNode tNode = null;
        while (tNode == null && string2 != null) {
            String string3 = this.addScopeToName(string2, string);
            tNode = (TNode)((Object)this.symTable.get(string3));
            string2 = this.removeOneLevelScope(string2);
        }
        return tNode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("CSymbolTable { \nCurrentScope: " + this.currentScopeAsString() + "\nDefinedSymbols:\n");
        Enumeration enumeration = this.symTable.keys();
        Enumeration enumeration2 = this.symTable.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString() + " (" + TNode.getNameForType(((TNode)((Object)enumeration2.nextElement())).getType()) + ")\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

