/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram;

import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import com.jogamp.gluegen.cgram.GnuCEmitterTokenTypes;
import com.jogamp.gluegen.cgram.LineObject;
import com.jogamp.gluegen.cgram.PreprocessorInfoChannel;
import com.jogamp.gluegen.cgram.TNode;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class GnuCEmitter
extends TreeParser
implements GnuCEmitterTokenTypes {
    int tabs = 0;
    PrintStream currentOutput = System.out;
    int lineNum = 1;
    String currentSource = "";
    LineObject trueSourceFile;
    final int lineDirectiveThreshold = Integer.MAX_VALUE;
    PreprocessorInfoChannel preprocessorInfoChannel = null;
    Stack sourceFiles = new Stack();
    int traceDepth = 0;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"typedef\"", "\"asm\"", "\"volatile\"", "LCURLY", "RCURLY", "SEMI", "\"struct\"", "\"union\"", "\"enum\"", "\"auto\"", "\"register\"", "\"extern\"", "\"static\"", "\"const\"", "\"void\"", "\"char\"", "\"short\"", "\"int\"", "\"long\"", "\"float\"", "\"double\"", "\"signed\"", "\"unsigned\"", "\"__int32\"", "\"int32_t\"", "\"wchar_t\"", "\"uint32_t\"", "\"__int64\"", "\"int64_t\"", "\"uint64_t\"", "\"ptrdiff_t\"", "\"intptr_t\"", "\"size_t\"", "\"uintptr_t\"", "ID", "COMMA", "COLON", "ASSIGN", "STAR", "LPAREN", "RPAREN", "LBRACKET", "RBRACKET", "VARARGS", "\"while\"", "\"do\"", "\"for\"", "\"goto\"", "\"continue\"", "\"break\"", "\"return\"", "\"case\"", "\"default\"", "\"if\"", "\"else\"", "\"switch\"", "DIV_ASSIGN", "PLUS_ASSIGN", "MINUS_ASSIGN", "STAR_ASSIGN", "MOD_ASSIGN", "RSHIFT_ASSIGN", "LSHIFT_ASSIGN", "BAND_ASSIGN", "BOR_ASSIGN", "BXOR_ASSIGN", "QUESTION", "LOR", "LAND", "BOR", "BXOR", "BAND", "EQUAL", "NOT_EQUAL", "LT", "LTE", "GT", "GTE", "LSHIFT", "RSHIFT", "PLUS", "MINUS", "DIV", "MOD", "INC", "DEC", "\"sizeof\"", "BNOT", "LNOT", "PTR", "DOT", "CharLiteral", "StringLiteral", "IntOctalConst", "LongOctalConst", "UnsignedOctalConst", "IntIntConst", "LongIntConst", "UnsignedIntConst", "IntHexConst", "LongHexConst", "UnsignedHexConst", "FloatDoubleConst", "DoubleDoubleConst", "LongDoubleConst", "NTypedefName", "NInitDecl", "NDeclarator", "NStructDeclarator", "NDeclaration", "NCast", "NPointerGroup", "NExpressionGroup", "NFunctionCallArgs", "NNonemptyAbstractDeclarator", "NInitializer", "NStatementExpr", "NEmptyExpression", "NParameterTypeList", "NFunctionDef", "NCompoundStatement", "NParameterDeclaration", "NCommaExpr", "NUnaryExpr", "NLabel", "NPostfixExpr", "NRangeExpr", "NStringSeq", "NInitializerElementLabel", "NLcurlyInitializer", "NAsmAttribute", "NGnuAsmExpr", "NTypeMissing", "Vocabulary", "Whitespace", "Comment", "CPPComment", "NonWhitespace", "a line directive", "DefineExpr", "DefineExpr2", "Space", "LineDirective", "BadStringLiteral", "Escape", "Digit", "LongSuffix", "UnsignedSuffix", "FloatSuffix", "Exponent", "Number", "\"__label__\"", "\"inline\"", "\"typeof\"", "\"__complex\"", "\"__attribute\"", "\"__alignof\"", "\"__real\"", "\"__imag\""};
    public static final BitSet _tokenSet_0 = new BitSet(GnuCEmitter.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(GnuCEmitter.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(GnuCEmitter.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(GnuCEmitter.mk_tokenSet_3());

    public GnuCEmitter(PreprocessorInfoChannel preprocessorInfoChannel) {
        this.preprocessorInfoChannel = preprocessorInfoChannel;
    }

    void initializePrinting() {
        Vector vector = this.preprocessorInfoChannel.extractLinesPrecedingTokenNumber(new Integer(1));
        this.printPreprocs(vector);
    }

    void finalizePrinting() {
        this.printPreprocs(this.preprocessorInfoChannel.extractLinesPrecedingTokenNumber(new Integer(this.preprocessorInfoChannel.getMaxTokenNumber() + 1)));
        this.currentOutput.println();
    }

    void printPreprocs(Vector vector) {
        if (vector.size() > 0) {
            if (this.trueSourceFile != null) {
                this.currentOutput.println();
            }
            ++this.lineNum;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e.getClass().getName().equals("LineObject")) {
                    LineObject lineObject = (LineObject)e;
                    if (this.trueSourceFile != null && !this.currentSource.equals(this.trueSourceFile.getSource()) && this.trueSourceFile.getSource().equals(lineObject.getSource())) {
                        lineObject.setEnteringFile(false);
                        lineObject.setReturningToFile(true);
                    }
                    this.currentOutput.println(lineObject);
                    this.lineNum = lineObject.getLine();
                    this.currentSource = lineObject.getSource();
                    if (this.trueSourceFile == null) {
                        this.trueSourceFile = new LineObject(this.currentSource);
                        this.sourceFiles.push(this.trueSourceFile);
                    }
                    if (lineObject.getEnteringFile()) {
                        this.sourceFiles.push(lineObject);
                    }
                    if (!lineObject.getReturningToFile()) continue;
                    LineObject lineObject2 = (LineObject)this.sourceFiles.peek();
                    while (lineObject2 != this.trueSourceFile && !lineObject.getSource().equals(lineObject2.getSource())) {
                        this.sourceFiles.pop();
                        lineObject2 = (LineObject)this.sourceFiles.peek();
                    }
                    continue;
                }
                this.currentOutput.println(e);
                ++this.lineNum;
            }
        }
    }

    void print(TNode tNode) {
        int n = tNode.getLocalLineNum();
        if (n == 0) {
            n = this.lineNum;
        }
        Vector vector = this.preprocessorInfoChannel.extractLinesPrecedingTokenNumber((Integer)tNode.getAttribute("tokenNumber"));
        this.printPreprocs(vector);
        if (this.lineNum != n) {
            this.currentOutput.println();
            ++this.lineNum;
            this.printTabs();
        }
        if (this.lineNum != n) {
            int n2 = n - this.lineNum;
            if (this.lineNum < n) {
                while (this.lineNum < n) {
                    this.currentOutput.println();
                    ++this.lineNum;
                }
                this.printTabs();
            } else {
                this.lineNum = n;
            }
        }
        this.currentOutput.print(tNode.getText() + " ");
    }

    void printAddingLineDirectives(TNode tNode) {
        int n = tNode.getLocalLineNum();
        String string = (String)tNode.getAttribute("source");
        if (string == null) {
            string = this.currentSource;
        }
        if (n == 0) {
            n = this.lineNum;
        }
        Vector vector = this.preprocessorInfoChannel.extractLinesPrecedingTokenNumber((Integer)tNode.getAttribute("tokenNumber"));
        this.printPreprocs(vector);
        if (this.lineNum != n || !this.currentSource.equals(string)) {
            this.currentOutput.println();
            ++this.lineNum;
            this.printTabs();
        }
        if (this.lineNum != n || !this.currentSource.equals(string)) {
            if (this.currentSource.equals(string)) {
                int n2 = n - this.lineNum;
                if (n2 > 0 && n2 < Integer.MAX_VALUE) {
                    while (this.lineNum < n) {
                        this.currentOutput.println();
                        ++this.lineNum;
                    }
                } else if (!this.sourceFiles.empty()) {
                    LineObject lineObject = (LineObject)this.sourceFiles.peek();
                    StringBuffer stringBuffer = new StringBuffer("");
                    if (lineObject.getSystemHeader()) {
                        stringBuffer.append(" 3");
                    }
                    if (lineObject.getTreatAsC()) {
                        stringBuffer.append(" 4");
                    }
                    this.currentOutput.println("# " + n + " \"" + string + "\"" + stringBuffer.toString());
                    this.lineNum = n;
                }
                this.printTabs();
            } else {
                LineObject lineObject;
                Enumeration enumeration = this.sourceFiles.elements();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    lineObject = (LineObject)enumeration.nextElement();
                    if (!lineObject.getSource().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    lineObject = (LineObject)this.sourceFiles.peek();
                    while (lineObject != this.trueSourceFile && !lineObject.getSource().equals(string)) {
                        this.sourceFiles.pop();
                        lineObject = (LineObject)this.sourceFiles.peek();
                    }
                    StringBuffer stringBuffer = new StringBuffer(" 2");
                    if (lineObject.getSystemHeader()) {
                        stringBuffer.append(" 3");
                    }
                    if (lineObject.getTreatAsC()) {
                        stringBuffer.append(" 4");
                    }
                    this.currentOutput.println("# " + n + " \"" + string + "\"" + stringBuffer);
                    this.lineNum = n;
                    this.currentSource = string;
                    this.printTabs();
                } else {
                    this.currentOutput.println("# " + n + " \"" + string + "\"" + " 1");
                    this.lineNum = n;
                    this.currentSource = string;
                    this.printTabs();
                }
            }
        }
        this.currentOutput.print(tNode.getText() + " ");
    }

    void print(String string) {
        this.currentOutput.print(string + " ");
    }

    void printTabs() {
        for (int i = 0; i < this.tabs; ++i) {
            this.currentOutput.print("\t");
        }
    }

    void commaSep(TNode tNode) {
        this.print(tNode);
        if (tNode.getNextSibling() != null) {
            this.print(",");
        }
    }

    public void reportError(RecognitionException recognitionException) {
        if (recognitionException != null) {
            System.err.println("ANTLR Tree Parsing RecognitionException Error: " + ((Object)((Object)recognitionException)).getClass().getName() + " " + (Object)((Object)recognitionException));
            recognitionException.printStackTrace(System.err);
        }
    }

    public void reportError(NoViableAltException noViableAltException) {
        System.err.println("ANTLR Tree Parsing NoViableAltException Error: " + noViableAltException.toString());
        TNode.printTree(noViableAltException.node);
        noViableAltException.printStackTrace(System.err);
    }

    public void reportError(MismatchedTokenException mismatchedTokenException) {
        if (mismatchedTokenException != null) {
            TNode.printTree(mismatchedTokenException.node);
            System.err.println("ANTLR Tree Parsing MismatchedTokenException Error: " + mismatchedTokenException);
            mismatchedTokenException.printStackTrace(System.err);
        }
    }

    public void reportError(String string) {
        System.err.println("ANTLR Error from String: " + string);
    }

    public void reportWarning(String string) {
        System.err.println("ANTLR Warning from String: " + string);
    }

    protected void match(AST aST, int n) throws MismatchedTokenException {
        super.match(aST, n);
    }

    public void match(AST aST, BitSet bitSet) throws MismatchedTokenException {
        super.match(aST, bitSet);
    }

    protected void matchNot(AST aST, int n) throws MismatchedTokenException {
        super.matchNot(aST, n);
    }

    public void traceIn(String string, AST aST) {
        ++this.traceDepth;
        for (int i = 0; i < this.traceDepth; ++i) {
            System.out.print(" ");
        }
        super.traceIn(string, aST);
    }

    public void traceOut(String string, AST aST) {
        for (int i = 0; i < this.traceDepth; ++i) {
            System.out.print(" ");
        }
        super.traceOut(string, aST);
        --this.traceDepth;
    }

    public GnuCEmitter() {
        this.tokenNames = _tokenNames;
    }

    public final void translationUnit(AST aST) throws RecognitionException {
        TNode tNode;
        TNode tNode2 = tNode = aST == ASTNULL ? null : (TNode)aST;
        if (this.inputState.guessing == 0) {
            this.initializePrinting();
        }
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 5: 
            case 9: 
            case 113: 
            case 123: 
            case 136: {
                this.externalList(aST);
                aST = this._retTree;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        if (this.inputState.guessing == 0) {
            this.finalizePrinting();
        }
        this._retTree = aST;
    }

    public final void externalList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (!_tokenSet_0.member(aST.getType())) {
                    if (n < 1) {
                        throw new NoViableAltException(aST);
                    }
                    break;
                }
                this.externalDef(aST);
                aST = this._retTree;
                ++n;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void externalDef(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 113: {
                    this.declaration(aST);
                    aST = this._retTree;
                    break;
                }
                case 123: {
                    this.functionDef(aST);
                    aST = this._retTree;
                    break;
                }
                case 5: {
                    this.asm_expr(aST);
                    aST = this._retTree;
                    break;
                }
                case 136: {
                    this.typelessDeclaration(aST);
                    aST = this._retTree;
                    break;
                }
                case 9: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 9);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void declaration(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            TNode tNode3 = (TNode)aST;
            this.match(aST, 113);
            aST = aST.getFirstChild();
            this.declSpecifiers(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 110: {
                    this.initDeclList(aST);
                    aST = this._retTree;
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 9) {
                    tNode2 = (TNode)aST;
                    this.match(aST, 9);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                } else {
                    if (n >= 1) break;
                    throw new NoViableAltException(aST);
                }
                ++n;
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void functionDef(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            TNode tNode3 = (TNode)aST;
            this.match(aST, 123);
            aST = aST.getFirstChild();
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 6: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 109: 
                case 156: 
                case 157: 
                case 158: {
                    this.functionDeclSpecifiers(aST);
                    aST = this._retTree;
                    break;
                }
                case 111: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            this.declarator(aST);
            aST = this._retTree;
            block10: while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 113: {
                        this.declaration(aST);
                        aST = this._retTree;
                        continue block10;
                    }
                    case 47: {
                        tNode2 = (TNode)aST;
                        this.match(aST, 47);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing != 0) continue block10;
                        this.print(tNode2);
                        continue block10;
                    }
                }
                break;
            }
            this.compoundStatement(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void asm_expr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 5);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 6: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 6);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) break;
                    this.print(tNode3);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            tNode4 = (TNode)aST;
            this.match(aST, 7);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode4);
                ++this.tabs;
            }
            this.expr(aST);
            aST = this._retTree;
            tNode5 = (TNode)aST;
            this.match(aST, 8);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                --this.tabs;
                this.print(tNode5);
            }
            tNode6 = (TNode)aST;
            this.match(aST, 9);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode6);
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void typelessDeclaration(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            TNode tNode3 = (TNode)aST;
            this.match(aST, 136);
            aST = aST.getFirstChild();
            this.initDeclList(aST);
            aST = this._retTree;
            tNode2 = (TNode)aST;
            this.match(aST, 9);
            aST = aST.getNextSibling();
            aST = aST2;
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void initDeclList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            this.initDecl(aST);
            aST = this._retTree;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 110) {
                    if (this.inputState.guessing == 0) {
                        this.print(",");
                    }
                    this.initDecl(aST);
                    aST = this._retTree;
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void expr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 41: 
                case 42: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 126: {
                    this.binaryExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 70: {
                    this.conditionalExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 114: {
                    this.castExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 88: 
                case 89: 
                case 90: 
                case 127: 
                case 160: {
                    this.unaryExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 129: {
                    this.postfixExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 38: 
                case 95: 
                case 116: 
                case 131: 
                case 154: {
                    this.primaryExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 121: {
                    this.emptyExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 43: {
                    this.compoundStatementExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 119: 
                case 133: {
                    this.initializer(aST);
                    aST = this._retTree;
                    break;
                }
                case 130: {
                    this.rangeExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 135: {
                    this.gnuAsmExpr(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void declSpecifiers(AST aST) throws RecognitionException {
        block12: {
            TNode tNode = aST == ASTNULL ? null : (TNode)aST;
            try {
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 4: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 156: {
                            this.storageClassSpecifier(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 6: 
                        case 17: {
                            this.typeQualifier(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 109: 
                        case 157: 
                        case 158: {
                            this.typeSpecifier(aST);
                            aST = this._retTree;
                            break;
                        }
                        default: {
                            if (n < 1) {
                                throw new NoViableAltException(aST);
                            }
                            break block12;
                        }
                    }
                    ++n;
                }
            }
            catch (RecognitionException recognitionException) {
                if (this.inputState.guessing == 0) {
                    this.reportError(recognitionException);
                    if (aST != null) {
                        aST = aST.getNextSibling();
                    }
                }
                throw recognitionException;
            }
        }
        this._retTree = aST;
    }

    public final void storageClassSpecifier(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 13: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 13);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    break;
                }
                case 14: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 14);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    break;
                }
                case 4: {
                    tNode4 = (TNode)aST;
                    this.match(aST, 4);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode4);
                    }
                    break;
                }
                case 15: 
                case 16: 
                case 156: {
                    this.functionStorageClassSpecifier(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void typeQualifier(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 17: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 17);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    break;
                }
                case 6: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 6);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void typeSpecifier(AST aST) throws RecognitionException {
        block45: {
            TNode tNode = aST == ASTNULL ? null : (TNode)aST;
            TNode tNode2 = null;
            TNode tNode3 = null;
            TNode tNode4 = null;
            TNode tNode5 = null;
            TNode tNode6 = null;
            TNode tNode7 = null;
            TNode tNode8 = null;
            TNode tNode9 = null;
            TNode tNode10 = null;
            TNode tNode11 = null;
            TNode tNode12 = null;
            TNode tNode13 = null;
            TNode tNode14 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 18: {
                        tNode2 = (TNode)aST;
                        this.match(aST, 18);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode2);
                        }
                        break;
                    }
                    case 19: {
                        tNode3 = (TNode)aST;
                        this.match(aST, 19);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode3);
                        }
                        break;
                    }
                    case 20: {
                        tNode4 = (TNode)aST;
                        this.match(aST, 20);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode4);
                        }
                        break;
                    }
                    case 21: {
                        tNode5 = (TNode)aST;
                        this.match(aST, 21);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode5);
                        }
                        break;
                    }
                    case 22: {
                        tNode6 = (TNode)aST;
                        this.match(aST, 22);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode6);
                        }
                        break;
                    }
                    case 23: {
                        tNode7 = (TNode)aST;
                        this.match(aST, 23);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode7);
                        }
                        break;
                    }
                    case 24: {
                        tNode8 = (TNode)aST;
                        this.match(aST, 24);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode8);
                        }
                        break;
                    }
                    case 25: {
                        tNode9 = (TNode)aST;
                        this.match(aST, 25);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode9);
                        }
                        break;
                    }
                    case 26: {
                        tNode10 = (TNode)aST;
                        this.match(aST, 26);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode10);
                        }
                        break;
                    }
                    case 10: {
                        this.structSpecifier(aST);
                        aST = this._retTree;
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (aST.getType() == 134 || aST.getType() == 159) {
                                this.attributeDecl(aST);
                                aST = this._retTree;
                                continue;
                            }
                            break block45;
                            break;
                        }
                    }
                    case 11: {
                        this.unionSpecifier(aST);
                        aST = this._retTree;
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (aST.getType() == 134 || aST.getType() == 159) {
                                this.attributeDecl(aST);
                                aST = this._retTree;
                                continue;
                            }
                            break block45;
                            break;
                        }
                    }
                    case 12: {
                        this.enumSpecifier(aST);
                        aST = this._retTree;
                        break;
                    }
                    case 109: {
                        this.typedefName(aST);
                        aST = this._retTree;
                        break;
                    }
                    case 157: {
                        AST aST2 = aST;
                        tNode11 = aST == ASTNULL ? null : (TNode)aST;
                        this.match(aST, 157);
                        aST = aST.getFirstChild();
                        tNode12 = (TNode)aST;
                        this.match(aST, 43);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode11);
                            this.print(tNode12);
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 6: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 26: 
                            case 109: 
                            case 157: 
                            case 158: {
                                this.typeName(aST);
                                aST = this._retTree;
                                break;
                            }
                            case 38: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 95: 
                            case 114: 
                            case 116: 
                            case 119: 
                            case 121: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 133: 
                            case 135: 
                            case 154: 
                            case 160: {
                                this.expr(aST);
                                aST = this._retTree;
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        tNode13 = (TNode)aST;
                        this.match(aST, 44);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode13);
                        }
                        aST = aST2;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 158: {
                        tNode14 = (TNode)aST;
                        this.match(aST, 158);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode14);
                        }
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                if (this.inputState.guessing == 0) {
                    this.reportError(recognitionException);
                    if (aST != null) {
                        aST = aST.getNextSibling();
                    }
                }
                throw recognitionException;
            }
        }
        this._retTree = aST;
    }

    public final void functionStorageClassSpecifier(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 15: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 15);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    break;
                }
                case 16: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 16);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    break;
                }
                case 156: {
                    tNode4 = (TNode)aST;
                    this.match(aST, 156);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode4);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void structSpecifier(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 10);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            this.structOrUnionBody(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void attributeDecl(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 159: {
                    AST aST2 = aST;
                    tNode2 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 159);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() < 4 || aST.getType() > 162) break;
                        tNode3 = (TNode)aST;
                        if (aST == null) {
                            throw new MismatchedTokenException();
                        }
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing != 0) continue;
                        this.print(tNode3);
                    }
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 134: {
                    AST aST3 = aST;
                    tNode4 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 134);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode4);
                    }
                    tNode5 = (TNode)aST;
                    this.match(aST, 43);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode5);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(")");
                    }
                    tNode6 = (TNode)aST;
                    this.match(aST, 44);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode6);
                    }
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void unionSpecifier(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 11);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            this.structOrUnionBody(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void enumSpecifier(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 12);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 38: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) break;
                    this.print(tNode3);
                    break;
                }
                case 3: 
                case 7: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 7: {
                    tNode4 = (TNode)aST;
                    this.match(aST, 7);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode4);
                        ++this.tabs;
                    }
                    this.enumList(aST);
                    aST = this._retTree;
                    tNode5 = (TNode)aST;
                    this.match(aST, 8);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) break;
                    --this.tabs;
                    this.print(tNode5);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void typedefName(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            TNode tNode3 = (TNode)aST;
            this.match(aST, 109);
            aST = aST.getFirstChild();
            tNode2 = (TNode)aST;
            this.match(aST, 38);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void typeName(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            this.specifierQualifierList(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 118: {
                    this.nonemptyAbstractDeclarator(aST);
                    aST = this._retTree;
                    break;
                }
                case 44: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void structOrUnionBody(AST aST) throws RecognitionException {
        block26: {
            TNode tNode = aST == ASTNULL ? null : (TNode)aST;
            TNode tNode2 = null;
            TNode tNode3 = null;
            TNode tNode4 = null;
            TNode tNode5 = null;
            TNode tNode6 = null;
            TNode tNode7 = null;
            try {
                boolean bl = false;
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 38) {
                    AST aST2 = aST;
                    bl = true;
                    ++this.inputState.guessing;
                    try {
                        TNode tNode8 = (TNode)aST;
                        this.match(aST, 38);
                        aST = aST.getNextSibling();
                        TNode tNode9 = (TNode)aST;
                        this.match(aST, 7);
                        aST = aST.getNextSibling();
                    }
                    catch (RecognitionException recognitionException) {
                        bl = false;
                    }
                    aST = aST2;
                    --this.inputState.guessing;
                }
                if (bl) {
                    tNode2 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    tNode3 = (TNode)aST;
                    this.match(aST, 7);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                        this.print("{");
                        ++this.tabs;
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 6: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 109: 
                        case 157: 
                        case 158: {
                            this.structDeclarationList(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 8: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    tNode4 = (TNode)aST;
                    this.match(aST, 8);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        --this.tabs;
                        this.print(tNode4);
                    }
                    break block26;
                }
                if (aST.getType() == 7) {
                    tNode5 = (TNode)aST;
                    this.match(aST, 7);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode5);
                        ++this.tabs;
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 6: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 109: 
                        case 157: 
                        case 158: {
                            this.structDeclarationList(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 8: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    tNode6 = (TNode)aST;
                    this.match(aST, 8);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        --this.tabs;
                        this.print(tNode6);
                    }
                    break block26;
                }
                if (aST.getType() == 38) {
                    tNode7 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode7);
                    }
                    break block26;
                }
                throw new NoViableAltException(aST);
            }
            catch (RecognitionException recognitionException) {
                if (this.inputState.guessing == 0) {
                    this.reportError(recognitionException);
                    if (aST != null) {
                        aST = aST.getNextSibling();
                    }
                }
                throw recognitionException;
            }
        }
        this._retTree = aST;
    }

    public final void structDeclarationList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (!_tokenSet_1.member(aST.getType())) {
                    if (n < 1) {
                        throw new NoViableAltException(aST);
                    }
                    break;
                }
                this.structDeclaration(aST);
                aST = this._retTree;
                if (this.inputState.guessing == 0) {
                    this.print(";");
                }
                ++n;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void structDeclaration(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            this.specifierQualifierList(aST);
            aST = this._retTree;
            this.structDeclaratorList(aST);
            aST = this._retTree;
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void specifierQualifierList(AST aST) throws RecognitionException {
        block11: {
            TNode tNode = aST == ASTNULL ? null : (TNode)aST;
            try {
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 10: 
                        case 11: 
                        case 12: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 109: 
                        case 157: 
                        case 158: {
                            this.typeSpecifier(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 6: 
                        case 17: {
                            this.typeQualifier(aST);
                            aST = this._retTree;
                            break;
                        }
                        default: {
                            if (n < 1) {
                                throw new NoViableAltException(aST);
                            }
                            break block11;
                        }
                    }
                    ++n;
                }
            }
            catch (RecognitionException recognitionException) {
                if (this.inputState.guessing == 0) {
                    this.reportError(recognitionException);
                    if (aST != null) {
                        aST = aST.getNextSibling();
                    }
                }
                throw recognitionException;
            }
        }
        this._retTree = aST;
    }

    public final void structDeclaratorList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            this.structDeclarator(aST);
            aST = this._retTree;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 112) {
                    if (this.inputState.guessing == 0) {
                        this.print(",");
                    }
                    this.structDeclarator(aST);
                    aST = this._retTree;
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void structDeclarator(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            TNode tNode3 = (TNode)aST;
            this.match(aST, 112);
            aST = aST.getFirstChild();
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 111: {
                    this.declarator(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: 
                case 40: 
                case 134: 
                case 159: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 40: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 40);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: 
                case 134: 
                case 159: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() != 134 && aST.getType() != 159) break;
                this.attributeDecl(aST);
                aST = this._retTree;
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void declarator(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        TNode tNode7 = null;
        TNode tNode8 = null;
        try {
            AST aST2 = aST;
            TNode tNode9 = (TNode)aST;
            this.match(aST, 111);
            aST = aST.getFirstChild();
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 115: {
                    this.pointerGroup(aST);
                    aST = this._retTree;
                    break;
                }
                case 38: 
                case 43: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 38: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) break;
                    this.print(tNode2);
                    break;
                }
                case 43: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 43);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    this.declarator(aST);
                    aST = this._retTree;
                    tNode4 = (TNode)aST;
                    this.match(aST, 44);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) break;
                    this.print(tNode4);
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            block26: while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 122: {
                        AST aST3 = aST;
                        tNode5 = aST == ASTNULL ? null : (TNode)aST;
                        this.match(aST, 122);
                        aST = aST.getFirstChild();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode5);
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        block13 : switch (aST.getType()) {
                            case 125: {
                                this.parameterTypeList(aST);
                                aST = this._retTree;
                                break;
                            }
                            case 38: 
                            case 44: {
                                if (aST == null) {
                                    aST = ASTNULL;
                                }
                                switch (aST.getType()) {
                                    case 38: {
                                        this.idList(aST);
                                        aST = this._retTree;
                                        break block13;
                                    }
                                    case 44: {
                                        break block13;
                                    }
                                }
                                throw new NoViableAltException(aST);
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        tNode6 = (TNode)aST;
                        this.match(aST, 44);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode6);
                        }
                        aST = aST3;
                        aST = aST.getNextSibling();
                        continue block26;
                    }
                    case 45: {
                        tNode7 = (TNode)aST;
                        this.match(aST, 45);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode7);
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 38: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 95: 
                            case 114: 
                            case 116: 
                            case 119: 
                            case 121: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 133: 
                            case 135: 
                            case 154: 
                            case 160: {
                                this.expr(aST);
                                aST = this._retTree;
                                break;
                            }
                            case 46: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        tNode8 = (TNode)aST;
                        this.match(aST, 46);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing != 0) continue block26;
                        this.print(tNode8);
                        continue block26;
                    }
                }
                break;
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void enumList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            this.enumerator(aST);
            aST = this._retTree;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 38) {
                    if (this.inputState.guessing == 0) {
                        this.print(",");
                    }
                    this.enumerator(aST);
                    aST = this._retTree;
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void enumerator(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            tNode2 = (TNode)aST;
            this.match(aST, 38);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 41: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 41);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    break;
                }
                case 8: 
                case 38: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void initDecl(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        String string = "";
        try {
            AST aST2 = aST;
            TNode tNode4 = (TNode)aST;
            this.match(aST, 110);
            aST = aST.getFirstChild();
            this.declarator(aST);
            aST = this._retTree;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() != 134 && aST.getType() != 159) break;
                this.attributeDecl(aST);
                aST = this._retTree;
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 41: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 41);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    this.initializer(aST);
                    aST = this._retTree;
                    break;
                }
                case 40: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 40);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void initializer(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 119: {
                    AST aST2 = aST;
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 119);
                    aST = aST.getFirstChild();
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 132: {
                            this.initializerElementLabel(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 38: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 95: 
                        case 114: 
                        case 116: 
                        case 119: 
                        case 121: 
                        case 126: 
                        case 127: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 133: 
                        case 135: 
                        case 154: 
                        case 160: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 133: {
                    this.lcurlyInitializer(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void pointerGroup(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            TNode tNode3 = (TNode)aST;
            this.match(aST, 115);
            aST = aST.getFirstChild();
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 42) {
                    tNode2 = (TNode)aST;
                    this.match(aST, 42);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() == 6 || aST.getType() == 17) {
                            this.typeQualifier(aST);
                            aST = this._retTree;
                            continue;
                        }
                        break;
                    }
                } else {
                    if (n >= 1) break;
                    throw new NoViableAltException(aST);
                }
                ++n;
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void idList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        try {
            tNode2 = (TNode)aST;
            this.match(aST, 38);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 39) {
                    tNode3 = (TNode)aST;
                    this.match(aST, 39);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    tNode4 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) continue;
                    this.print(tNode4);
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void initializerElementLabel(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        TNode tNode7 = null;
        TNode tNode8 = null;
        TNode tNode9 = null;
        try {
            AST aST2 = aST;
            TNode tNode10 = (TNode)aST;
            this.match(aST, 132);
            aST = aST.getFirstChild();
            if (aST == null) {
                aST = ASTNULL;
            }
            block1 : switch (aST.getType()) {
                case 45: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 45);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    tNode3 = (TNode)aST;
                    this.match(aST, 46);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 41: {
                            tNode4 = (TNode)aST;
                            this.match(aST, 41);
                            aST = aST.getNextSibling();
                            if (this.inputState.guessing != 0) break block1;
                            this.print(tNode4);
                            break block1;
                        }
                        case 3: {
                            break block1;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                }
                case 38: {
                    tNode5 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    tNode6 = (TNode)aST;
                    this.match(aST, 40);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) break;
                    this.print(tNode5);
                    this.print(tNode6);
                    break;
                }
                case 94: {
                    tNode7 = (TNode)aST;
                    this.match(aST, 94);
                    aST = aST.getNextSibling();
                    tNode8 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    tNode9 = (TNode)aST;
                    this.match(aST, 41);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) break;
                    this.print(tNode7);
                    this.print(tNode8);
                    this.print(tNode9);
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void lcurlyInitializer(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 133);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
                ++this.tabs;
            }
            this.initializerList(aST);
            aST = this._retTree;
            tNode3 = (TNode)aST;
            this.match(aST, 8);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                --this.tabs;
                this.print(tNode3);
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void initializerList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 119 || aST.getType() == 133) {
                    tNode2 = aST == ASTNULL ? null : (TNode)aST;
                    this.initializer(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing != 0) continue;
                    this.commaSep(tNode2);
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void parameterTypeList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        try {
            int n = 0;
            while (true) {
                block22: {
                    block21: {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() != 125) break block21;
                        this.parameterDeclaration(aST);
                        aST = this._retTree;
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 39: {
                                tNode2 = (TNode)aST;
                                this.match(aST, 39);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing == 0) {
                                    this.print(tNode2);
                                }
                                break block22;
                            }
                            case 9: {
                                tNode3 = (TNode)aST;
                                this.match(aST, 9);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing == 0) {
                                    this.print(tNode3);
                                }
                                break block22;
                            }
                            case 44: 
                            case 47: 
                            case 125: {
                                break block22;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                    }
                    if (n >= 1) break;
                    throw new NoViableAltException(aST);
                }
                ++n;
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 47: {
                    tNode4 = (TNode)aST;
                    this.match(aST, 47);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode4);
                    }
                    break;
                }
                case 44: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void parameterDeclaration(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            AST aST2 = aST;
            TNode tNode2 = (TNode)aST;
            this.match(aST, 125);
            aST = aST.getFirstChild();
            this.declSpecifiers(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 111: {
                    this.declarator(aST);
                    aST = this._retTree;
                    break;
                }
                case 118: {
                    this.nonemptyAbstractDeclarator(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void nonemptyAbstractDeclarator(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        TNode tNode7 = null;
        TNode tNode8 = null;
        TNode tNode9 = null;
        try {
            AST aST2 = aST;
            TNode tNode10 = (TNode)aST;
            this.match(aST, 118);
            aST = aST.getFirstChild();
            if (aST == null) {
                aST = ASTNULL;
            }
            block1 : switch (aST.getType()) {
                case 115: {
                    this.pointerGroup(aST);
                    aST = this._retTree;
                    block32: while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 43: {
                                tNode2 = (TNode)aST;
                                this.match(aST, 43);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing == 0) {
                                    this.print(tNode2);
                                }
                                if (aST == null) {
                                    aST = ASTNULL;
                                }
                                switch (aST.getType()) {
                                    case 118: {
                                        this.nonemptyAbstractDeclarator(aST);
                                        aST = this._retTree;
                                        break;
                                    }
                                    case 125: {
                                        this.parameterTypeList(aST);
                                        aST = this._retTree;
                                        break;
                                    }
                                    case 44: {
                                        break;
                                    }
                                    default: {
                                        throw new NoViableAltException(aST);
                                    }
                                }
                                tNode3 = (TNode)aST;
                                this.match(aST, 44);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing != 0) continue block32;
                                this.print(tNode3);
                                continue block32;
                            }
                            case 45: {
                                tNode4 = (TNode)aST;
                                this.match(aST, 45);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing == 0) {
                                    this.print(tNode4);
                                }
                                if (aST == null) {
                                    aST = ASTNULL;
                                }
                                switch (aST.getType()) {
                                    case 38: 
                                    case 41: 
                                    case 42: 
                                    case 43: 
                                    case 60: 
                                    case 61: 
                                    case 62: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 76: 
                                    case 77: 
                                    case 78: 
                                    case 79: 
                                    case 80: 
                                    case 81: 
                                    case 82: 
                                    case 83: 
                                    case 84: 
                                    case 85: 
                                    case 86: 
                                    case 87: 
                                    case 88: 
                                    case 89: 
                                    case 90: 
                                    case 95: 
                                    case 114: 
                                    case 116: 
                                    case 119: 
                                    case 121: 
                                    case 126: 
                                    case 127: 
                                    case 129: 
                                    case 130: 
                                    case 131: 
                                    case 133: 
                                    case 135: 
                                    case 154: 
                                    case 160: {
                                        this.expr(aST);
                                        aST = this._retTree;
                                        break;
                                    }
                                    case 46: {
                                        break;
                                    }
                                    default: {
                                        throw new NoViableAltException(aST);
                                    }
                                }
                                tNode5 = (TNode)aST;
                                this.match(aST, 46);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing != 0) continue block32;
                                this.print(tNode5);
                                continue block32;
                            }
                        }
                        break;
                    }
                    break;
                }
                case 43: 
                case 45: {
                    int n = 0;
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 43: {
                                tNode6 = (TNode)aST;
                                this.match(aST, 43);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing == 0) {
                                    this.print(tNode6);
                                }
                                if (aST == null) {
                                    aST = ASTNULL;
                                }
                                switch (aST.getType()) {
                                    case 118: {
                                        this.nonemptyAbstractDeclarator(aST);
                                        aST = this._retTree;
                                        break;
                                    }
                                    case 125: {
                                        this.parameterTypeList(aST);
                                        aST = this._retTree;
                                        break;
                                    }
                                    case 44: {
                                        break;
                                    }
                                    default: {
                                        throw new NoViableAltException(aST);
                                    }
                                }
                                tNode7 = (TNode)aST;
                                this.match(aST, 44);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing != 0) break;
                                this.print(tNode7);
                                break;
                            }
                            case 45: {
                                tNode8 = (TNode)aST;
                                this.match(aST, 45);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing == 0) {
                                    this.print(tNode8);
                                }
                                if (aST == null) {
                                    aST = ASTNULL;
                                }
                                switch (aST.getType()) {
                                    case 38: 
                                    case 41: 
                                    case 42: 
                                    case 43: 
                                    case 60: 
                                    case 61: 
                                    case 62: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 76: 
                                    case 77: 
                                    case 78: 
                                    case 79: 
                                    case 80: 
                                    case 81: 
                                    case 82: 
                                    case 83: 
                                    case 84: 
                                    case 85: 
                                    case 86: 
                                    case 87: 
                                    case 88: 
                                    case 89: 
                                    case 90: 
                                    case 95: 
                                    case 114: 
                                    case 116: 
                                    case 119: 
                                    case 121: 
                                    case 126: 
                                    case 127: 
                                    case 129: 
                                    case 130: 
                                    case 131: 
                                    case 133: 
                                    case 135: 
                                    case 154: 
                                    case 160: {
                                        this.expr(aST);
                                        aST = this._retTree;
                                        break;
                                    }
                                    case 46: {
                                        break;
                                    }
                                    default: {
                                        throw new NoViableAltException(aST);
                                    }
                                }
                                tNode9 = (TNode)aST;
                                this.match(aST, 46);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing != 0) break;
                                this.print(tNode9);
                                break;
                            }
                            default: {
                                if (n >= 1) break block1;
                                throw new NoViableAltException(aST);
                            }
                        }
                        ++n;
                    }
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void functionDeclSpecifiers(AST aST) throws RecognitionException {
        block12: {
            TNode tNode = aST == ASTNULL ? null : (TNode)aST;
            try {
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 15: 
                        case 16: 
                        case 156: {
                            this.functionStorageClassSpecifier(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 6: 
                        case 17: {
                            this.typeQualifier(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 109: 
                        case 157: 
                        case 158: {
                            this.typeSpecifier(aST);
                            aST = this._retTree;
                            break;
                        }
                        default: {
                            if (n < 1) {
                                throw new NoViableAltException(aST);
                            }
                            break block12;
                        }
                    }
                    ++n;
                }
            }
            catch (RecognitionException recognitionException) {
                if (this.inputState.guessing == 0) {
                    this.reportError(recognitionException);
                    if (aST != null) {
                        aST = aST.getNextSibling();
                    }
                }
                throw recognitionException;
            }
        }
        this._retTree = aST;
    }

    public final void compoundStatement(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 124);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
                ++this.tabs;
            }
            block10: while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 113: 
                    case 155: {
                        this.declarationList(aST);
                        aST = this._retTree;
                        continue block10;
                    }
                    case 123: {
                        this.functionDef(aST);
                        aST = this._retTree;
                        continue block10;
                    }
                }
                break;
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 9: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 59: 
                case 120: 
                case 124: 
                case 128: {
                    this.statementList(aST);
                    aST = this._retTree;
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            tNode3 = (TNode)aST;
            this.match(aST, 8);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                --this.tabs;
                this.print(tNode3);
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void declarationList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 155) {
                    this.localLabelDecl(aST);
                    aST = this._retTree;
                } else {
                    if (aST.getType() != 113) {
                        if (n < 1) {
                            throw new NoViableAltException(aST);
                        }
                        break;
                    }
                    this.declaration(aST);
                    aST = this._retTree;
                }
                ++n;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void localLabelDecl(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 155);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 38) {
                    tNode3 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.commaSep(tNode3);
                    }
                } else {
                    if (n >= 1) break;
                    throw new NoViableAltException(aST);
                }
                ++n;
            }
            if (this.inputState.guessing == 0) {
                this.print(";");
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void statementList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (!_tokenSet_2.member(aST.getType())) {
                    if (n < 1) {
                        throw new NoViableAltException(aST);
                    }
                    break;
                }
                this.statement(aST);
                aST = this._retTree;
                ++n;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void statement(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            this.statementBody(aST);
            aST = this._retTree;
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void statementBody(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        TNode tNode7 = null;
        TNode tNode8 = null;
        TNode tNode9 = null;
        TNode tNode10 = null;
        TNode tNode11 = null;
        TNode tNode12 = null;
        TNode tNode13 = null;
        TNode tNode14 = null;
        TNode tNode15 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 9: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 9);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    break;
                }
                case 124: {
                    this.compoundStatement(aST);
                    aST = this._retTree;
                    break;
                }
                case 120: {
                    AST aST2 = aST;
                    TNode tNode16 = (TNode)aST;
                    this.match(aST, 120);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(";");
                    }
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 48: {
                    AST aST3 = aST;
                    tNode3 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 48);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                        this.print("(");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(")");
                    }
                    this.statement(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 49: {
                    AST aST4 = aST;
                    tNode4 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 49);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode4);
                    }
                    this.statement(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(" while ( ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(" );");
                    }
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                case 50: {
                    AST aST5 = aST;
                    tNode5 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 50);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode5);
                        this.print("(");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(";");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(";");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(")");
                    }
                    this.statement(aST);
                    aST = this._retTree;
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 51: {
                    AST aST6 = aST;
                    tNode6 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 51);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode6);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(";");
                    }
                    aST = aST6;
                    aST = aST.getNextSibling();
                    break;
                }
                case 52: {
                    tNode7 = (TNode)aST;
                    this.match(aST, 52);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode7);
                        this.print(";");
                    }
                    break;
                }
                case 53: {
                    tNode8 = (TNode)aST;
                    this.match(aST, 53);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode8);
                        this.print(";");
                    }
                    break;
                }
                case 54: {
                    AST aST7 = aST;
                    tNode9 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 54);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode9);
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 38: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 95: 
                        case 114: 
                        case 116: 
                        case 119: 
                        case 121: 
                        case 126: 
                        case 127: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 133: 
                        case 135: 
                        case 154: 
                        case 160: {
                            this.expr(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    if (this.inputState.guessing == 0) {
                        this.print(";");
                    }
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                case 128: {
                    AST aST8 = aST;
                    TNode tNode17 = (TNode)aST;
                    this.match(aST, 128);
                    aST = aST.getFirstChild();
                    tNode10 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode10);
                        this.print(":");
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 9: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 59: 
                        case 120: 
                        case 124: 
                        case 128: {
                            this.statement(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    aST = aST8;
                    aST = aST.getNextSibling();
                    break;
                }
                case 55: {
                    AST aST9 = aST;
                    tNode11 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 55);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode11);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(":");
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 9: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 59: 
                        case 120: 
                        case 124: 
                        case 128: {
                            this.statement(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    aST = aST9;
                    aST = aST.getNextSibling();
                    break;
                }
                case 56: {
                    AST aST10 = aST;
                    tNode12 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 56);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode12);
                        this.print(":");
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 9: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 59: 
                        case 120: 
                        case 124: 
                        case 128: {
                            this.statement(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    aST = aST10;
                    aST = aST.getNextSibling();
                    break;
                }
                case 57: {
                    AST aST11 = aST;
                    tNode13 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 57);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode13);
                        this.print("(");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(")");
                    }
                    this.statement(aST);
                    aST = this._retTree;
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 58: {
                            tNode14 = (TNode)aST;
                            this.match(aST, 58);
                            aST = aST.getNextSibling();
                            if (this.inputState.guessing == 0) {
                                this.print(tNode14);
                            }
                            this.statement(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    aST = aST11;
                    aST = aST.getNextSibling();
                    break;
                }
                case 59: {
                    AST aST12 = aST;
                    tNode15 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 59);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode15);
                        this.print("(");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(")");
                    }
                    this.statement(aST);
                    aST = this._retTree;
                    aST = aST12;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void binaryExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.binaryOperator(aST);
            aST = this._retTree;
            if (this.inputState.guessing == 0) {
                TNode tNode3 = (TNode)tNode2.getFirstChild();
                TNode tNode4 = (TNode)tNode3.getNextSibling();
                this.expr((AST)tNode3);
                this.print(tNode2);
                this.expr((AST)tNode4);
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void conditionalExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 70);
            aST = aST.getFirstChild();
            this.expr(aST);
            aST = this._retTree;
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 38: 
                case 41: 
                case 42: 
                case 43: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 114: 
                case 116: 
                case 119: 
                case 121: 
                case 126: 
                case 127: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 135: 
                case 154: 
                case 160: {
                    this.expr(aST);
                    aST = this._retTree;
                    break;
                }
                case 40: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            tNode3 = (TNode)aST;
            this.match(aST, 40);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode3);
            }
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void castExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 114);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            this.typeName(aST);
            aST = this._retTree;
            tNode3 = (TNode)aST;
            this.match(aST, 44);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode3);
            }
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void unaryExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        TNode tNode7 = null;
        TNode tNode8 = null;
        TNode tNode9 = null;
        TNode tNode10 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 88: {
                    AST aST2 = aST;
                    tNode2 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 88);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 89: {
                    AST aST3 = aST;
                    tNode3 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 89);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 127: {
                    AST aST4 = aST;
                    TNode tNode11 = (TNode)aST;
                    this.match(aST, 127);
                    aST = aST.getFirstChild();
                    tNode4 = aST == ASTNULL ? null : (TNode)aST;
                    this.unaryOperator(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(tNode4);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                case 90: {
                    AST aST5 = aST;
                    tNode5 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 90);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode5);
                    }
                    boolean bl = false;
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (aST.getType() == 43) {
                        AST aST6 = aST;
                        bl = true;
                        ++this.inputState.guessing;
                        try {
                            TNode tNode12 = (TNode)aST;
                            this.match(aST, 43);
                            aST = aST.getNextSibling();
                            this.typeName(aST);
                            aST = this._retTree;
                        }
                        catch (RecognitionException recognitionException) {
                            bl = false;
                        }
                        aST = aST6;
                        --this.inputState.guessing;
                    }
                    if (bl) {
                        tNode6 = (TNode)aST;
                        this.match(aST, 43);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode6);
                        }
                        this.typeName(aST);
                        aST = this._retTree;
                        tNode7 = (TNode)aST;
                        this.match(aST, 44);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode7);
                        }
                    } else if (_tokenSet_3.member(aST.getType())) {
                        this.expr(aST);
                        aST = this._retTree;
                    } else {
                        throw new NoViableAltException(aST);
                    }
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 160: {
                    AST aST7 = aST;
                    tNode8 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 160);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode8);
                    }
                    boolean bl = false;
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (aST.getType() == 43) {
                        AST aST8 = aST;
                        bl = true;
                        ++this.inputState.guessing;
                        try {
                            TNode tNode13 = (TNode)aST;
                            this.match(aST, 43);
                            aST = aST.getNextSibling();
                            this.typeName(aST);
                            aST = this._retTree;
                        }
                        catch (RecognitionException recognitionException) {
                            bl = false;
                        }
                        aST = aST8;
                        --this.inputState.guessing;
                    }
                    if (bl) {
                        tNode9 = (TNode)aST;
                        this.match(aST, 43);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode9);
                        }
                        this.typeName(aST);
                        aST = this._retTree;
                        tNode10 = (TNode)aST;
                        this.match(aST, 44);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode10);
                        }
                    } else if (_tokenSet_3.member(aST.getType())) {
                        this.expr(aST);
                        aST = this._retTree;
                    } else {
                        throw new NoViableAltException(aST);
                    }
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void postfixExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        TNode tNode7 = null;
        TNode tNode8 = null;
        TNode tNode9 = null;
        TNode tNode10 = null;
        TNode tNode11 = null;
        try {
            AST aST2 = aST;
            TNode tNode12 = (TNode)aST;
            this.match(aST, 129);
            aST = aST.getFirstChild();
            this.primaryExpr(aST);
            aST = this._retTree;
            int n = 0;
            block14: while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 93: {
                        tNode2 = (TNode)aST;
                        this.match(aST, 93);
                        aST = aST.getNextSibling();
                        tNode3 = (TNode)aST;
                        this.match(aST, 38);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing != 0) break;
                        this.print(tNode2);
                        this.print(tNode3);
                        break;
                    }
                    case 94: {
                        tNode4 = (TNode)aST;
                        this.match(aST, 94);
                        aST = aST.getNextSibling();
                        tNode5 = (TNode)aST;
                        this.match(aST, 38);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing != 0) break;
                        this.print(tNode4);
                        this.print(tNode5);
                        break;
                    }
                    case 117: {
                        AST aST3 = aST;
                        tNode6 = aST == ASTNULL ? null : (TNode)aST;
                        this.match(aST, 117);
                        aST = aST.getFirstChild();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode6);
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 38: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 95: 
                            case 114: 
                            case 116: 
                            case 119: 
                            case 121: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 133: 
                            case 135: 
                            case 154: 
                            case 160: {
                                this.argExprList(aST);
                                aST = this._retTree;
                                break;
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        tNode7 = (TNode)aST;
                        this.match(aST, 44);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode7);
                        }
                        aST = aST3;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 45: {
                        tNode8 = (TNode)aST;
                        this.match(aST, 45);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode8);
                        }
                        this.expr(aST);
                        aST = this._retTree;
                        tNode9 = (TNode)aST;
                        this.match(aST, 46);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing != 0) break;
                        this.print(tNode9);
                        break;
                    }
                    case 88: {
                        tNode10 = (TNode)aST;
                        this.match(aST, 88);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing != 0) break;
                        this.print(tNode10);
                        break;
                    }
                    case 89: {
                        tNode11 = (TNode)aST;
                        this.match(aST, 89);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing != 0) break;
                        this.print(tNode11);
                        break;
                    }
                    default: {
                        if (n >= 1) break block14;
                        throw new NoViableAltException(aST);
                    }
                }
                ++n;
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void primaryExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 38: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 38);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    break;
                }
                case 154: {
                    tNode3 = (TNode)aST;
                    this.match(aST, 154);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    break;
                }
                case 95: {
                    this.charConst(aST);
                    aST = this._retTree;
                    break;
                }
                case 131: {
                    this.stringConst(aST);
                    aST = this._retTree;
                    break;
                }
                case 116: {
                    AST aST2 = aST;
                    tNode4 = aST == ASTNULL ? null : (TNode)aST;
                    this.match(aST, 116);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode4);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.print(")");
                    }
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void emptyExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            TNode tNode2 = (TNode)aST;
            this.match(aST, 121);
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void compoundStatementExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            AST aST2 = aST;
            tNode2 = aST == ASTNULL ? null : (TNode)aST;
            this.match(aST, 43);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            this.compoundStatement(aST);
            aST = this._retTree;
            tNode3 = (TNode)aST;
            this.match(aST, 44);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode3);
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void rangeExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            TNode tNode3 = (TNode)aST;
            this.match(aST, 130);
            aST = aST.getFirstChild();
            this.expr(aST);
            aST = this._retTree;
            tNode2 = (TNode)aST;
            this.match(aST, 47);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void gnuAsmExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        TNode tNode4 = null;
        TNode tNode5 = null;
        TNode tNode6 = null;
        TNode tNode7 = null;
        TNode tNode8 = null;
        TNode tNode9 = null;
        TNode tNode10 = null;
        TNode tNode11 = null;
        try {
            AST aST2;
            block44: {
                block45: {
                    block46: {
                        aST2 = aST;
                        tNode2 = aST == ASTNULL ? null : (TNode)aST;
                        this.match(aST, 135);
                        aST = aST.getFirstChild();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode2);
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 6: {
                                tNode3 = (TNode)aST;
                                this.match(aST, 6);
                                aST = aST.getNextSibling();
                                if (this.inputState.guessing != 0) break;
                                this.print(tNode3);
                                break;
                            }
                            case 43: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        tNode4 = (TNode)aST;
                        this.match(aST, 43);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode4);
                        }
                        this.stringConst(aST);
                        aST = this._retTree;
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() != 40) break block45;
                        tNode5 = (TNode)aST;
                        this.match(aST, 40);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode5);
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        block5 : switch (aST.getType()) {
                            case 131: {
                                this.strOptExprPair(aST);
                                aST = this._retTree;
                                while (true) {
                                    if (aST == null) {
                                        aST = ASTNULL;
                                    }
                                    if (aST.getType() != 39) break block5;
                                    tNode6 = (TNode)aST;
                                    this.match(aST, 39);
                                    aST = aST.getNextSibling();
                                    if (this.inputState.guessing == 0) {
                                        this.print(tNode6);
                                    }
                                    this.strOptExprPair(aST);
                                    aST = this._retTree;
                                }
                            }
                            case 40: 
                            case 44: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() != 40) break block46;
                        tNode7 = (TNode)aST;
                        this.match(aST, 40);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode7);
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 131: {
                                this.strOptExprPair(aST);
                                aST = this._retTree;
                                while (true) {
                                    if (aST == null) {
                                        aST = ASTNULL;
                                    }
                                    if (aST.getType() == 39) {
                                        tNode8 = (TNode)aST;
                                        this.match(aST, 39);
                                        aST = aST.getNextSibling();
                                        if (this.inputState.guessing == 0) {
                                            this.print(tNode8);
                                        }
                                        this.strOptExprPair(aST);
                                        aST = this._retTree;
                                        continue;
                                    }
                                    break block44;
                                    break;
                                }
                            }
                            case 40: 
                            case 44: {
                                break block44;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                    }
                    if (aST.getType() != 40 && aST.getType() != 44) {
                        throw new NoViableAltException(aST);
                    }
                    break block44;
                }
                if (aST.getType() != 40 && aST.getType() != 44) {
                    throw new NoViableAltException(aST);
                }
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            block13 : switch (aST.getType()) {
                case 40: {
                    tNode9 = (TNode)aST;
                    this.match(aST, 40);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode9);
                    }
                    this.stringConst(aST);
                    aST = this._retTree;
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() != 39) break block13;
                        tNode10 = (TNode)aST;
                        this.match(aST, 39);
                        aST = aST.getNextSibling();
                        if (this.inputState.guessing == 0) {
                            this.print(tNode10);
                        }
                        this.stringConst(aST);
                        aST = this._retTree;
                    }
                }
                case 44: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            tNode11 = (TNode)aST;
            this.match(aST, 44);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode11);
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    protected final void stringConst(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            AST aST2 = aST;
            TNode tNode3 = (TNode)aST;
            this.match(aST, 131);
            aST = aST.getFirstChild();
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 96) {
                    tNode2 = (TNode)aST;
                    this.match(aST, 96);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                } else {
                    if (n >= 1) break;
                    throw new NoViableAltException(aST);
                }
                ++n;
            }
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void strOptExprPair(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        TNode tNode3 = null;
        try {
            this.stringConst(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 43: {
                    tNode2 = (TNode)aST;
                    this.match(aST, 43);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode2);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    tNode3 = (TNode)aST;
                    this.match(aST, 44);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.print(tNode3);
                    }
                    break;
                }
                case 39: 
                case 40: 
                case 44: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void binaryOperator(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 41: {
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 41);
                    aST = aST.getNextSibling();
                    break;
                }
                case 60: {
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 60);
                    aST = aST.getNextSibling();
                    break;
                }
                case 61: {
                    TNode tNode4 = (TNode)aST;
                    this.match(aST, 61);
                    aST = aST.getNextSibling();
                    break;
                }
                case 62: {
                    TNode tNode5 = (TNode)aST;
                    this.match(aST, 62);
                    aST = aST.getNextSibling();
                    break;
                }
                case 63: {
                    TNode tNode6 = (TNode)aST;
                    this.match(aST, 63);
                    aST = aST.getNextSibling();
                    break;
                }
                case 64: {
                    TNode tNode7 = (TNode)aST;
                    this.match(aST, 64);
                    aST = aST.getNextSibling();
                    break;
                }
                case 65: {
                    TNode tNode8 = (TNode)aST;
                    this.match(aST, 65);
                    aST = aST.getNextSibling();
                    break;
                }
                case 66: {
                    TNode tNode9 = (TNode)aST;
                    this.match(aST, 66);
                    aST = aST.getNextSibling();
                    break;
                }
                case 67: {
                    TNode tNode10 = (TNode)aST;
                    this.match(aST, 67);
                    aST = aST.getNextSibling();
                    break;
                }
                case 68: {
                    TNode tNode11 = (TNode)aST;
                    this.match(aST, 68);
                    aST = aST.getNextSibling();
                    break;
                }
                case 69: {
                    TNode tNode12 = (TNode)aST;
                    this.match(aST, 69);
                    aST = aST.getNextSibling();
                    break;
                }
                case 71: {
                    TNode tNode13 = (TNode)aST;
                    this.match(aST, 71);
                    aST = aST.getNextSibling();
                    break;
                }
                case 72: {
                    TNode tNode14 = (TNode)aST;
                    this.match(aST, 72);
                    aST = aST.getNextSibling();
                    break;
                }
                case 73: {
                    TNode tNode15 = (TNode)aST;
                    this.match(aST, 73);
                    aST = aST.getNextSibling();
                    break;
                }
                case 74: {
                    TNode tNode16 = (TNode)aST;
                    this.match(aST, 74);
                    aST = aST.getNextSibling();
                    break;
                }
                case 75: {
                    TNode tNode17 = (TNode)aST;
                    this.match(aST, 75);
                    aST = aST.getNextSibling();
                    break;
                }
                case 76: {
                    TNode tNode18 = (TNode)aST;
                    this.match(aST, 76);
                    aST = aST.getNextSibling();
                    break;
                }
                case 77: {
                    TNode tNode19 = (TNode)aST;
                    this.match(aST, 77);
                    aST = aST.getNextSibling();
                    break;
                }
                case 78: {
                    TNode tNode20 = (TNode)aST;
                    this.match(aST, 78);
                    aST = aST.getNextSibling();
                    break;
                }
                case 79: {
                    TNode tNode21 = (TNode)aST;
                    this.match(aST, 79);
                    aST = aST.getNextSibling();
                    break;
                }
                case 80: {
                    TNode tNode22 = (TNode)aST;
                    this.match(aST, 80);
                    aST = aST.getNextSibling();
                    break;
                }
                case 81: {
                    TNode tNode23 = (TNode)aST;
                    this.match(aST, 81);
                    aST = aST.getNextSibling();
                    break;
                }
                case 82: {
                    TNode tNode24 = (TNode)aST;
                    this.match(aST, 82);
                    aST = aST.getNextSibling();
                    break;
                }
                case 83: {
                    TNode tNode25 = (TNode)aST;
                    this.match(aST, 83);
                    aST = aST.getNextSibling();
                    break;
                }
                case 84: {
                    TNode tNode26 = (TNode)aST;
                    this.match(aST, 84);
                    aST = aST.getNextSibling();
                    break;
                }
                case 85: {
                    TNode tNode27 = (TNode)aST;
                    this.match(aST, 85);
                    aST = aST.getNextSibling();
                    break;
                }
                case 42: {
                    TNode tNode28 = (TNode)aST;
                    this.match(aST, 42);
                    aST = aST.getNextSibling();
                    break;
                }
                case 86: {
                    TNode tNode29 = (TNode)aST;
                    this.match(aST, 86);
                    aST = aST.getNextSibling();
                    break;
                }
                case 87: {
                    TNode tNode30 = (TNode)aST;
                    this.match(aST, 87);
                    aST = aST.getNextSibling();
                    break;
                }
                case 126: {
                    TNode tNode31 = (TNode)aST;
                    this.match(aST, 126);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void unaryOperator(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 75: {
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 75);
                    aST = aST.getNextSibling();
                    break;
                }
                case 42: {
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 42);
                    aST = aST.getNextSibling();
                    break;
                }
                case 84: {
                    TNode tNode4 = (TNode)aST;
                    this.match(aST, 84);
                    aST = aST.getNextSibling();
                    break;
                }
                case 85: {
                    TNode tNode5 = (TNode)aST;
                    this.match(aST, 85);
                    aST = aST.getNextSibling();
                    break;
                }
                case 91: {
                    TNode tNode6 = (TNode)aST;
                    this.match(aST, 91);
                    aST = aST.getNextSibling();
                    break;
                }
                case 92: {
                    TNode tNode7 = (TNode)aST;
                    this.match(aST, 92);
                    aST = aST.getNextSibling();
                    break;
                }
                case 72: {
                    TNode tNode8 = (TNode)aST;
                    this.match(aST, 72);
                    aST = aST.getNextSibling();
                    break;
                }
                case 161: {
                    TNode tNode9 = (TNode)aST;
                    this.match(aST, 161);
                    aST = aST.getNextSibling();
                    break;
                }
                case 162: {
                    TNode tNode10 = (TNode)aST;
                    this.match(aST, 162);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void argExprList(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            this.expr(aST);
            aST = this._retTree;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (_tokenSet_3.member(aST.getType())) {
                    if (this.inputState.guessing == 0) {
                        this.print(",");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    protected final void charConst(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        TNode tNode2 = null;
        try {
            tNode2 = (TNode)aST;
            this.match(aST, 95);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.print(tNode2);
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    protected final void intConst(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 97: {
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 97);
                    aST = aST.getNextSibling();
                    break;
                }
                case 98: {
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 98);
                    aST = aST.getNextSibling();
                    break;
                }
                case 99: {
                    TNode tNode4 = (TNode)aST;
                    this.match(aST, 99);
                    aST = aST.getNextSibling();
                    break;
                }
                case 100: {
                    TNode tNode5 = (TNode)aST;
                    this.match(aST, 100);
                    aST = aST.getNextSibling();
                    break;
                }
                case 101: {
                    TNode tNode6 = (TNode)aST;
                    this.match(aST, 101);
                    aST = aST.getNextSibling();
                    break;
                }
                case 102: {
                    TNode tNode7 = (TNode)aST;
                    this.match(aST, 102);
                    aST = aST.getNextSibling();
                    break;
                }
                case 103: {
                    TNode tNode8 = (TNode)aST;
                    this.match(aST, 103);
                    aST = aST.getNextSibling();
                    break;
                }
                case 104: {
                    TNode tNode9 = (TNode)aST;
                    this.match(aST, 104);
                    aST = aST.getNextSibling();
                    break;
                }
                case 105: {
                    TNode tNode10 = (TNode)aST;
                    this.match(aST, 105);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    protected final void floatConst(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 106: {
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 106);
                    aST = aST.getNextSibling();
                    break;
                }
                case 107: {
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 107);
                    aST = aST.getNextSibling();
                    break;
                }
                case 108: {
                    TNode tNode4 = (TNode)aST;
                    this.match(aST, 108);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void commaExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            AST aST2 = aST;
            TNode tNode2 = (TNode)aST;
            this.match(aST, 126);
            aST = aST.getFirstChild();
            this.expr(aST);
            aST = this._retTree;
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void assignExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 41: {
                    AST aST2 = aST;
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 41);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 60: {
                    AST aST3 = aST;
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 60);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 61: {
                    AST aST4 = aST;
                    TNode tNode4 = (TNode)aST;
                    this.match(aST, 61);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                case 62: {
                    AST aST5 = aST;
                    TNode tNode5 = (TNode)aST;
                    this.match(aST, 62);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 63: {
                    AST aST6 = aST;
                    TNode tNode6 = (TNode)aST;
                    this.match(aST, 63);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST6;
                    aST = aST.getNextSibling();
                    break;
                }
                case 64: {
                    AST aST7 = aST;
                    TNode tNode7 = (TNode)aST;
                    this.match(aST, 64);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                case 65: {
                    AST aST8 = aST;
                    TNode tNode8 = (TNode)aST;
                    this.match(aST, 65);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST8;
                    aST = aST.getNextSibling();
                    break;
                }
                case 66: {
                    AST aST9 = aST;
                    TNode tNode9 = (TNode)aST;
                    this.match(aST, 66);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST9;
                    aST = aST.getNextSibling();
                    break;
                }
                case 67: {
                    AST aST10 = aST;
                    TNode tNode10 = (TNode)aST;
                    this.match(aST, 67);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST10;
                    aST = aST.getNextSibling();
                    break;
                }
                case 68: {
                    AST aST11 = aST;
                    TNode tNode11 = (TNode)aST;
                    this.match(aST, 68);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST11;
                    aST = aST.getNextSibling();
                    break;
                }
                case 69: {
                    AST aST12 = aST;
                    TNode tNode12 = (TNode)aST;
                    this.match(aST, 69);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST12;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void logicalOrExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            AST aST2 = aST;
            TNode tNode2 = (TNode)aST;
            this.match(aST, 71);
            aST = aST.getFirstChild();
            this.expr(aST);
            aST = this._retTree;
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void logicalAndExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            AST aST2 = aST;
            TNode tNode2 = (TNode)aST;
            this.match(aST, 72);
            aST = aST.getFirstChild();
            this.expr(aST);
            aST = this._retTree;
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void inclusiveOrExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            AST aST2 = aST;
            TNode tNode2 = (TNode)aST;
            this.match(aST, 73);
            aST = aST.getFirstChild();
            this.expr(aST);
            aST = this._retTree;
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void exclusiveOrExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            AST aST2 = aST;
            TNode tNode2 = (TNode)aST;
            this.match(aST, 74);
            aST = aST.getFirstChild();
            this.expr(aST);
            aST = this._retTree;
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void bitAndExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            AST aST2 = aST;
            TNode tNode2 = (TNode)aST;
            this.match(aST, 75);
            aST = aST.getFirstChild();
            this.expr(aST);
            aST = this._retTree;
            this.expr(aST);
            aST = this._retTree;
            aST = aST2;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void equalityExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 76: {
                    AST aST2 = aST;
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 76);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 77: {
                    AST aST3 = aST;
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 77);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void relationalExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 78: {
                    AST aST2 = aST;
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 78);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 79: {
                    AST aST3 = aST;
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 79);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 80: {
                    AST aST4 = aST;
                    TNode tNode4 = (TNode)aST;
                    this.match(aST, 80);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                case 81: {
                    AST aST5 = aST;
                    TNode tNode5 = (TNode)aST;
                    this.match(aST, 81);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void shiftExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 82: {
                    AST aST2 = aST;
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 82);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 83: {
                    AST aST3 = aST;
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 83);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void additiveExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 84: {
                    AST aST2 = aST;
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 84);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 85: {
                    AST aST3 = aST;
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 85);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void multExpr(AST aST) throws RecognitionException {
        TNode tNode = aST == ASTNULL ? null : (TNode)aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 42: {
                    AST aST2 = aST;
                    TNode tNode2 = (TNode)aST;
                    this.match(aST, 42);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST2;
                    aST = aST.getNextSibling();
                    break;
                }
                case 86: {
                    AST aST3 = aST;
                    TNode tNode3 = (TNode)aST;
                    this.match(aST, 86);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 87: {
                    AST aST4 = aST;
                    TNode tNode4 = (TNode)aST;
                    this.match(aST, 87);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[]{544L, 0x802000000000000L, 256L, 0L, 0L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_1() {
        long[] lArray = new long[]{134093888L, 0x200000000000L, 0x60000000L, 0L, 0L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_2() {
        long[] lArray = new long[]{864409653478425088L, 0x1100000000000000L, 1L, 0L, 0L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_3() {
        long[] lArray = new long[]{-1152905836566151168L, -4425912531516653569L, 4362076334L, 0L, 0L, 0L};
        return lArray;
    }
}

