/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import com.jogamp.gluegen.cgram.CToken;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;

public class TNode
extends CommonAST {
    protected int ttype;
    protected String text;
    protected int lineNum = 0;
    protected TNode defNode;
    protected TNode up;
    protected TNode left;
    protected boolean marker = false;
    protected Hashtable attributes = null;
    static String tokenVocabulary;

    public static void setTokenVocabulary(String string) {
        tokenVocabulary = string;
    }

    public void initialize(Token token) {
        CToken cToken = (CToken)token;
        this.setText(cToken.getText());
        this.setType(cToken.getType());
        this.setLineNum(cToken.getLine());
        this.setAttribute("source", cToken.getSource());
        this.setAttribute("tokenNumber", new Integer(cToken.getTokenNumber()));
    }

    public void initialize(AST aST) {
        TNode tNode = (TNode)aST;
        this.setText(tNode.getText());
        this.setType(tNode.getType());
        this.setLineNum(tNode.getLineNum());
        this.setDefNode(tNode.getDefNode());
        this.attributes = tNode.getAttributesTable();
    }

    public int getType() {
        return this.ttype;
    }

    public void setType(int n) {
        this.ttype = n;
    }

    public boolean getMarker() {
        return this.marker;
    }

    public void setMarker(boolean bl) {
        this.marker = bl;
    }

    public Hashtable getAttributesTable() {
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        return this.attributes;
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public int getLineNum() {
        if (this.lineNum != 0) {
            return this.lineNum;
        }
        if (this.down == null) {
            return this.lineNum;
        }
        return ((TNode)this.down).getLocalLineNum();
    }

    public int getLocalLineNum() {
        if (this.lineNum != 0) {
            return this.lineNum;
        }
        if (this.down == null) {
            if (this.right == null) {
                return this.lineNum;
            }
            return ((TNode)this.right).getLocalLineNum();
        }
        return ((TNode)this.down).getLocalLineNum();
    }

    public void setLineNum(int n) {
        this.lineNum = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getAllChildrenText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getText());
        for (TNode tNode = (TNode)this.getFirstChild(); tNode != null; tNode = (TNode)tNode.getNextSibling()) {
            stringBuffer.append(tNode.getText());
        }
        return stringBuffer.toString();
    }

    public TNode getLastChild() {
        TNode tNode = (TNode)this.getFirstChild();
        if (tNode != null) {
            return tNode.getLastSibling();
        }
        return null;
    }

    public TNode getLastSibling() {
        TNode tNode = (TNode)this.getNextSibling();
        if (tNode != null) {
            return tNode.getLastSibling();
        }
        return this;
    }

    public TNode getFirstSibling() {
        TNode tNode = this.left;
        if (tNode != null) {
            return tNode.getFirstSibling();
        }
        return this;
    }

    public TNode getParent() {
        return this.getFirstSibling().up;
    }

    public void addSibling(AST aST) {
        if (aST == null) {
            return;
        }
        TNode tNode = (TNode)this.right;
        this.right = (TNode)aST;
        ((TNode)aST).left = this;
        TNode tNode2 = ((TNode)aST).getLastSibling();
        tNode2.right = tNode;
        if (tNode != null) {
            tNode.left = tNode2;
        }
    }

    public int numberOfChildren() {
        int n = 0;
        for (AST aST = this.getFirstChild(); aST != null; aST = aST.getNextSibling()) {
            ++n;
        }
        return n;
    }

    public void removeSelf() {
        TNode tNode = this.up;
        TNode tNode2 = this.left;
        TNode tNode3 = (TNode)this.right;
        if (tNode != null) {
            tNode.down = tNode3;
            if (tNode3 != null) {
                tNode3.up = tNode;
                tNode3.left = tNode2;
            }
        } else {
            if (tNode2 != null) {
                tNode2.right = tNode3;
            }
            if (tNode3 != null) {
                tNode3.left = tNode2;
            }
        }
    }

    public TNode getDefNode() {
        return this.defNode;
    }

    public void setDefNode(TNode tNode) {
        this.defNode = tNode;
    }

    public TNode deepCopy() {
        TNode tNode = new TNode();
        tNode.ttype = this.ttype;
        tNode.text = this.text;
        tNode.lineNum = this.lineNum;
        tNode.defNode = this.defNode;
        if (this.attributes != null) {
            tNode.attributes = (Hashtable)this.attributes.clone();
        }
        if (this.down != null) {
            tNode.down = ((TNode)this.down).deepCopyWithRightSiblings();
        }
        tNode.doubleLink();
        return tNode;
    }

    public TNode deepCopyWithRightSiblings() {
        TNode tNode = new TNode();
        tNode.ttype = this.ttype;
        tNode.text = this.text;
        tNode.lineNum = this.lineNum;
        tNode.defNode = this.defNode;
        if (this.attributes != null) {
            tNode.attributes = (Hashtable)this.attributes.clone();
        }
        if (this.down != null) {
            tNode.down = ((TNode)this.down).deepCopyWithRightSiblings();
        }
        if (this.right != null) {
            tNode.right = ((TNode)this.right).deepCopyWithRightSiblings();
        }
        tNode.doubleLink();
        return tNode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(TNode.getNameForType(this.getType()) + "[" + this.getText() + ", " + "]");
        if (this.getLineNum() != 0) {
            stringBuffer.append(" line:" + this.getLineNum());
        }
        Enumeration enumeration = this.getAttributesTable().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(" " + string + ":" + this.getAttribute(string));
        }
        return stringBuffer.toString();
    }

    public static void printTree(AST aST) {
        if (aST == null) {
            return;
        }
        TNode.printASTNode(aST, 0);
        System.out.print("\n");
    }

    protected static void printASTNode(AST aST, int n) {
        AST aST2;
        Object object;
        String string;
        AST aST3 = aST.getFirstChild();
        System.out.print("\n");
        for (int i = 0; i < n; ++i) {
            System.out.print("   ");
        }
        if (aST3 != null) {
            System.out.print("(");
        }
        if ((string = aST.getText()) != null && string.length() > 0) {
            System.out.print(TNode.getNameForType(aST.getType()));
            System.out.print(": \"" + string + "\"");
        } else {
            System.out.print(TNode.getNameForType(aST.getType()));
        }
        if (((TNode)aST).getLineNum() != 0) {
            System.out.print(" line:" + ((TNode)aST).getLineNum());
        }
        Enumeration enumeration = ((TNode)aST).getAttributesTable().keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            System.out.print(" " + object + ":" + ((TNode)aST).getAttribute((String)object));
        }
        object = ((TNode)aST).getDefNode();
        if (object != null) {
            System.out.print("[" + TNode.getNameForType(((TNode)((Object)object)).getType()) + "]");
        }
        if (aST3 != null) {
            TNode.printASTNode(aST3, n + 1);
            System.out.print("\n");
            for (int i = 0; i < n; ++i) {
                System.out.print("   ");
            }
            System.out.print(")");
        }
        if ((aST2 = aST.getNextSibling()) != null) {
            TNode.printASTNode(aST2, n);
        }
    }

    public static String getNameForType(int n) {
        try {
            Class<?> clazz = Class.forName(tokenVocabulary);
            Field[] fieldArray = clazz.getDeclaredFields();
            if (n - 2 < fieldArray.length) {
                return fieldArray[n - 2].getName();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return "unfoundtype: " + n;
    }

    public void doubleLink() {
        TNode tNode;
        TNode tNode2 = (TNode)this.getNextSibling();
        if (tNode2 != null) {
            tNode2.left = this;
            tNode2.doubleLink();
        }
        if ((tNode = (TNode)this.getFirstChild()) != null) {
            tNode.up = this;
            tNode.doubleLink();
        }
    }

    public TNode parentOfType(int n) {
        if (this.up == null) {
            if (this.left == null) {
                return null;
            }
            return this.left.parentOfType(n);
        }
        if (this.up.getType() == n) {
            return this.up;
        }
        return this.up.parentOfType(n);
    }

    public TNode firstChildOfType(int n) {
        TNode tNode = (TNode)this.getFirstChild();
        if (tNode == null) {
            return null;
        }
        if (tNode.getType() == n) {
            return tNode;
        }
        return tNode.firstSiblingOfType(n);
    }

    public TNode firstSiblingOfType(int n) {
        TNode tNode = (TNode)this.getNextSibling();
        if (tNode == null) {
            return null;
        }
        if (tNode.getType() == n) {
            return tNode;
        }
        return tNode.firstSiblingOfType(n);
    }
}

