/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;

public class FunctionType
extends Type
implements Cloneable {
    private Type returnType;
    private ArrayList<Type> argumentTypes;
    private ArrayList<String> argumentNames;

    public FunctionType(String string, SizeThunk sizeThunk, Type type, int n) {
        super(string, sizeThunk, n);
        this.returnType = type;
    }

    @Override
    public Object clone() {
        FunctionType functionType = (FunctionType)super.clone();
        if (null != this.argumentTypes) {
            functionType.argumentTypes = (ArrayList)this.argumentTypes.clone();
        }
        if (null != this.argumentNames) {
            functionType.argumentNames = (ArrayList)this.argumentNames.clone();
        }
        return functionType;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof FunctionType)) {
            return false;
        }
        FunctionType functionType = (FunctionType)object;
        return super.equals(object) && this.returnType.equals(functionType.returnType) && FunctionType.listsEqual(this.argumentTypes, functionType.argumentTypes);
    }

    @Override
    public FunctionType asFunction() {
        return this;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public int getNumArguments() {
        return this.argumentTypes == null ? 0 : this.argumentTypes.size();
    }

    public String getArgumentName(int n) {
        return this.argumentNames.get(n);
    }

    public Type getArgumentType(int n) {
        return this.argumentTypes.get(n);
    }

    public void addArgument(Type type, String string) {
        if (this.argumentTypes == null) {
            this.argumentTypes = new ArrayList();
            this.argumentNames = new ArrayList();
        }
        this.argumentTypes.add(type);
        this.argumentNames.add(string);
    }

    public void setArgumentName(int n, String string) {
        this.argumentNames.set(n, string);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        return this.toString(string, false);
    }

    public String toString(String string, boolean bl) {
        return this.toString(string, null, bl, false);
    }

    String toString(String string, String string2, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getReturnType());
        stringBuffer.append(" ");
        if (bl2) {
            stringBuffer.append("(");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("*");
        }
        if (string != null) {
            if (bl) {
                stringBuffer.append("{@native ");
            }
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append("}");
            }
        }
        if (bl2) {
            stringBuffer.append(")");
        }
        stringBuffer.append("(");
        int n = this.getNumArguments();
        for (int i = 0; i < n; ++i) {
            Object object;
            Type type = this.getArgumentType(i);
            if (type.isFunctionPointer()) {
                object = type.asPointer().getTargetType().asFunction();
                stringBuffer.append(((FunctionType)object).toString(this.getArgumentName(i), string2, false, true));
            } else if (type.isArray()) {
                stringBuffer.append(type.asArray().toString(this.getArgumentName(i)));
            } else {
                stringBuffer.append(type);
                object = this.getArgumentName(i);
                if (object != null) {
                    stringBuffer.append(" ");
                    stringBuffer.append((String)object);
                }
            }
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        if (!bl2) {
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.returnType.visit(typeVisitor);
        int n = this.getNumArguments();
        for (int i = 0; i < n; ++i) {
            this.getArgumentType(i).visit(typeVisitor);
        }
    }

    @Override
    Type newCVVariant(int n) {
        return this;
    }
}

